/*
 * Decompiled with CFR 0.152.
 */
package gps.connection;

import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Semaphore;
import gps.connection.DecoderStateFactory;
import gps.connection.DecoderStateInterface;
import gps.connection.GPSPort;

public final class GPSrxtx {
    private static GPSPort defaultGpsPort;
    private GPSPort gpsPort;
    private DecoderStateInterface state = DecoderStateFactory.getInstance(0);
    private final BT747Semaphore writeOngoing = JavaLibBridge.getSemaphoreInstance(1);
    private final BT747Semaphore getResponseOngoing = JavaLibBridge.getSemaphoreInstance(1);
    private StringBuffer virtualInput = null;
    private String debugCon = null;
    private boolean isGpsDebug = false;
    private final Buffer buffer = new Buffer();

    public GPSrxtx() {
        this(defaultGpsPort);
    }

    public GPSrxtx(GPSPort gPSPort) {
        if (gPSPort == null) {
            Generic.debug("GPSrxtPort instance is null - review initialisation");
        }
        this.gpsPort = gPSPort;
        this.updatePortDebug();
    }

    public final void newState(int n) {
        this.newState(DecoderStateFactory.getInstance(n));
    }

    public final void newState(DecoderStateInterface decoderStateInterface) {
        if (!decoderStateInterface.equals(this.state)) {
            this.state.exitState(this);
            this.state = decoderStateInterface;
            this.state.enterState(this);
        }
    }

    public final Object getState() {
        return this.state;
    }

    public static final void setDefaultGpsPortInstance(GPSPort gPSPort) {
        defaultGpsPort = gPSPort;
    }

    public static final boolean hasDefaultPortInstance() {
        return defaultGpsPort != null;
    }

    public final GPSPort getGpsPort() {
        return this.gpsPort;
    }

    public final void setDefaults(int n, int n2) {
        this.gpsPort.setPort(n);
        this.gpsPort.setSpeed(n2);
    }

    private final int myOpenPort() {
        if (this.gpsPort == null) {
            this.gpsPort = defaultGpsPort;
        }
        return this.gpsPort.openPort();
    }

    public final void setBluetoothAndOpen() {
        this.gpsPort.setBlueTooth();
        this.myOpenPort();
    }

    public final void closePort() {
        this.gpsPort.closePort();
    }

    public final void openPort() {
        this.closePort();
        this.myOpenPort();
    }

    public final int setPortAndOpen(int n) {
        this.gpsPort.setPort(n);
        return this.myOpenPort();
    }

    public final int setFreeTextPortAndOpen(String string) {
        int n;
        if (this.gpsPort != null) {
            Generic.debug("Class" + this.gpsPort.getClass().getName());
            this.gpsPort.setFreeTextPort(string);
            n = this.myOpenPort();
            Generic.debug("Port opened");
        } else {
            Generic.debug("Must set gpsPort handler");
            n = -1;
        }
        return n;
    }

    public final String getFreeTextPort() {
        return this.gpsPort.getFreeTextPort();
    }

    public final int getPort() {
        return this.gpsPort.getPort();
    }

    public final int getSpeed() {
        return this.gpsPort.getSpeed();
    }

    public final void setBaudRate(int n) {
        this.gpsPort.setSpeed(n);
    }

    public final boolean isConnected() {
        return this.gpsPort != null && this.gpsPort.isConnected();
    }

    public final void write(String string) {
        this.writeOngoing.down();
        if (Generic.isDebug()) {
            String string2 = ">" + string + "<";
            this.gpsPort.writeDebug(string2);
        }
        this.gpsPort.write(string);
        this.writeOngoing.up();
    }

    public final void write(byte[] byArray) {
        this.writeOngoing.down();
        this.gpsPort.write(byArray);
        if (Generic.isDebug()) {
            String string = ">" + byArray.length + " bytes sent";
            if (Generic.getDebugLevel() > 1) {
                Generic.debug(string);
            }
            this.gpsPort.writeDebug(string);
        }
        this.writeOngoing.up();
    }

    public final Object getResponse() {
        this.getResponseOngoing.down();
        this.buffer.resetReadStrategy();
        if (defaultGpsPort.debugActive()) {
            defaultGpsPort.writeDebug("\r\nR:" + Generic.getTimeStamp() + ":");
        }
        Object object = this.state.getResponse(this);
        this.getResponseOngoing.up();
        return object;
    }

    public final void setDebugConn(boolean bl, String string) {
        this.debugCon = string + "/gpsRawDebug.txt";
        this.isGpsDebug = bl;
        this.updatePortDebug();
    }

    private final void updatePortDebug() {
        if (this.gpsPort != null) {
            this.gpsPort.setDebugFileName(this.debugCon);
            if (this.isGpsDebug) {
                this.gpsPort.startDebug();
            } else {
                this.gpsPort.endDebug();
            }
        }
    }

    public final boolean isDebugConn() {
        return this.isGpsDebug;
    }

    public final boolean isReadBufferEmpty() {
        return this.buffer.isReadBufferEmpty();
    }

    public final char getReadBufferChar() {
        return this.buffer.getReadBufferChar();
    }

    public final byte getReadBufferByte() {
        return this.buffer.getReadBufferByte();
    }

    private final class Buffer {
        private final byte[] read_buf = new byte[4352];
        private int read_buf_p = 0;
        private int bytesRead = 0;
        private boolean stableStrategy = false;
        private int prevReadCheck = 0;
        private boolean readAgain;

        private Buffer() {
        }

        private boolean isReadAgain() {
            return this.readAgain;
        }

        protected void resetReadStrategy() {
            this.readAgain = true;
        }

        protected final boolean isReadBufferEmpty() {
            if (this.read_buf_p >= this.bytesRead) {
                this.refillBuffer();
                if (this.bytesRead > 100 || this.isReadAgain()) {
                    this.readAgain = false;
                }
            }
            return this.read_buf_p >= this.bytesRead;
        }

        protected final char getReadBufferChar() {
            return (char)this.read_buf[this.read_buf_p++];
        }

        protected final byte getReadBufferByte() {
            return this.read_buf[this.read_buf_p++];
        }

        private final boolean refillBuffer() {
            boolean bl = true;
            this.read_buf_p = 0;
            this.bytesRead = 0;
            if (GPSrxtx.this.isConnected()) {
                Object object;
                if (GPSrxtx.this.virtualInput != null) {
                    object = GPSrxtx.this.virtualInput.toString().getBytes();
                    int n = ((byte[])object).length;
                    if (n > this.read_buf.length) {
                        n = this.read_buf.length;
                    }
                    this.bytesRead = n;
                    while (--n >= 0) {
                        this.read_buf[n] = object[n];
                    }
                    Generic.debug("Virtual:" + GPSrxtx.this.virtualInput.toString());
                    GPSrxtx.this.virtualInput = null;
                } else {
                    try {
                        int n = GPSrxtx.this.gpsPort.readCheck();
                        if (!this.stableStrategy || this.prevReadCheck == n || n > 4352) {
                            if (n > 4352) {
                                this.prevReadCheck = n - 4352;
                                n = 4352;
                            } else {
                                this.prevReadCheck = 0;
                            }
                            if (n > 0) {
                                this.bytesRead = GPSrxtx.this.gpsPort.readBytes(this.read_buf, 0, n);
                            }
                        } else {
                            this.prevReadCheck = n;
                        }
                    }
                    catch (Exception exception) {
                        this.bytesRead = 0;
                    }
                }
                if (this.bytesRead == 0) {
                    bl = false;
                } else if (GPSrxtx.this.gpsPort.debugActive()) {
                    object = "(" + Generic.getTimeStamp() + ")";
                    GPSrxtx.this.gpsPort.writeDebug(object.getBytes(), 0, object.length());
                    GPSrxtx.this.gpsPort.writeDebug(this.read_buf, 0, this.bytesRead);
                }
            }
            return bl;
        }
    }
}

