/*
 * Decompiled with CFR 0.152.
 */
package gps.convert;

import bt747.sys.I18N;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Time;
import gps.convert.ExternalUtils;
import gps.log.out.CommonOut;

public final class Conv {
    private static final byte[] daysInMonth = new byte[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    private static final String[] MONTHS_AS_SHORTTEXT = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private static final String[] MONTHS_AS_LONGTEXT = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    private static final String[] WEEKDAYS_AS_SHORTTEXT = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"};
    private static final String[] WEEKDAYS_AS_LONGTEXT = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};

    public static final int hexStringToBytes(String string, byte[] byArray) {
        int n = string.length() & 0xFFFFFFFE;
        for (int i = 0; i < n; i += 2) {
            int n2;
            switch (string.charAt(i)) {
                case '0': {
                    n2 = 0;
                    break;
                }
                case '1': {
                    n2 = 16;
                    break;
                }
                case '2': {
                    n2 = 32;
                    break;
                }
                case '3': {
                    n2 = 48;
                    break;
                }
                case '4': {
                    n2 = 64;
                    break;
                }
                case '5': {
                    n2 = 80;
                    break;
                }
                case '6': {
                    n2 = 96;
                    break;
                }
                case '7': {
                    n2 = 112;
                    break;
                }
                case '8': {
                    n2 = -128;
                    break;
                }
                case '9': {
                    n2 = -112;
                    break;
                }
                case 'A': 
                case 'a': {
                    n2 = -96;
                    break;
                }
                case 'B': 
                case 'b': {
                    n2 = -80;
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = -64;
                    break;
                }
                case 'D': 
                case 'd': {
                    n2 = -48;
                    break;
                }
                case 'E': 
                case 'e': {
                    n2 = -32;
                    break;
                }
                case 'F': 
                case 'f': {
                    n2 = -16;
                    break;
                }
                default: {
                    n2 = 0;
                }
            }
            switch (string.charAt(i + 1)) {
                case '0': {
                    break;
                }
                case '1': {
                    n2 = (byte)(n2 | 1);
                    break;
                }
                case '2': {
                    n2 = (byte)(n2 | 2);
                    break;
                }
                case '3': {
                    n2 = (byte)(n2 | 3);
                    break;
                }
                case '4': {
                    n2 = (byte)(n2 | 4);
                    break;
                }
                case '5': {
                    n2 = (byte)(n2 | 5);
                    break;
                }
                case '6': {
                    n2 = (byte)(n2 | 6);
                    break;
                }
                case '7': {
                    n2 = (byte)(n2 | 7);
                    break;
                }
                case '8': {
                    n2 = (byte)(n2 | 8);
                    break;
                }
                case '9': {
                    n2 = (byte)(n2 | 9);
                    break;
                }
                case 'A': 
                case 'a': {
                    n2 = (byte)(n2 | 0xA);
                    break;
                }
                case 'B': 
                case 'b': {
                    n2 = (byte)(n2 | 0xB);
                    break;
                }
                case 'C': 
                case 'c': {
                    n2 = (byte)(n2 | 0xC);
                    break;
                }
                case 'D': 
                case 'd': {
                    n2 = (byte)(n2 | 0xD);
                    break;
                }
                case 'E': 
                case 'e': {
                    n2 = (byte)(n2 | 0xE);
                    break;
                }
                case 'F': 
                case 'f': {
                    n2 = (byte)(n2 | 0xF);
                    break;
                }
            }
            byArray[i >> 1] = n2;
        }
        return n;
    }

    public static final int hex2Int(String string) {
        int n = string.length();
        int n2 = 0;
        block18: for (int i = 0; i < n; ++i) {
            n2 <<= 4;
            switch (string.charAt(i)) {
                case '0': {
                    n2 += 0;
                    continue block18;
                }
                case '1': {
                    ++n2;
                    continue block18;
                }
                case '2': {
                    n2 += 2;
                    continue block18;
                }
                case '3': {
                    n2 += 3;
                    continue block18;
                }
                case '4': {
                    n2 += 4;
                    continue block18;
                }
                case '5': {
                    n2 += 5;
                    continue block18;
                }
                case '6': {
                    n2 += 6;
                    continue block18;
                }
                case '7': {
                    n2 += 7;
                    continue block18;
                }
                case '8': {
                    n2 += 8;
                    continue block18;
                }
                case '9': {
                    n2 += 9;
                    continue block18;
                }
                case 'A': 
                case 'a': {
                    n2 += 10;
                    continue block18;
                }
                case 'B': 
                case 'b': {
                    n2 += 11;
                    continue block18;
                }
                case 'C': 
                case 'c': {
                    n2 += 12;
                    continue block18;
                }
                case 'D': 
                case 'd': {
                    n2 += 13;
                    continue block18;
                }
                case 'E': 
                case 'e': {
                    n2 += 14;
                    continue block18;
                }
                case 'F': 
                case 'f': {
                    n2 += 15;
                    continue block18;
                }
                default: {
                    n2 += 0;
                }
            }
        }
        return n2;
    }

    public static final int hex2SignedInt(String string) {
        int n;
        int n2 = Conv.hex2Int(string);
        if (n2 > 0 && (n = n2 >> 4 * (string.length() - 1)) >= 8) {
            n2 |= -1 << 32 - 4 * string.length();
        }
        return n2;
    }

    public static final String expandDate(String string, BT747Time bT747Time) {
        StringBuffer stringBuffer = new StringBuffer(20);
        block44: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c != '%') {
                stringBuffer.append(c);
                continue;
            }
            if (i + 1 >= string.length()) {
                stringBuffer.append(c);
                continue;
            }
            char c2 = string.charAt(++i);
            switch (c2) {
                case 'd': {
                    int n = bT747Time.getDay();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'D': {
                    stringBuffer.append(Conv.idxToWeekdayShortStr(ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear())));
                    continue block44;
                }
                case 'j': {
                    int n = bT747Time.getDay();
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'l': {
                    stringBuffer.append(Conv.idxToWeekdayStr(ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear())));
                    continue block44;
                }
                case 'N': {
                    int n = ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear());
                    if (n == 0) {
                        n = 7;
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'S': {
                    int n = bT747Time.getDay();
                    switch (n) {
                        case 1: 
                        case 21: 
                        case 31: {
                            stringBuffer.append("st");
                            break;
                        }
                        case 2: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 22: {
                            stringBuffer.append("nd");
                            break;
                        }
                        case 3: 
                        case 23: {
                            stringBuffer.append("rd");
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: 
                        case 7: 
                        case 8: 
                        case 9: 
                        case 10: 
                        case 11: 
                        case 12: 
                        case 20: 
                        case 24: 
                        case 25: 
                        case 26: 
                        case 27: 
                        case 28: 
                        case 29: 
                        case 30: {
                            stringBuffer.append("th");
                        }
                    }
                    continue block44;
                }
                case 'w': {
                    int n = ExternalUtils.getDayOfWeek(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear());
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'z': {
                    int n = JavaLibBridge.getDateInstance(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear()).dateToUTCepoch1970() - JavaLibBridge.getDateInstance(1, 1, bT747Time.getYear()).dateToUTCepoch1970();
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'W': {
                    int n = ExternalUtils.getDayOfWeek(1, 1, bT747Time.getYear());
                    int n2 = JavaLibBridge.getDateInstance(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear()).dateToUTCepoch1970() / 86400 - JavaLibBridge.getDateInstance(1, 1, bT747Time.getYear()).dateToUTCepoch1970() / 86400;
                    stringBuffer.append((n2 + 7 - n) / 7);
                    continue block44;
                }
                case 'F': {
                    stringBuffer.append(Conv.idxToMonthStr(bT747Time.getMonth() - 1));
                    continue block44;
                }
                case 'm': {
                    int n = bT747Time.getMonth();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'M': {
                    String string2 = Conv.idxToShortMonthStr(bT747Time.getMonth() - 1);
                    stringBuffer.append(string2.charAt(0));
                    stringBuffer.append(string2.substring(1).toLowerCase());
                    continue block44;
                }
                case 'n': {
                    int n = bT747Time.getDay();
                    stringBuffer.append(n);
                    continue block44;
                }
                case 't': {
                    stringBuffer.append(Conv.getDaysInMonth(bT747Time.getMonth(), bT747Time.getYear()));
                    continue block44;
                }
                case 'L': {
                    continue block44;
                }
                case 'o': {
                    continue block44;
                }
                case 'Y': {
                    stringBuffer.append(bT747Time.getYear());
                    continue block44;
                }
                case 'y': {
                    stringBuffer.append(bT747Time.getYear() % 100);
                    continue block44;
                }
                case 'a': {
                    if (bT747Time.getHour() < 12) {
                        stringBuffer.append("am");
                        continue block44;
                    }
                    stringBuffer.append("pm");
                    continue block44;
                }
                case 'A': {
                    if (bT747Time.getHour() < 12) {
                        stringBuffer.append("AM");
                        continue block44;
                    }
                    stringBuffer.append("PM");
                    continue block44;
                }
                case 'B': {
                    continue block44;
                }
                case 'g': {
                    stringBuffer.append(bT747Time.getHour() % 12);
                    continue block44;
                }
                case 'G': {
                    stringBuffer.append(bT747Time.getHour());
                    continue block44;
                }
                case 'h': {
                    int n = bT747Time.getHour() % 12;
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'H': {
                    int n = bT747Time.getHour();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'i': {
                    int n = bT747Time.getMinute();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 's': {
                    int n = bT747Time.getSecond();
                    if (n < 10) {
                        stringBuffer.append('0');
                    }
                    stringBuffer.append(n);
                    continue block44;
                }
                case 'u': {
                    continue block44;
                }
                case 'e': {
                    continue block44;
                }
                case 'I': {
                    continue block44;
                }
                case 'O': 
                case 'P': {
                    continue block44;
                }
                case 'T': {
                    continue block44;
                }
                case 'Z': {
                    continue block44;
                }
                case 'c': {
                    stringBuffer.append(CommonOut.getDateTimeISO8601(bT747Time, 0));
                    continue block44;
                }
                case 'r': {
                    continue block44;
                }
                case 'U': {
                    int n = JavaLibBridge.getDateInstance(bT747Time.getDay(), bT747Time.getMonth(), bT747Time.getYear()).dateToUTCepoch1970() + bT747Time.getHour() * 3600 + bT747Time.getMinute() * 60 + bT747Time.getSecond();
                    stringBuffer.append(n);
                    continue block44;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private static final int getDaysInMonth(int n, int n2) {
        int n3 = n - 1;
        byte by = n3 == 1 && Conv.isLeapYear(n2) ? (byte)1 : 0;
        return daysInMonth[n3] + by;
    }

    private static final boolean isLeapYear(int n) {
        return n % 4 == 0 && (n % 100 != 0 || n % 400 == 0);
    }

    public static final String idxToShortMonthStr(int n) {
        return I18N.i18n(MONTHS_AS_SHORTTEXT[n]);
    }

    public static final String idxToMonthStr(int n) {
        return I18N.i18n(MONTHS_AS_LONGTEXT[n]);
    }

    public static final String idxToWeekdayShortStr(int n) {
        return I18N.i18n(WEEKDAYS_AS_SHORTTEXT[n]);
    }

    public static final String idxToWeekdayStr(int n) {
        return I18N.i18n(WEEKDAYS_AS_LONGTEXT[n]);
    }
}

