/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.BT747Constants;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class BT747LogConvert
extends GPSLogConvertInterface {
    private int minRecordSize;
    private int maxRecordSize;
    private int logFormat;
    protected boolean passToFindFieldsActivatedInLog = false;
    protected int activeFileFields = 0;
    private boolean firstBlockDone = false;
    private int satIdxOffset;
    private int satRecSize;
    private boolean holux = false;
    private boolean nextPointIsWayPt = false;
    private int initialBlock = 0;
    private int badRecordReportCount = 0;
    private int invalidCount = 0;
    private int errorReportLimit = 30;
    private static final int minValidUtcTime = JavaLibBridge.getDateInstance(1, 1, 1995).dateToUTCepoch1970();
    private int recCount;
    private boolean lastRecordIsBad = false;
    private int error;
    private int logMode = 0;
    private int rcr_mask = 0;
    private int logSpeed = 0;
    private int logDistance = 0;
    private int logPeriod = 0;
    private int prevLogModeRecNbr = 0;

    private void updateLogFormat(GPSFileConverterInterface gPSFileConverterInterface, int n) {
        this.logFormat = n;
        this.activeFileFields |= this.logFormat;
        if (!this.passToFindFieldsActivatedInLog) {
            gPSFileConverterInterface.writeLogFmtHeader(GPSRecord.getLogFormatRecord(this.logFormat));
        }
        this.minRecordSize = BT747Constants.logRecordMinSize(this.logFormat, this.getLoggerType());
        this.maxRecordSize = BT747Constants.logRecordMaxSize(this.logFormat, this.getLoggerType());
        int[] nArray = BT747Constants.logRecordSatOffsetAndSize(this.logFormat, this.getLoggerType());
        this.satIdxOffset = nArray[0];
        this.satRecSize = nArray[1];
    }

    private void isBadRecord(int n, int n2) {
        if (!this.lastRecordIsBad) {
            if (this.badRecordReportCount <= this.errorReportLimit) {
                Generic.debug("Bad record(s) @" + n + "(" + JavaLibBridge.unsigned2hex(n2, 8) + ")", null);
                if (this.badRecordReportCount == this.errorReportLimit) {
                    Generic.debug("Error limit reached.  Not reporting further error.");
                }
            }
            ++this.badRecordReportCount;
            this.lastRecordIsBad = true;
        }
    }

    private void isGoodRecord(int n) {
        if (this.lastRecordIsBad) {
            if (this.invalidCount <= this.errorReportLimit) {
                Generic.debug("Recovered (" + JavaLibBridge.unsigned2hex(n, 8) + ")", null);
            }
            this.lastRecordIsBad = false;
        }
    }

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        int n;
        WindowedFile windowedFile = (WindowedFile)object;
        GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = 0;
        int n3 = Integer.MAX_VALUE;
        int n4 = 0;
        int n5 = 0;
        this.recCount = 0;
        this.logFormat = 0;
        int n6 = this.initialBlock;
        if (n6 != 0) {
            bl3 = true;
        }
        this.nextPointIsWayPt = false;
        this.badRecordReportCount = 0;
        this.lastRecordIsBad = false;
        try {
            n = windowedFile.getSize();
        }
        catch (Exception exception) {
            Generic.debug("getSize", exception);
            n = 0;
        }
        while (!this.stop && n6 < n) {
            byte[] byArray;
            int n7;
            int n8;
            int n9 = -1;
            if ((n6 & 0xFFFF) < 512) {
                n6 &= 0xFFFF0000;
            }
            if ((n8 = (n7 = n6 & 0xFFFF0000 | 0xFFFF) + 1 - n6) > 2048) {
                n8 = 2048;
            }
            if (n8 + n6 > n) {
                n8 = n - n6;
            }
            boolean bl4 = true;
            int n10 = 0;
            try {
                byArray = windowedFile.fillBuffer(n6);
            }
            catch (Exception exception) {
                Generic.debug("Problem reading file", exception);
                byArray = null;
            }
            if (byArray == null) {
                Generic.debug("fillBuffer failed", null);
                this.errorInfo = windowedFile.getPath() + "|" + windowedFile.getLastError();
                return -3;
            }
            if ((n6 & 0xFFFF) == 0) {
                if (bl2 && n2 != 0 && n2 < n3) {
                    n3 = n2;
                    n4 = n5;
                }
                n2 = 0;
                n5 = n6;
                int n11 = (0xFF & byArray[2]) << 0 | (0xFF & byArray[3]) << 8 | (0xFF & byArray[4]) << 16 | (0xFF & byArray[5]) << 24;
                this.setLogMode(gPSFileConverterInterface, (0xFF & byArray[6]) << 0 | (0xFF & byArray[7]) << 8);
                boolean bl5 = bl = (this.logMode & 4) == 0;
                if (bl && !this.firstBlockDone) {
                    bl2 = true;
                }
                this.firstBlockDone = true;
                this.logPeriod = (0xFF & byArray[8]) << 0 | (0xFF & byArray[9]) << 8 | (0xFF & byArray[10]) << 16 | (0xFF & byArray[11]) << 24;
                this.logDistance = (0xFF & byArray[12]) << 0 | (0xFF & byArray[13]) << 8 | (0xFF & byArray[14]) << 16 | (0xFF & byArray[15]) << 24;
                this.logSpeed = (0xFF & byArray[16]) << 0 | (0xFF & byArray[17]) << 8 | (0xFF & byArray[18]) << 16 | (0xFF & byArray[19]) << 24;
                this.rcr_mask = 0;
                this.rcr_mask = this.logPeriod != 0 ? (this.rcr_mask |= 1) : (this.rcr_mask &= 0xFFFFFFFE);
                this.rcr_mask = this.logDistance != 0 ? (this.rcr_mask |= 4) : (this.rcr_mask &= 0xFFFFFFFB);
                this.rcr_mask = this.logSpeed != 0 ? (this.rcr_mask |= 2) : (this.rcr_mask &= 0xFFFFFFFD);
                if (n11 == -1) {
                    n11 = this.logFormat == 0 ? -2147483619 : this.logFormat;
                }
                if (n11 != this.logFormat) {
                    this.updateLogFormat(gPSFileConverterInterface, n11);
                }
                n6 += 512;
                bl4 = false;
            } else {
                n6 += n8;
            }
            while (bl4) {
                int n12;
                int n13;
                int n14 = 1;
                while (n14 != 0 && n8 - 20 > n10) {
                    n13 = this.getSpecialRecord(byArray, n10, gPSFileConverterInterface);
                    n12 = n6 - n8 + n10;
                    if (this.recCount == 0 && !this.firstBlockDone && (this.logMode & 4) == 0) {
                        bl2 = true;
                        this.firstBlockDone = true;
                    }
                    if ((n14 = n13 != 0 ? 1 : 0) == 0) continue;
                    gPSRecord = GPSRecord.getLogFormatRecord(0);
                    this.isGoodRecord(n6 - n8 + n10);
                    n9 = n10 += n13;
                }
                n13 = 0;
                n12 = 0;
                if (n8 > n10 + this.minRecordSize + (this.holux ? 1 : 2)) {
                    int n15 = n10;
                    int n16 = 0;
                    int n17 = 255;
                    n13 = 0;
                    int n18 = 0;
                    int n19 = 0;
                    int n20 = 0;
                    if ((this.logFormat & 0x2000) != 0) {
                        n19 = n10 + this.satIdxOffset;
                        n18 = (0xFF & byArray[n19 + 2]) << 0 | (0xFF & byArray[n19 + 3]) << 8;
                        if (n18 > 32 || n18 < 0) {
                            n18 = 32;
                        }
                        if (n18 != 0) {
                            n20 = n18 * this.satRecSize - 4;
                        }
                    }
                    if (this.minRecordSize + n20 + n10 <= n8 - 2) {
                        int n21 = this.minRecordSize + n20 + n10 - n15;
                        while (n21-- > 0) {
                            n17 &= byArray[n15];
                            n16 ^= byArray[n15++];
                        }
                        if (n17 != 255 && (!this.holux && byArray[n15] == 42 && (n16 & 0xFF) == (0xFF & byArray[n15 + 1]) || this.holux && (n16 & 0xFF) == (0xFF & byArray[n15]))) {
                            if (!this.holux) {
                                n15 += 2;
                            }
                            int n22 = n10;
                            n10 = ++n15;
                            int n23 = !this.holux ? n10 - 2 - (((this.logFormat & 0x80000) != 0 ? BT747Constants.logFmtByteSizes[19] : (byte)0) + ((this.logFormat & 0x40000) != 0 ? BT747Constants.logFmtByteSizes[18] : (byte)0) + ((this.logFormat & 0x20000) != 0 ? BT747Constants.logFmtByteSizes[17] : 0) + ((this.logFormat & 0x100000) != 0 ? BT747Constants.logFmtByteSizes[20] : 0)) : n10 - 1 - (((this.logFormat & 0x80000) != 0 ? BT747Constants.logFmtByteSizesHolux[19] : (byte)0) + ((this.logFormat & 0x40000) != 0 ? BT747Constants.logFmtByteSizesHolux[18] : (byte)0) + ((this.logFormat & 0x20000) != 0 ? BT747Constants.logFmtByteSizesHolux[17] : 0) + ((this.logFormat & 0x100000) != 0 ? BT747Constants.logFmtByteSizesHolux[20] : 0));
                            gPSRecord.recCount = ++this.recCount;
                            if (this.passToFindFieldsActivatedInLog && !bl2) {
                                n9 = n15;
                                n13 = 1;
                            } else {
                                boolean bl6 = this.getRecord(byArray, gPSRecord, n22, n23, n18);
                                int n24 = n6 - n8 + n22;
                                if (bl6) {
                                    if (!bl2) {
                                        gPSFileConverterInterface.addLogRecord(gPSRecord);
                                        gPSRecord = GPSRecord.getLogFormatRecord(0);
                                    } else if (gPSRecord.hasUtc() && gPSRecord.utc > n2) {
                                        n2 = gPSRecord.utc;
                                    }
                                    this.isGoodRecord(n24);
                                    n9 = n10;
                                    n13 = 1;
                                } else {
                                    this.isBadRecord(gPSRecord.recCount, n24);
                                    --this.recCount;
                                    n10 = n22;
                                    n13 = 0;
                                }
                            }
                            n12 |= n13;
                        } else if ((byArray[n15] & 0xFF) == 255 && (this.holux || (0xFF & byArray[n15 + 1]) == 255)) {
                            if (!this.holux) {
                                n15 += 2;
                            }
                            n10 = ++n15;
                            n9 = n15;
                            n12 = 1;
                        } else {
                            this.isBadRecord(this.recCount, n6 - n8 + n10);
                        }
                    } else {
                        bl4 = false;
                    }
                    n14 = n13;
                }
                if (n12 != 0 || !bl4) continue;
                if (n8 > n10 + this.maxRecordSize + (this.holux ? 1 : 2)) {
                    ++n10;
                    continue;
                }
                bl4 = false;
            }
            if (n9 > 0) {
                n6 -= n8 - n9;
            }
            if (n6 < n || !bl3) continue;
            bl3 = false;
            n6 = 0;
            n = this.initialBlock;
        }
        if (bl2) {
            if (n2 != 0 && n2 < n3) {
                n3 = n2;
                n4 = n5;
            }
            this.initialBlock = n4;
        }
        if (bl2 && !this.passToFindFieldsActivatedInLog) {
            return this.parseFile(windowedFile, gPSFileConverterInterface);
        }
        return 0;
    }

    protected Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(2048);
                this.errorInfo = bT747Path.toString() + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public final int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        Object object = null;
        this.error = 0;
        this.stop = false;
        object = this.getFileObject(bT747Path);
        if (object != null) {
            this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
            if (this.passToFindFieldsActivatedInLog) {
                this.activeFileFields = 0;
                this.error = this.parseFile(object, gPSFileConverterInterface);
                gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(this.activeFileFields));
            }
            this.passToFindFieldsActivatedInLog = false;
            if (this.error == 0) {
                do {
                    this.error = this.parseFile(object, gPSFileConverterInterface);
                } while (this.error == 0 && gPSFileConverterInterface.nextPass());
            }
            gPSFileConverterInterface.finaliseFile();
            if (gPSFileConverterInterface.getNbrFilesCreated() == 0) {
                this.error = -2;
            }
            try {
                this.closeFileObject(object);
            }
            catch (Exception exception) {
                Generic.debug("close", exception);
            }
        }
        Generic.debug("Conversion done", null);
        return this.error;
    }

    public final void setLoggerType(int n) {
        super.setLoggerType(n);
        switch (this.getLoggerType()) {
            case 4: 
            case 5: {
                this.holux = true;
            }
        }
    }

    private final int getSpecialRecord(byte[] byArray, int n, GPSFileConverterInterface gPSFileConverterInterface) {
        int n2 = 0;
        if ((0xFF & byArray[n + 0]) == 170 && (0xFF & byArray[n + 1]) == 170 && (0xFF & byArray[n + 2]) == 170 && (0xFF & byArray[n + 3]) == 170 && (0xFF & byArray[n + 4]) == 170 && (0xFF & byArray[n + 5]) == 170 && (0xFF & byArray[n + 6]) == 170 && (0xFF & byArray[n + 12]) == 187 && (0xFF & byArray[n + 13]) == 187 && (0xFF & byArray[n + 14]) == 187 && (0xFF & byArray[n + 15]) == 187) {
            int n3 = (0xFF & byArray[n + 8]) << 0 | (0xFF & byArray[n + 9]) << 8 | (0xFF & byArray[n + 10]) << 16 | (0xFF & byArray[n + 11]) << 24;
            int n4 = 0xFF & byArray[n + 7];
            switch (n4) {
                case 2: {
                    int n5 = n3;
                    if (n5 == this.logFormat) break;
                    this.updateLogFormat(gPSFileConverterInterface, n5);
                    break;
                }
                case 3: {
                    this.logPeriod = n3;
                    if (n3 != 0) {
                        this.rcr_mask |= 1;
                        break;
                    }
                    this.rcr_mask &= 0xFFFFFFFE;
                    break;
                }
                case 4: {
                    this.logDistance = n3;
                    if (n3 != 0) {
                        this.rcr_mask |= 4;
                        break;
                    }
                    this.rcr_mask &= 0xFFFFFFFB;
                    break;
                }
                case 5: {
                    this.logSpeed = n3;
                    if (n3 != 0) {
                        this.rcr_mask |= 2;
                        break;
                    }
                    this.rcr_mask &= 0xFFFFFFFD;
                    break;
                }
                case 6: {
                    this.setLogMode(gPSFileConverterInterface, n3);
                    break;
                }
                case 7: {
                    this.setLogMode(gPSFileConverterInterface, n3);
                    break;
                }
            }
            n2 += 16;
        } else if ((0xFF & byArray[n + 0]) == 72 && (0xFF & byArray[n + 1]) == 79 && (0xFF & byArray[n + 2]) == 76 && (0xFF & byArray[n + 3]) == 85 && (0xFF & byArray[n + 4]) == 88) {
            if (!this.holux) {
                this.holux = true;
                this.updateLogFormat(gPSFileConverterInterface, this.logFormat);
            }
            n2 += 16;
            if ((0xFF & byArray[n + 10]) == 87 && (0xFF & byArray[n + 11]) == 65 && (0xFF & byArray[n + 12]) == 89 && (0xFF & byArray[n + 13]) == 80 && (0xFF & byArray[n + 14]) == 78 && (0xFF & byArray[n + 15]) == 84) {
                this.nextPointIsWayPt = true;
            }
            if ((0xFF & byArray[n + 16]) == 32 && (0xFF & byArray[n + 17]) == 32 && (0xFF & byArray[n + 18]) == 32 && (0xFF & byArray[n + 19]) == 32) {
                n2 += 4;
            }
        }
        return n2;
    }

    private final void setLogMode(GPSFileConverterInterface gPSFileConverterInterface, int n) {
        if ((this.logMode & 2) > (n & 2) && this.prevLogModeRecNbr == this.recCount) {
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            gPSRecord.setVoxStr("logon");
            gPSFileConverterInterface.addLogRecord(gPSRecord);
        }
        this.prevLogModeRecNbr = this.recCount;
        this.logMode = n;
    }

    private boolean getRecord(byte[] byArray, GPSRecord gPSRecord, int n, int n2, int n3) {
        long l;
        int n4 = n;
        boolean bl = true;
        String string = "";
        if ((this.logFormat & 1) != 0) {
            gPSRecord.logPeriod = this.logPeriod;
            gPSRecord.logDistance = this.logDistance;
            gPSRecord.logSpeed = this.logSpeed;
            gPSRecord.utc = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
            if ((gPSRecord.utc & Integer.MIN_VALUE) != 0) {
                string = string + "Invalid time:" + gPSRecord.utc + ";";
                bl = false;
            }
        }
        if ((this.logFormat & 2) != 0) {
            gPSRecord.valid = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
        }
        if ((this.logFormat & 4) != 0) {
            if (!this.holux) {
                l = (0xFFL & (long)byArray[n4++]) << 0 | (0xFFL & (long)byArray[n4++]) << 8 | (0xFFL & (long)byArray[n4++]) << 16 | (0xFFL & (long)byArray[n4++]) << 24 | (0xFFL & (long)byArray[n4++]) << 32 | (0xFFL & (long)byArray[n4++]) << 40 | (0xFFL & (long)byArray[n4++]) << 48 | (0xFFL & (long)byArray[n4++]) << 56;
                gPSRecord.latitude = JavaLibBridge.longBitsToDouble(l);
            } else {
                int n5 = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                gPSRecord.latitude = JavaLibBridge.toFloatBitwise(n5);
            }
            if (gPSRecord.latitude > 90.0 || gPSRecord.latitude < -90.0) {
                string = string + "Invalid latitude:" + gPSRecord.latitude + ";";
                bl = false;
            }
        }
        if ((this.logFormat & 8) != 0) {
            if (!this.holux) {
                l = (0xFFL & (long)byArray[n4++]) << 0 | (0xFFL & (long)byArray[n4++]) << 8 | (0xFFL & (long)byArray[n4++]) << 16 | (0xFFL & (long)byArray[n4++]) << 24 | (0xFFL & (long)byArray[n4++]) << 32 | (0xFFL & (long)byArray[n4++]) << 40 | (0xFFL & (long)byArray[n4++]) << 48 | (0xFFL & (long)byArray[n4++]) << 56;
                gPSRecord.longitude = JavaLibBridge.longBitsToDouble(l);
            } else {
                int n6 = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                gPSRecord.longitude = JavaLibBridge.toFloatBitwise(n6);
            }
            if (gPSRecord.longitude > 180.0 || gPSRecord.longitude < -180.0) {
                string = string + "Invalid longitude:" + gPSRecord.longitude + ";";
                bl = false;
            }
        }
        if (this.getLoggerType() == 4) {
            if ((this.logFormat & 0x20) != 0) {
                int n7 = 0xFF & byArray[n4++] | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                gPSRecord.speed = (float)n7 * 0.036f;
            }
            if ((this.logFormat & 0x10) != 0) {
                int n8 = (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                gPSRecord.height = JavaLibBridge.toFloatBitwise(n8);
            }
        } else {
            if ((this.logFormat & 0x10) != 0) {
                if (!this.holux) {
                    int n9 = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                    gPSRecord.height = JavaLibBridge.toFloatBitwise(n9);
                } else {
                    int n10 = (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                    gPSRecord.height = JavaLibBridge.toFloatBitwise(n10);
                }
            }
            if ((this.logFormat & 0x20) != 0) {
                int n11 = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
                gPSRecord.speed = JavaLibBridge.toFloatBitwise(n11);
            }
        }
        if (gPSRecord.hasHeight()) {
            if (bl) {
                CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
            }
            if ((gPSRecord.valid & 1) != 1 && ((double)gPSRecord.height < -3000.0 || (double)gPSRecord.height > 15000.0)) {
                string = string + "Invalid height:" + gPSRecord.height + ";";
                bl = false;
            }
        }
        if (gPSRecord.hasSpeed() && (double)gPSRecord.speed < -10.0) {
            string = string + "Invalid speed:" + gPSRecord.speed + ";";
            bl = false;
        }
        if ((this.logFormat & 0x40) != 0) {
            int n12 = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
            gPSRecord.heading = JavaLibBridge.toFloatBitwise(n12);
        }
        if ((this.logFormat & 0x80) != 0) {
            gPSRecord.dsta = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
        }
        if ((this.logFormat & 0x100) != 0) {
            gPSRecord.dage = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 | (0xFF & byArray[n4++]) << 16 | (0xFF & byArray[n4++]) << 24;
        }
        if ((this.logFormat & 0x200) != 0) {
            gPSRecord.pdop = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
        }
        if ((this.logFormat & 0x400) != 0) {
            gPSRecord.hdop = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
        }
        if ((this.logFormat & 0x800) != 0) {
            gPSRecord.vdop = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
        }
        if ((this.logFormat & 0x1000) != 0) {
            gPSRecord.nsat = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
        }
        int n13 = 0;
        int n14 = 0;
        if (n2 - n4 > 0) {
            n13 = (0xFF & byArray[n4 + 2]) << 0 | (0xFF & byArray[n4 + 3]) << 8;
            gPSRecord.sid = new int[n13];
            gPSRecord.sidinuse = new boolean[n13];
            gPSRecord.ele = new int[n13];
            gPSRecord.azi = new int[n13];
            gPSRecord.snr = new int[n13];
            if (n13 == 0) {
                n4 += 4;
            }
        }
        if (n3 == n13) {
            while (n13-- > 0) {
                if ((this.logFormat & 0x2000) != 0) {
                    gPSRecord.sid[n14] = (0xFF & byArray[n4++]) << 0;
                    gPSRecord.sidinuse[n14] = (0xFF & byArray[n4++]) << 0 != 0;
                    n4 += 2;
                }
                if ((this.logFormat & 0x4000) != 0) {
                    gPSRecord.ele[n14] = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
                }
                if ((this.logFormat & 0x8000) != 0) {
                    gPSRecord.azi[n14] = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
                }
                if ((this.logFormat & 0x10000) != 0) {
                    gPSRecord.snr[n14] = (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8;
                }
                ++n14;
            }
        } else {
            string = string + "Problem in sat decode;";
            bl = false;
        }
        if (n4 != n2) {
            string = string + "Problem in sat decode (end idx);";
            bl = false;
        }
        n4 = n2;
        gPSRecord.rcr = (this.logFormat & 0x20000) != 0 ? (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 : this.rcr_mask;
        if (this.nextPointIsWayPt) {
            gPSRecord.rcr |= 8;
            this.nextPointIsWayPt = false;
        }
        gPSRecord.milisecond = (this.logFormat & 0x40000) != 0 ? (0xFF & byArray[n4++]) << 0 | (0xFF & byArray[n4++]) << 8 : 0;
        if ((this.logFormat & 0x80000) != 0) {
            l = (0xFFL & (long)byArray[n4++]) << 0 | (0xFFL & (long)byArray[n4++]) << 8 | (0xFFL & (long)byArray[n4++]) << 16 | (0xFFL & (long)byArray[n4++]) << 24 | (0xFFL & (long)byArray[n4++]) << 32 | (0xFFL & (long)byArray[n4++]) << 40 | (0xFFL & (long)byArray[n4++]) << 48 | (0xFFL & (long)byArray[n4++]) << 56;
            gPSRecord.distance = JavaLibBridge.longBitsToDouble(l);
        }
        if (!bl) {
            if (this.invalidCount <= this.errorReportLimit) {
                Generic.debug("Log corrupted?: " + string);
                if (this.invalidCount == this.errorReportLimit) {
                    Generic.debug("Error limit reached.  Not reporting further error.");
                }
            }
            ++this.invalidCount;
        }
        return bl;
    }

    public int getType() {
        return 8;
    }
}

