/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.interfaces.BT747Path;
import gps.log.in.BT747LogConvert;
import gps.log.in.CSVLogConvert;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.HoluxTrl2LogConvert;
import gps.log.in.HoluxTrlLogConvert;
import gps.log.in.NMEALogConvert;
import gps.log.in.SkytraqLogConvert;
import gps.log.in.SonyResultConvert;
import gps.log.in.WPLogConvert;

public class GPSInputConversionFactory {
    protected GPSInputConversionFactory next = null;
    protected static GPSInputConversionFactory head = new DefaultGPSOutputFactory();

    public static final GPSInputConversionFactory getHandler() {
        return head;
    }

    public GPSLogConvertInterface getInputConversionInstance(BT747Path bT747Path, int n) {
        if (this.next != null) {
            return this.next.getInputConversionInstance(bT747Path, n);
        }
        return null;
    }

    private static final class DefaultGPSOutputFactory
    extends GPSInputConversionFactory {
        private DefaultGPSOutputFactory() {
        }

        public final GPSLogConvertInterface getInputConversionInstance(BT747Path bT747Path, int n) {
            String string = bT747Path.getPath().toLowerCase();
            if (string.endsWith(".trl")) {
                return new HoluxTrlLogConvert();
            }
            if (string.endsWith(".trl2")) {
                return new HoluxTrl2LogConvert();
            }
            if (string.endsWith(".csv")) {
                return new CSVLogConvert();
            }
            if (string.endsWith(".nmea") || string.endsWith(".nme") || string.endsWith(".nma") || string.endsWith(".txt")) {
                return new NMEALogConvert();
            }
            if (string.endsWith(".log")) {
                if (n == 6) {
                    return new SkytraqLogConvert();
                }
                return new NMEALogConvert();
            }
            if (string.endsWith(".sr")) {
                return new WPLogConvert();
            }
            if (string.endsWith(".result")) {
                return new SonyResultConvert();
            }
            if (n == 6) {
                return new SkytraqLogConvert();
            }
            return new BT747LogConvert();
        }
    }
}

