/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747StringTokenizer;
import gps.convert.Conv;
import gps.log.GPSRecord;
import gps.log.in.CommonIn;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class NMEALogConvert
extends GPSLogConvertInterface {
    private int logFormat;
    protected boolean passToFindFieldsActivatedInLog = false;
    protected int activeFileFields = 0;
    private int error;

    public final int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        WindowedFile windowedFile = (WindowedFile)object;
        GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
        int n = 0;
        try {
            int n2;
            int n3 = 0;
            this.logFormat = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = windowedFile.getSize();
            try {
                n6 = windowedFile.getSize();
            }
            catch (Exception exception) {
                Generic.debug("getSize", exception);
                n6 = 0;
            }
            while (!this.stop && n5 < n6) {
                byte[] byArray;
                int n7 = 2048;
                if (n7 + n5 > n6) {
                    n7 = n6 - n5;
                }
                boolean bl = true;
                n2 = 0;
                try {
                    byArray = windowedFile.fillBuffer(n5);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    this.errorInfo = windowedFile.getPath() + "|" + windowedFile.getLastError();
                    return -3;
                }
                n5 += n7;
                do {
                    int n8;
                    for (n8 = n2; n8 < n7 && (byArray[n8] == 10 || byArray[n8] == 13); ++n8) {
                    }
                    while (n8 < n7 && byArray[n8] != 10 && byArray[n8] != 13) {
                        ++n8;
                    }
                    boolean bl2 = bl = n8 < n7;
                    if (!bl) continue;
                    StringBuffer stringBuffer = new StringBuffer(n8 - n2 + 1);
                    byte by = 0;
                    String string = "";
                    byte by2 = byArray[n2];
                    for (int i = n2 + 1; i < n8 - 3; ++i) {
                        stringBuffer.append((char)byArray[i]);
                        by = (byte)(by ^ byArray[i]);
                    }
                    try {
                        string = string + (char)byArray[n8 - 2];
                        string = string + (char)byArray[n8 - 1];
                    }
                    catch (Exception exception) {
                        Generic.debug("eolPos " + n8, exception);
                    }
                    by = (byte)(by ^ Conv.hex2Int(string));
                    BT747StringTokenizer bT747StringTokenizer = JavaLibBridge.getStringTokenizerInstance(stringBuffer.toString(), ',');
                    for (n2 = n8; n2 < n7 && (byArray[n2] == 10 || byArray[n2] == 13); ++n2) {
                    }
                    if (by2 != 36 || byArray[n8 - 3] != 42 || by != 0 || stringBuffer.length() == 0 || !bT747StringTokenizer.hasMoreTokens()) continue;
                    String string2 = bT747StringTokenizer.nextToken();
                    String[] stringArray = new String[bT747StringTokenizer.countTokens() + 1];
                    int n9 = 0;
                    stringArray[n9++] = string2;
                    while (bT747StringTokenizer.hasMoreTokens()) {
                        stringArray[n9++] = bT747StringTokenizer.nextToken();
                    }
                    GPSRecord gPSRecord2 = GPSRecord.getLogFormatRecord(0);
                    int n10 = CommonIn.analyzeNMEA(stringArray, gPSRecord2);
                    if ((n10 & 1) != 0 && (n4 & 1) != 0) {
                        int n11 = gPSRecord.utc % 86400;
                        int n12 = (gPSRecord.utc - n11) / 86400;
                        int n13 = gPSRecord2.utc / 86400;
                        if (n11 != 0 && n11 != gPSRecord2.utc % 86400 || n12 != 0 && n13 != 0 && n12 != n13 || gPSRecord.milisecond != gPSRecord2.milisecond) {
                            gPSRecord.recCount = ++n3;
                            if (n12 == 0 && n != 0) {
                                gPSRecord.utc += n * 24 * 3600;
                            } else {
                                n = n12;
                            }
                            this.finalizeRecord(gPSFileConverterInterface, gPSRecord, n4);
                            gPSRecord = gPSRecord2;
                            n4 = n10;
                            continue;
                        }
                        n4 |= CommonIn.analyzeNMEA(stringArray, gPSRecord);
                        continue;
                    }
                    n4 |= CommonIn.analyzeNMEA(stringArray, gPSRecord);
                } while (bl);
                if (n2 == 0) {
                    Generic.debug(n5 - n7 + "skipping invalid NMEA data", null);
                    n2 = n7 - 512;
                }
                n5 -= n7 - n2;
            }
            if (n4 != 0) {
                gPSRecord.recCount = ++n3;
                int n14 = gPSRecord.utc % 86400;
                n2 = (gPSRecord.utc - n14) / 86400;
                if (n2 == 0 && n != 0) {
                    gPSRecord.utc += n * 3600 * 24;
                }
                this.finalizeRecord(gPSFileConverterInterface, gPSRecord, n4);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    private void finalizeRecord(GPSFileConverterInterface gPSFileConverterInterface, GPSRecord gPSRecord, int n) {
        CommonIn.convertHeight(gPSRecord, this.factorConversionWGS84ToMSL);
        if (n != this.logFormat) {
            this.updateLogFormat(gPSFileConverterInterface, n);
        }
        if (!gPSRecord.hasValid()) {
            gPSRecord.valid = 2;
        }
        if (n != 0 && !this.passToFindFieldsActivatedInLog) {
            gPSFileConverterInterface.addLogRecord(gPSRecord);
        }
    }

    protected Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(2048);
                this.errorInfo = bT747Path + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public final int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            Object object = this.getFileObject(bT747Path);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    this.activeFileFields = 0;
                    this.error = this.parseFile(object, gPSFileConverterInterface);
                    gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(this.activeFileFields));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    private void updateLogFormat(GPSFileConverterInterface gPSFileConverterInterface, int n) {
        this.logFormat = n;
        this.activeFileFields |= this.logFormat;
        if (!this.passToFindFieldsActivatedInLog) {
            gPSFileConverterInterface.writeLogFmtHeader(GPSRecord.getLogFormatRecord(this.logFormat));
        }
    }

    public int getType() {
        return 5;
    }
}

