/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Path;
import gps.log.GPSRecord;
import gps.log.in.GPSFileConverterInterface;
import gps.log.in.GPSLogConvertInterface;
import gps.log.in.WindowedFile;

public final class SonyResultConvert
extends GPSLogConvertInterface {
    protected boolean passToFindFieldsActivatedInLog = false;
    protected int activeFileFields = 29;
    private int error;

    public int parseFile(Object object, GPSFileConverterInterface gPSFileConverterInterface) {
        try {
            WindowedFile windowedFile = (WindowedFile)object;
            GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
            GPSRecord gPSRecord2 = new GPSRecord();
            if (!this.passToFindFieldsActivatedInLog) {
                gPSFileConverterInterface.writeLogFmtHeader(GPSRecord.getLogFormatRecord(29));
            }
            int n = 0;
            int n2 = 0;
            int n3 = windowedFile.getSize();
            while (!this.stop && n2 + 26 < n3) {
                byte[] byArray;
                int n4 = 4096;
                if (n4 + n2 > n3) {
                    n4 = n3 - n2;
                }
                int n5 = 0;
                try {
                    byArray = windowedFile.fillBuffer(n2);
                }
                catch (Exception exception) {
                    Generic.debug("Problem reading file", exception);
                    byArray = null;
                }
                if (byArray == null) {
                    Generic.debug("fillBuffer failed", null);
                    this.errorInfo = windowedFile.getPath() + "|" + windowedFile.getLastError();
                    return -3;
                }
                block11: while (!this.stop && n5 + 26 < n4) {
                    int n6 = (byArray[n5] & 0xFF) << 8 | byArray[n5 + 1];
                    switch (n6) {
                        case 0: {
                            n5 += 2;
                            continue block11;
                        }
                        case 21068: {
                            n5 += 12;
                            continue block11;
                        }
                        case 21060: {
                            gPSRecord = this.getFull(byArray, n5);
                            gPSRecord.recCount = ++n;
                            gPSFileConverterInterface.addLogRecord(gPSRecord);
                            n5 += 26;
                            continue block11;
                        }
                        case 21057: 
                        case 21072: 
                        case 21078: {
                            n5 += 8;
                            continue block11;
                        }
                    }
                    Generic.debug("Unknown entry " + JavaLibBridge.unsigned2hex(n6, 4) + "(" + JavaLibBridge.unsigned2hex(n2 + n5, 8) + ")", null);
                    n5 += 2;
                }
                n2 += n5;
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return 0;
    }

    private GPSRecord getFull(byte[] byArray, int n) {
        GPSRecord gPSRecord = GPSRecord.getLogFormatRecord(0);
        n += 2;
        ++n;
        int n2 = ++n;
        int n3 = ++n;
        int n4 = ++n;
        int n5 = ++n;
        int n6 = ++n;
        int n7 = ++n;
        int n8 = ++n;
        int n9 = ++n;
        long l = (0xFFL & (long)byArray[n2]) << 56 | (0xFFL & (long)byArray[n3]) << 48 | (0xFFL & (long)byArray[n4]) << 40 | (0xFFL & (long)byArray[n5]) << 32 | (0xFFL & (long)byArray[n6]) << 24 | (0xFFL & (long)byArray[n7]) << 16 | (0xFFL & (long)byArray[n8]) << 8 | 0xFFL & (long)byArray[n9];
        gPSRecord.longitude = JavaLibBridge.longBitsToDouble(l);
        int n10 = ++n;
        int n11 = ++n;
        int n12 = ++n;
        int n13 = ++n;
        int n14 = ++n;
        int n15 = ++n;
        int n16 = ++n;
        int n17 = ++n;
        long l2 = (0xFFL & (long)byArray[n10]) << 56 | (0xFFL & (long)byArray[n11]) << 48 | (0xFFL & (long)byArray[n12]) << 40 | (0xFFL & (long)byArray[n13]) << 32 | (0xFFL & (long)byArray[n14]) << 24 | (0xFFL & (long)byArray[n15]) << 16 | (0xFFL & (long)byArray[n16]) << 8 | 0xFFL & (long)byArray[n17];
        gPSRecord.latitude = JavaLibBridge.longBitsToDouble(l2);
        int n18 = ++n;
        int n19 = ++n;
        gPSRecord.height = ((0xFF & byArray[n18]) << 24 >> 16 | (0xFF & byArray[n19]) << 0) * 10;
        int n20 = ++n;
        int n21 = ++n;
        int n22 = ++n;
        int n23 = ++n;
        ++n;
        gPSRecord.utc = (0xFF & byArray[n20]) << 24 | (0xFF & byArray[n21]) << 16 | (0xFF & byArray[n22]) << 8 | (0xFF & byArray[n23]) << 0;
        gPSRecord.milisecond = 10 * (gPSRecord.utc % 100);
        gPSRecord.utc /= 100;
        return gPSRecord;
    }

    protected Object getFileObject(BT747Path bT747Path) {
        WindowedFile windowedFile = null;
        if (File.isAvailable()) {
            try {
                windowedFile = new WindowedFile(bT747Path, 1);
                windowedFile.setBufferSize(4096);
                this.errorInfo = bT747Path.toString() + "|" + windowedFile.getLastError();
            }
            catch (Exception exception) {
                Generic.debug("Error during initial open", exception);
            }
            if (windowedFile == null || !windowedFile.isOpen()) {
                this.errorInfo = bT747Path.toString();
                if (windowedFile != null) {
                    this.errorInfo = this.errorInfo + "|" + windowedFile.getLastError();
                }
                this.error = -1;
                windowedFile = null;
            }
        }
        return windowedFile;
    }

    protected void closeFileObject(Object object) {
        ((WindowedFile)object).close();
    }

    public int toGPSFile(BT747Path bT747Path, GPSFileConverterInterface gPSFileConverterInterface) {
        this.error = 0;
        try {
            Object object = this.getFileObject(bT747Path);
            if (object != null) {
                this.passToFindFieldsActivatedInLog = gPSFileConverterInterface.needPassToFindFieldsActivatedInLog();
                if (this.passToFindFieldsActivatedInLog) {
                    gPSFileConverterInterface.setActiveFileFields(GPSRecord.getLogFormatRecord(29));
                }
                this.passToFindFieldsActivatedInLog = false;
                if (this.error == 0) {
                    do {
                        this.error = this.parseFile(object, gPSFileConverterInterface);
                    } while (gPSFileConverterInterface.nextPass());
                }
                gPSFileConverterInterface.finaliseFile();
                this.closeFileObject(object);
            }
        }
        catch (Exception exception) {
            Generic.debug("", exception);
        }
        return this.error;
    }

    public int getType() {
        return 20;
    }
}

