/*
 * Decompiled with CFR 0.152.
 */
package gps.log.in;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.interfaces.BT747Path;

public final class WindowedFile {
    private File file;
    private BT747Path path;
    private int mode;
    private int bufferSize = 1024;
    private byte[] buffer;
    private int bufferFill = 0;
    private int currentPosition;

    public WindowedFile(BT747Path bT747Path, int n) throws Exception {
        this.path = bT747Path;
        this.mode = n;
        this.open();
    }

    private void open() {
        this.file = new File(this.path, this.mode);
    }

    public void setBufferSize(int n) {
        this.bufferSize = n;
    }

    public String getPath() {
        return this.file.getPath();
    }

    public int getLastError() {
        return this.file.getLastError();
    }

    public boolean isOpen() {
        return this.file.isOpen();
    }

    public int getSize() throws Exception {
        return this.file.getSize();
    }

    private void sanitizeBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
            this.bufferFill = 0;
        }
    }

    private final boolean readBytes(int n) {
        this.currentPosition += this.bufferFill;
        int n2 = this.file.readBytes(this.buffer, 0, n);
        if (n2 <= 0) {
            this.bufferFill = 0;
            return false;
        }
        this.bufferFill = n2;
        return true;
    }

    public final byte[] fillBuffer(int n) {
        int n2;
        int n3;
        this.sanitizeBuffer();
        if (n < this.currentPosition) {
            this.file.close();
            this.file = null;
            this.open();
            this.bufferFill = 0;
            this.currentPosition = 0;
        }
        if (n > this.currentPosition + this.bufferFill) {
            n3 = n - this.currentPosition - this.bufferFill;
            do {
                if ((n2 = n3) > this.bufferSize) {
                    n2 = this.bufferSize;
                }
                if (this.readBytes(n2) && this.bufferFill != 0) continue;
                return this.buffer;
            } while ((n3 -= this.bufferFill) > 0);
        }
        if (n > this.currentPosition && n < this.currentPosition + this.bufferFill) {
            n3 = 0;
            for (int i = n2 = n - this.currentPosition; i < this.bufferFill; ++i) {
                this.buffer[n3] = this.buffer[i];
                ++n3;
            }
            this.bufferFill -= n2;
            this.currentPosition += n2;
        } else if (n >= this.currentPosition + this.bufferFill) {
            this.currentPosition += this.bufferFill;
            this.bufferFill = 0;
        }
        if (this.bufferSize != this.bufferFill) {
            try {
                if (this.currentPosition != n) {
                    Generic.debug(this.path + ": Problem in position " + this.currentPosition + " request:" + n);
                }
                if ((n3 = this.file.readBytes(this.buffer, this.bufferFill, this.bufferSize - this.bufferFill)) > 0) {
                    this.bufferFill += n3;
                }
            }
            catch (Exception exception) {
                Generic.debug("Read problem during fillBuffer", exception);
                return null;
            }
        }
        return this.buffer;
    }

    public final int getBufferFill() {
        return this.bufferFill;
    }

    public final boolean close() {
        this.buffer = null;
        boolean bl = this.file.close();
        this.file = null;
        return bl;
    }
}

