/*
 * Decompiled with CFR 0.152.
 */
package gps.log.out;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747FileName;
import bt747.sys.interfaces.BT747HashSet;
import bt747.sys.interfaces.BT747Path;
import bt747.sys.interfaces.BT747Time;
import gps.convert.ExternalUtils;
import gps.log.GPSFilter;
import gps.log.GPSRecord;
import gps.log.out.GPSConversionParameters;
import gps.log.out.GPSDefaultFileName;
import gps.log.out.GPSFileInterface;

public abstract class GPSFile
implements GPSFileInterface {
    protected GPSFilter[] ptFilters = null;
    protected boolean oneFilePerDay;
    private GPSRecord activeFields = GPSRecord.getLogFormatRecord(0);
    protected GPSRecord activeFileFields;
    protected GPSRecord selectedFileFields;
    private GPSRecord mySelectedFileFields;
    protected boolean firstRecord;
    protected BT747Path basename;
    protected String ext;
    protected int nbrOfPassesToGo;
    protected int numberOfPasses = 1;
    private File outFile = null;
    protected final BT747Time t = JavaLibBridge.getTimeInstance();
    protected int previousDate = 0;
    protected int previousTime = 0;
    protected int nextPreviousTime = 0;
    protected boolean createNewFiles = true;
    private double previousLat = 0.0;
    private double previousLon = 0.0;
    protected int trackSepTime = 3600;
    protected int filesCreated = 0;
    protected boolean oneFilePerTrack = false;
    protected boolean isMultipleFiles = false;
    protected boolean recordNbrInLogs = false;
    protected String badTrackColor = "0000FF";
    protected String goodTrackColor = "0000FF";
    protected boolean imperial = false;
    protected BT747FileName filenameBuilder = new GPSDefaultFileName();
    private boolean calcDistance = false;
    private int splitDistance = 0;
    protected double distanceWithPrevious;
    private int distCalcMode;
    private boolean createFields = false;
    private final BT747HashSet filenames = JavaLibBridge.getHashSetInstance();
    protected boolean isTrkComment = true;
    protected boolean isWayComment = true;
    protected boolean addLogConditionInfo = false;
    private static GPSRecord previousRecord = null;
    private static boolean previousResult = false;
    private GPSRecord[] userWayPointList;
    private GPSRecord prevRecord = null;
    private int waypointTimeCorrection = 0;
    private int currentWayPointListIdx = -1;
    private int maxDiff = 300;
    private boolean overridePreviousTag = false;
    protected boolean logOn = false;
    private boolean isTrackSplitOnLogOn = false;
    protected boolean needsToSplitTrack = false;
    private BT747Path currentFileName;
    protected boolean ignoreBadPoints = false;
    protected String errorInfo;
    protected boolean isIncludeTrkName = true;
    protected int timeOffsetSeconds = 0;
    protected GPSConversionParameters paramObject = new GPSConversionParameters();

    public void initialiseFile(BT747Path bT747Path, String string, int n) {
        this.nbrOfPassesToGo = this.numberOfPasses - 1;
        this.createNewFiles = true;
        this.ext = string;
        this.basename = bT747Path;
        switch (n) {
            case 1: {
                this.oneFilePerDay = true;
                this.isMultipleFiles = true;
                break;
            }
            case 2: {
                this.oneFilePerTrack = true;
                this.isMultipleFiles = true;
                break;
            }
            default: {
                this.oneFilePerDay = false;
                this.oneFilePerTrack = false;
            }
        }
        this.isTrackSplitOnLogOn = this.getParamObject().hasParam("log-on-trk") ? this.getParamObject().getBoolParam("log-on-trk") : false;
        this.splitDistance = this.getParamObject().hasParam("split-d") ? this.getParamObject().getIntParam("split-d") : 0;
        this.distCalcMode = this.getParamObject().hasParam("dist-calc") ? this.getParamObject().getIntParam("dist-calc") : 0;
        this.createFields = this.getParamObject().hasParam("create-fields") ? this.getParamObject().getBoolParam("create-fields") : false;
        if (this.splitDistance != 0 || this.distCalcMode == 2) {
            this.calcDistance = true;
        }
        if (this.getParamObject().hasParam("waycmt")) {
            this.isWayComment = this.getParamObject().getBoolParam("waycmt");
        }
        if (this.getParamObject().hasParam("trkcmt")) {
            this.isTrkComment = this.getParamObject().getBoolParam("trkcmt");
        }
        this.addLogConditionInfo = this.getParamObject().hasParam("add-cond") ? this.getParamObject().getBoolParam("add-cond") : false;
        this.initPass();
    }

    public final void setTrackSepTime(int n) {
        this.trackSepTime = n;
    }

    public final void setActiveFileFields(GPSRecord gPSRecord) {
        boolean bl = this.distCalcMode == 2 || this.distCalcMode == 1;
        this.activeFileFields = gPSRecord.cloneRecord();
        if (bl) {
            this.activeFileFields.setDistance(0.0);
        }
        if (this.createFields) {
            this.setMissingFields(this.activeFileFields);
        }
        this.updateFields();
    }

    private final void updateFields() {
        if (this.activeFileFields != null && this.mySelectedFileFields != null) {
            this.selectedFileFields = GPSRecord.getCommonFormat(this.activeFileFields, this.mySelectedFileFields);
        } else {
            this.selectedFileFields = this.mySelectedFileFields;
            if (this.selectedFileFields == null) {
                this.selectedFileFields = this.activeFileFields;
            }
        }
    }

    public final void setOutputFields(GPSRecord gPSRecord) {
        this.mySelectedFileFields = gPSRecord;
        this.updateFields();
    }

    public void writeLogFmtHeader(GPSRecord gPSRecord) {
        this.activeFields = new GPSRecord(gPSRecord);
        this.updateFields();
    }

    public final void setFilters(GPSFilter[] gPSFilterArray) {
        this.ptFilters = gPSFilterArray;
    }

    public final void setImperial(boolean bl) {
        this.imperial = bl;
    }

    protected boolean recordIsNeeded(GPSRecord gPSRecord) {
        boolean bl;
        if (this.ptFilters != null) {
            bl = false;
            for (int i = this.ptFilters.length - 1; i >= 0; --i) {
                if (!this.ptFilters[i].doFilter(gPSRecord)) continue;
                bl = true;
                break;
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public final boolean cachedRecordIsNeeded(GPSRecord gPSRecord) {
        if (gPSRecord == previousRecord) {
            return previousResult;
        }
        previousRecord = gPSRecord;
        previousResult = this.recordIsNeeded(gPSRecord);
        return previousResult;
    }

    public void setUserWayPointList(GPSRecord[] gPSRecordArray) {
        this.userWayPointList = gPSRecordArray;
        this.initWayPointUserListSetup();
    }

    private void initWayPointUserListSetup() {
        this.currentWayPointListIdx = this.userWayPointList != null && this.userWayPointList.length >= 1 ? 0 : -1;
    }

    public GPSRecord[] getUserWayPointList() {
        return this.userWayPointList;
    }

    public void setWayPointTimeCorrection(int n) {
        this.waypointTimeCorrection = n;
    }

    private final void setMissingFields(GPSRecord gPSRecord) {
        if (!gPSRecord.hasLatitude()) {
            gPSRecord.setLatitude(0.0);
        }
        if (!gPSRecord.hasLongitude()) {
            gPSRecord.setLongitude(0.0);
        }
        if (!gPSRecord.hasRcr()) {
            gPSRecord.setRcr(1);
        }
        if (!gPSRecord.hasPdop()) {
            gPSRecord.setPdop(0);
        }
        if (!gPSRecord.hasHdop()) {
            gPSRecord.setHdop(0);
        }
        if (!gPSRecord.hasVdop()) {
            gPSRecord.setVdop(0);
        }
        if (!gPSRecord.hasHeight()) {
            gPSRecord.setHeight(0.0f);
        }
        if (!gPSRecord.hasSpeed()) {
            gPSRecord.setSpeed(0.0f);
        }
        if (!gPSRecord.hasNsat()) {
            gPSRecord.setNsat(771);
        }
        if (!gPSRecord.hasValid()) {
            if (gPSRecord.getLatitude() != 0.0 || gPSRecord.getLongitude() != 0.0) {
                gPSRecord.setValid(2);
            } else {
                gPSRecord.setValid(1);
            }
        }
    }

    public void addLogRecord(GPSRecord gPSRecord) {
        if (this.createFields) {
            this.setMissingFields(gPSRecord);
        }
        if (gPSRecord.hasVoxStr() && gPSRecord.isLogOn()) {
            this.logOn = true;
            return;
        }
        if (gPSRecord.hasUtc()) {
            gPSRecord.utc += this.timeOffsetSeconds;
        }
        if (this.currentWayPointListIdx >= 0 && this.cachedRecordIsNeeded(gPSRecord) && gPSRecord.hasUtc()) {
            GPSRecord gPSRecord2 = this.activeFields;
            if (this.prevRecord != null) {
                boolean bl;
                do {
                    bl = false;
                    GPSRecord gPSRecord3 = this.userWayPointList[this.currentWayPointListIdx];
                    boolean bl2 = false;
                    int n = gPSRecord3.tagutc + this.waypointTimeCorrection;
                    int n2 = n - this.prevRecord.getUtc() + this.timeOffsetSeconds;
                    int n3 = n - gPSRecord.getUtc() + this.timeOffsetSeconds;
                    if (n2 >= 0 && n3 < 0) {
                        int n4;
                        int n5;
                        GPSRecord gPSRecord4;
                        if (n2 < -n3) {
                            gPSRecord4 = this.prevRecord;
                            n5 = this.prevRecord.getUtc() - this.timeOffsetSeconds;
                            n4 = n2;
                        } else {
                            gPSRecord4 = gPSRecord;
                            n4 = -n3;
                            n5 = gPSRecord.getUtc() - this.timeOffsetSeconds;
                        }
                        if (n4 <= this.maxDiff && (this.overridePreviousTag || !gPSRecord3.hasPosition())) {
                            gPSRecord3.tagFromRecord(gPSRecord4);
                            gPSRecord3.utc = n5;
                        }
                        bl2 = true;
                    } else if (n2 < -this.maxDiff) {
                        bl2 = true;
                    }
                    if (!bl2) continue;
                    if (gPSRecord3.hasLatitude() && gPSRecord3.hasLongitude()) {
                        if (!this.activeFields.equalsFormat(gPSRecord3)) {
                            this.writeLogFmtHeader(gPSRecord3);
                        }
                        gPSRecord3.utc -= this.timeOffsetSeconds;
                        if (gPSRecord3.hasUtc()) {
                            gPSRecord3.utc += this.timeOffsetSeconds;
                        }
                        this.writeRecord(gPSRecord3);
                    }
                    this.nextWayPointIdx();
                    boolean bl3 = bl = this.currentWayPointListIdx != -1;
                } while (bl);
            }
            if (gPSRecord2 != this.activeFields && !this.activeFields.equalsFormat(gPSRecord2)) {
                this.writeLogFmtHeader(gPSRecord2);
            }
        }
        this.writeRecord(gPSRecord);
        if (this.cachedRecordIsNeeded(gPSRecord)) {
            this.prevRecord = gPSRecord;
            this.logOn = false;
        }
    }

    private final void addUntreatedWayPoints() {
        while (this.currentWayPointListIdx >= 0) {
            GPSRecord gPSRecord = this.userWayPointList[this.currentWayPointListIdx];
            if (gPSRecord.hasLatitude() && gPSRecord.hasLongitude()) {
                if (!this.activeFields.equalsFormat(gPSRecord)) {
                    this.writeLogFmtHeader(gPSRecord);
                }
                this.writeRecord(gPSRecord);
            }
            this.nextWayPointIdx();
        }
    }

    private void nextWayPointIdx() {
        this.currentWayPointListIdx = this.currentWayPointListIdx < this.userWayPointList.length - 1 ? ++this.currentWayPointListIdx : -1;
    }

    public void writeRecord(GPSRecord gPSRecord) {
        boolean bl;
        boolean bl2 = false;
        int n = 0;
        this.previousTime = this.nextPreviousTime;
        this.needsToSplitTrack = this.logOn && this.isTrackSplitOnLogOn;
        boolean bl3 = this.firstRecord;
        if (gPSRecord.hasUtc()) {
            this.t.setUTCTime(gPSRecord.getUtc());
            if (this.oneFilePerDay || this.oneFilePerTrack) {
                n = (this.t.getYear() << 14) + (this.t.getMonth() << 7) + this.t.getDay();
                boolean bl4 = bl2 = n > this.previousDate;
            }
            if (this.trackSepTime != 0) {
                this.needsToSplitTrack |= gPSRecord.getUtc() > this.previousTime + this.trackSepTime;
            }
        }
        if ((this.oneFilePerDay && bl2 && this.activeFields.hasUtc() || this.firstRecord || this.oneFilePerTrack && this.needsToSplitTrack) && this.cachedRecordIsNeeded(gPSRecord)) {
            boolean bl5;
            int n2;
            String string;
            bl = true;
            this.needsToSplitTrack = false;
            this.previousDate = n;
            if (gPSRecord.hasUtc()) {
                if (gPSRecord.getUtc() < 86400 || this.t.getYear() > 2000) {
                    string = "-" + this.t.getYear() + (this.t.getMonth() < 10 ? "0" : "") + this.t.getMonth() + (this.t.getDay() < 10 ? "0" : "") + this.t.getDay();
                    if (this.oneFilePerTrack) {
                        string = string + "_" + (this.t.getHour() < 10 ? "0" : "") + this.t.getHour() + (this.t.getMinute() < 10 ? "0" : "") + this.t.getMinute();
                    }
                } else {
                    string = "";
                    bl = false;
                }
            } else {
                string = "";
            }
            if (!this.firstRecord && string.length() != 0) {
                if (this.nbrOfPassesToGo == 0) {
                    this.finaliseFile();
                } else {
                    this.closeFile();
                }
            } else {
                boolean bl6 = this.firstRecord = !bl;
            }
            if (bl && (n2 = this.createFile(gPSRecord.utc, string, bl5 = this.createNewFiles || this.numberOfPasses - 1 == this.nbrOfPassesToGo)) == 0) {
                ++this.filesCreated;
                try {
                    if (bl5) {
                        this.writeFileHeader("GPS" + string);
                    }
                    this.writeLogFmtHeader(this.activeFields);
                    this.writeDataHeader();
                }
                catch (Exception exception) {
                    Generic.debug("Initial header or append", exception);
                }
            }
        }
        boolean bl7 = bl = this.distCalcMode != 0 && (this.distCalcMode == 2 || !gPSRecord.hasDistance() && this.distCalcMode == 1);
        if ((this.calcDistance || bl) && this.cachedRecordIsNeeded(gPSRecord) && gPSRecord.hasPosition() && !bl3) {
            this.distanceWithPrevious = ExternalUtils.earthDistance(gPSRecord.getLatitude(), gPSRecord.getLongitude(), this.previousLat, this.previousLon);
            if (this.splitDistance != 0) {
                this.needsToSplitTrack |= (double)this.splitDistance <= this.distanceWithPrevious;
            }
            if (bl) {
                gPSRecord.setDistance(this.distanceWithPrevious);
            }
        }
        if (this.cachedRecordIsNeeded(gPSRecord)) {
            if (gPSRecord.hasPosition()) {
                this.previousLat = gPSRecord.getLatitude();
                this.previousLon = gPSRecord.getLongitude();
            }
            if (gPSRecord.hasUtc()) {
                this.nextPreviousTime = gPSRecord.utc;
            }
        }
    }

    public void finaliseFile() {
        if (this.outFile != null) {
            try {
                this.outFile.close();
            }
            catch (Exception exception) {
                Generic.debug("finaliseFile", exception);
            }
            this.outFile = null;
        }
    }

    public boolean nextPass() {
        this.createNewFiles = false;
        this.addUntreatedWayPoints();
        if (this.nbrOfPassesToGo == 0) {
            this.finaliseFile();
        } else if (this.isOpen()) {
            this.closeFile();
        }
        this.initPass();
        return false;
    }

    private final void initPass() {
        this.previousDate = 0;
        this.previousTime = 0;
        this.nextPreviousTime = 0;
        this.previousLat = 0.0;
        this.previousLon = 0.0;
        this.firstRecord = true;
        this.initWayPointUserListSetup();
        this.prevRecord = null;
    }

    protected void writeFileHeader(String string) {
    }

    protected void writeDataHeader() {
    }

    protected void writeDataFooter() {
    }

    protected int createFile(int n, String string, boolean bl) {
        this.currentFileName = null;
        BT747Path bT747Path = this.filenameBuilder.getOutputFileName(this.basename, n, this.ext, string);
        int n2 = 0;
        try {
            File file;
            if (bl && (file = new File(bT747Path, 0)).exists()) {
                file.delete();
            }
        }
        catch (Exception exception) {
            Generic.debug("File deletion", exception);
        }
        try {
            int n3 = bl ? 4 : 2;
            this.outFile = new File(bT747Path, n3);
        }
        catch (Exception exception) {
            Generic.debug("File creation", exception);
        }
        if (this.outFile != null && !this.outFile.isOpen()) {
            this.errorInfo = bT747Path + "|" + this.outFile.getLastError();
            n2 = -1;
            this.outFile = null;
        } else {
            this.currentFileName = bT747Path;
            this.filenames.add(this.currentFileName);
        }
        return n2;
    }

    protected void closeFile() {
        this.writeDataFooter();
        try {
            if (this.outFile != null) {
                this.outFile.close();
            }
        }
        catch (Exception exception) {
            Generic.debug("closeFile", exception);
        }
    }

    protected boolean isOpen() {
        return this.outFile != null;
    }

    protected void writeTxt(String string) {
        try {
            if (this.outFile != null) {
                byte[] byArray = JavaLibBridge.getUTF8Bytes(string);
                this.outFile.writeBytes(byArray, 0, byArray.length);
            } else {
                Generic.debug("Writing to closed file", null);
            }
        }
        catch (Exception exception) {
            Generic.debug("writeTxt", exception);
        }
    }

    public boolean needPassToFindFieldsActivatedInLog() {
        return false;
    }

    public final void setBadTrackColor(String string) {
        this.badTrackColor = string;
        this.checkColors();
    }

    public final void setGoodTrackColor(String string) {
        this.goodTrackColor = string;
        this.checkColors();
    }

    private void checkColors() {
        this.ignoreBadPoints = this.goodTrackColor.equalsIgnoreCase(this.badTrackColor);
    }

    public final int getNbrFilesCreated() {
        int n = this.filenames.count();
        if (n == 0) {
            n = this.filesCreated;
        }
        return n;
    }

    public final void setRecordNbrInLogs(boolean bl) {
        this.recordNbrInLogs = bl;
    }

    public final void setIncludeTrkName(boolean bl) {
        this.isIncludeTrkName = bl;
    }

    public final void setFilenameBuilder(BT747FileName bT747FileName) {
        this.filenameBuilder = bT747FileName;
    }

    public final void setTimeOffset(int n) {
        this.timeOffsetSeconds = n;
    }

    public final void setMaxDiff(int n) {
        this.maxDiff = n;
    }

    public final void setOverridePreviousTag(boolean bl) {
        this.overridePreviousTag = bl;
    }

    public final GPSConversionParameters getParamObject() {
        return this.paramObject;
    }
}

