/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import gps.mvc.CmdParam;
import gps.mvc.GpsController;
import gps.mvc.HoluxModel;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;

public class HoluxController
extends MtkController {
    private boolean useMtkProtocol;

    public HoluxController(GpsController gpsController, MtkModel mtkModel, boolean bl) {
        super(gpsController, mtkModel);
        this.useMtkProtocol = bl;
    }

    public boolean cmd(int n) {
        switch (n) {
            case 13: {
                this.sendCmd("PHLX839", false);
                break;
            }
            default: {
                if (this.useMtkProtocol) {
                    return super.cmd(n);
                }
                return false;
            }
        }
        return true;
    }

    public boolean cmd(int n, CmdParam cmdParam) {
        switch (n) {
            case 11: {
                this.setHoluxName(cmdParam.getString());
                break;
            }
            case 9: {
                this.setLogDistanceInterval(cmdParam.getInt());
                break;
            }
            case 8: {
                this.setLogTimeInterval(cmdParam.getInt());
                break;
            }
            case 15: {
                if (this.useMtkProtocol) {
                    return super.cmd(n, cmdParam);
                }
                this.setLogOverwrite(cmdParam.getBoolean());
                break;
            }
            default: {
                if (this.useMtkProtocol) {
                    return super.cmd(n, cmdParam);
                }
                return false;
            }
        }
        return true;
    }

    private void setHoluxName(String string) {
        this.sendCmd("PHLX828", false);
        this.sendCmd("PHLX830," + string, false);
        this.reqData(10);
    }

    public boolean reqData(int n) {
        switch (n) {
            case 10: {
                this.sendCmd("PHLX828", false);
                this.sendCmd("PHLX831", false);
                break;
            }
            case 11: 
            case 13: {
                this.sendCmd("PHLX833", false);
                this.sendCmd("PHLX841,0", false);
                break;
            }
            case 8: {
                if (this.useMtkProtocol) {
                    return super.reqData(n);
                }
                this.sendCmd("PHLX829", false);
                this.sendCmd("PHLX810", false);
                break;
            }
            case 18: {
                if (this.useMtkProtocol) {
                    return super.reqData(n);
                }
                this.sendCmd("PHLX842,0", false);
                break;
            }
            case 2: {
                if (this.useMtkProtocol) {
                    return super.reqData(n);
                }
                this.sendCmd("PHLX709", false);
                this.sendCmd("PHLX701", false);
                HoluxModel holuxModel = (HoluxModel)this.getMtkModel();
                if (holuxModel.logNbrTracks == 0) break;
                this.sendCmd("PHLX702,0," + holuxModel.logNbrTracks, false);
                break;
            }
            default: {
                if (this.useMtkProtocol) {
                    return super.reqData(n);
                }
                return false;
            }
        }
        return true;
    }

    private void setLogTimeInterval(int n) {
        int n2 = (n + 5) / 10;
        if (n2 > 120) {
            n2 = 120;
        } else if (n2 < 1) {
            n2 = 1;
        }
        this.sendCmd("PHLX834,0," + n2 + "," + "1", false);
    }

    private void setLogDistanceInterval(int n) {
        int n2 = (n + 5) / 10;
        if (n2 > 1000) {
            n2 = 1000;
        } else if (n2 < 1) {
            n2 = 1;
        }
        this.sendCmd("PHLX834,1,1," + n2, false);
    }

    private void setLogOverwrite(boolean bl) {
        this.sendCmd("PHLX842,1," + ((HoluxModel)this.getMtkModel()).device + "," + (bl ? "0" : "1"), false);
    }
}

