/*
 * Decompiled with CFR 0.152.
 */
package gps.mvc;

import bt747.sys.File;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.RAFile;
import bt747.sys.interfaces.BT747Exception;
import bt747.sys.interfaces.BT747Path;
import gps.convert.Conv;
import gps.log.in.WindowedFile;
import gps.mvc.MtkController;
import gps.mvc.MtkModel;
import gps.mvc.commands.GpsLinkNmeaCommand;

final class MTKLogDownloadHandler {
    private final MTKLogDownloadContext context = new MTKLogDownloadContext();

    protected MTKLogDownloadHandler(MtkController mtkController, MtkModel mtkModel) {
        this.context.mtkC = mtkController;
        this.context.mtkM = mtkController.getMtkModel();
    }

    protected final void getLogInit(int n, int n2, int n3, BT747Path bT747Path, boolean bl, boolean bl2) {
        this.context.startAddr = n;
        this.context.endAddr = n2;
        this.context.logRequestStep = n3;
        this.context.logPath = bT747Path;
        this.context.isSmart = bl;
        this.context.disableLogging = bl2;
        MTKLogDownloadHandler.logInit(this.context);
    }

    private static final void logInit(MTKLogDownloadContext mTKLogDownloadContext) {
        if (mTKLogDownloadContext.getLogState() == 0) {
            mTKLogDownloadContext.loggingIsActiveBeforeDownload = mTKLogDownloadContext.mtkM.isLoggingActive();
            if (mTKLogDownloadContext.disableLogging && mTKLogDownloadContext.loggingIsActiveBeforeDownload) {
                mTKLogDownloadContext.mtkC.cmd(5);
                mTKLogDownloadContext.mtkC.reqData(7);
            }
        }
        mTKLogDownloadContext.mtkM.postEvent(5);
        if (Generic.isDebug()) {
            Generic.debug((mTKLogDownloadContext.isSmart ? "Smart d" : "D") + "ownload request from " + JavaLibBridge.unsigned2hex(mTKLogDownloadContext.startAddr, 8) + " to " + JavaLibBridge.unsigned2hex(mTKLogDownloadContext.endAddr, 8));
        }
        mTKLogDownloadContext.logDownloadStartAddr = mTKLogDownloadContext.startAddr;
        mTKLogDownloadContext.setLogDownloadEndAddr((mTKLogDownloadContext.endAddr + 65535 & 0xFFFF0000) - 1);
        mTKLogDownloadContext.logNextReqAddr = mTKLogDownloadContext.logDownloadStartAddr;
        mTKLogDownloadContext.setLogNextReadAddr(mTKLogDownloadContext.logDownloadStartAddr);
        mTKLogDownloadContext.usedLogRequestAhead = mTKLogDownloadContext.logRequestStep > 2048 ? 0 : mTKLogDownloadContext.logRequestAhead;
        mTKLogDownloadContext.mtkM.getHandler().setLogOrEraseOngoing(true);
        mTKLogDownloadContext.setLogState(5);
    }

    private final void realDownloadStart() throws BT747Exception {
        try {
            if (this.context.isSmart && new File(this.context.logPath).exists()) {
                this.closeLog();
                WindowedFile windowedFile = new WindowedFile(this.context.logPath, 1);
                windowedFile.setBufferSize(512);
                if (windowedFile != null && windowedFile.isOpen() && windowedFile.getSize() >= 1024) {
                    byte[] byArray;
                    boolean bl;
                    int n = 0;
                    do {
                        byArray = windowedFile.fillBuffer(n);
                        boolean bl2 = bl = windowedFile.getBufferFill() >= 2;
                        if (bl) {
                            boolean bl3 = bl = byArray[0] != -1 || byArray[1] != -1;
                        }
                        if (!bl) continue;
                        boolean bl4 = bl = (n += 65536) <= (windowedFile.getSize() & 0xFFFF0000);
                    } while (bl);
                    if (n > windowedFile.getSize()) {
                        this.context.setLogNextReadAddr(windowedFile.getSize());
                        this.context.logNextReqAddr = this.context.getLogNextReadAddr();
                    } else {
                        this.context.setLogNextReadAddr(n + 512);
                        bl = true;
                        do {
                            byArray = windowedFile.fillBuffer(this.context.getLogNextReadAddr());
                            boolean bl5 = bl = windowedFile.getBufferFill() >= 512;
                            if (!bl) continue;
                            for (int i = 0; bl && i < 512; ++i) {
                                bl = byArray[i] == -1;
                            }
                            boolean bl6 = bl = !bl;
                            if (!bl) continue;
                            this.context.setLogNextReadAddr(this.context.getLogNextReadAddr() + 512);
                        } while (bl);
                        this.context.setLogNextReadAddr(this.context.getLogNextReadAddr() - 512);
                        this.context.logNextReqAddr = this.context.getLogNextReadAddr();
                    }
                    int n2 = (this.context.getLogNextReadAddr() + 65535 & 0xFFFF0000) - 1;
                    if (n2 > this.context.getLogDownloadEndAddr()) {
                        if (Generic.isDebug()) {
                            Generic.debug("Adjusted end address from " + JavaLibBridge.unsigned2hex(this.context.getLogDownloadEndAddr(), 8) + " to " + JavaLibBridge.unsigned2hex(n2, 8));
                        }
                        this.context.setLogDownloadEndAddr(n2);
                    }
                    this.context.expectedResult = new byte[512];
                    byte[] byArray2 = windowedFile.fillBuffer(512);
                    for (int i = this.context.expectedResult.length - 1; i >= 0; --i) {
                        this.context.expectedResult[i] = byArray2[i];
                    }
                    this.context.setLogState(1);
                    this.context.mtkM.getHandler().resetLogTimeOut();
                    this.requestCheckBlock();
                }
                this.context.mtkM.getHandler().updateIgnoreNMEA();
                windowedFile.close();
            }
            if (this.context.getLogState() != 1) {
                this.openNewLog(this.context.logPath);
                if (Generic.isDebug()) {
                    Generic.debug("Starting download from " + JavaLibBridge.unsigned2hex(this.context.getLogNextReadAddr(), 8) + " to " + JavaLibBridge.unsigned2hex(this.context.getLogDownloadEndAddr(), 8));
                }
                this.context.setLogState(2);
            }
            if (this.context.getLogState() == 0) {
                this.context.mtkM.postEvent(7);
            }
        }
        catch (BT747Exception bT747Exception) {
            this.context.setLogState(0);
            this.context.mtkM.postEvent(7);
            throw bT747Exception;
        }
        catch (Exception exception) {
            this.context.setLogState(0);
            this.context.mtkM.postEvent(7);
            Generic.debug("getLogInit", exception);
        }
    }

    protected final void openNewLog(BT747Path bT747Path) throws BT747Exception {
        try {
            if (this.context.logFile != null && this.context.logFile.isOpen()) {
                this.context.logFile.close();
            }
            this.context.logFile = new RAFile(bT747Path, 0);
            this.context.logPath = bT747Path;
            if (this.context.logFile.exists()) {
                this.context.logFile.delete();
            }
            this.context.logFile = new RAFile(bT747Path, 4);
            this.context.logPath = bT747Path;
            this.context.logFile.close();
            this.context.logFile = new RAFile(bT747Path, 2);
            this.context.logPath = bT747Path;
            if (this.context.logFile == null || !this.context.logFile.isOpen()) {
                throw new BT747Exception("open", new Throwable(bT747Path.toString()));
            }
        }
        catch (BT747Exception bT747Exception) {
            throw bT747Exception;
        }
        catch (Exception exception) {
            Generic.debug("openNewLog", exception);
            throw new BT747Exception("open", new Throwable(bT747Path.toString()));
        }
    }

    private void reOpenLogWrite(BT747Path bT747Path) {
        this.closeLog();
        try {
            this.context.logFile = new RAFile(bT747Path, 2);
            this.context.logPath = bT747Path;
        }
        catch (Exception exception) {
            Generic.debug("reOpenLogWrite", exception);
        }
    }

    private void getNextLogPart() {
        if (this.context.getLogState() != 0) {
            int n = this.context.getLogDownloadEndAddr() - this.context.logNextReqAddr + 1;
            switch (this.context.getLogState()) {
                case 2: {
                    if (this.context.getLogDownloadEndAddr() <= this.context.getLogNextReadAddr()) {
                        this.endGetLog();
                    }
                    if (this.context.logNextReqAddr <= this.context.getLogNextReadAddr() + this.context.logRequestStep * this.context.usedLogRequestAhead) break;
                    n = 0;
                    break;
                }
                case 3: {
                    if (this.context.getLogDownloadEndAddr() <= this.context.getLogNextReadAddr()) {
                        this.endGetLog();
                    }
                    if (this.context.logNextReqAddr > this.context.getLogNextReadAddr()) {
                        n = 0;
                        break;
                    }
                    if (n <= 2048) break;
                    n = 2048;
                    break;
                }
                default: {
                    n = 0;
                }
            }
            if (n > 0) {
                int n2;
                if (n > this.context.logRequestStep) {
                    n = this.context.logRequestStep;
                }
                if (n > (n2 = (this.context.logNextReqAddr + 65536 & 0xFFFF0000) - this.context.logNextReqAddr)) {
                    n = n2;
                }
                this.readLog(this.context.logNextReqAddr, n);
                this.context.logNextReqAddr += n;
                if (this.context.getLogState() == 2) {
                    this.getNextLogPart();
                }
            }
        }
    }

    private void getLogPartNoOutstandingRequests() throws BT747Exception {
        switch (this.context.getLogState()) {
            case 2: 
            case 3: {
                this.context.logNextReqAddr = this.context.getLogNextReadAddr();
                this.getNextLogPart();
                break;
            }
            case 1: {
                this.requestCheckBlock();
                break;
            }
            case 5: {
                this.realDownloadStart();
                break;
            }
        }
    }

    private void recoverFromLogError() {
        this.context.setLogState(3);
    }

    protected final void analyzeLogPart(int n, String string) {
        int n2 = Conv.hexStringToBytes(string, this.context.readDataBuffer) / 2;
        switch (this.context.getLogState()) {
            case 2: 
            case 3: {
                if (this.context.getLogNextReadAddr() == n) {
                    this.context.setLogState(2);
                    int n3 = 0;
                    if (n2 != 2048 && n2 != this.context.logRequestStep && this.context.getLogNextReadAddr() + n2 != this.context.logNextReqAddr && n2 != (this.context.getLogNextReadAddr() + 65536 & 0xFFFF0000) - this.context.getLogNextReadAddr()) {
                        if (Generic.isDebug()) {
                            Generic.debug("Unexpected datalength: " + JavaLibBridge.unsigned2hex(n2, 8));
                        }
                        this.context.setLogState(3);
                    } else {
                        int n4;
                        int n5;
                        for (n5 = n2; n5 > 0; n5 -= 2048) {
                            n4 = n5;
                            if (n4 > 2048) {
                                n4 = 2048;
                            }
                            try {
                                if (this.context.logFile.writeBytes(this.context.readDataBuffer, n3, n4) != n4) {
                                    this.cancelGetLog();
                                }
                            }
                            catch (Exception exception) {
                                Generic.debug("analyzeLogPart", exception);
                                this.cancelGetLog();
                            }
                            n3 += n4;
                        }
                        this.context.setLogNextReadAddr(this.context.getLogNextReadAddr() + n2);
                        if (this.context.getFullLogBlocks && (n - 1 + n2 & 0xFFFF0000) >= n && ((this.context.readDataBuffer[n5 = 0xFFFF & 65536 - (n & 0xFFFF)] & 0xFF) != 255 || (this.context.readDataBuffer[n5 + 1] & 0xFF) != 255)) {
                            n4 = (n & 0xFFFF0000) + 131072 - 1;
                            if (n4 > this.context.mtkM.getLogMemSize() - 1) {
                                n4 = this.context.mtkM.getLogMemSize() - 1;
                            }
                            if (n4 > this.context.getLogDownloadEndAddr()) {
                                this.context.setLogDownloadEndAddr(n4);
                            }
                        }
                    }
                    if (this.context.getLogNextReadAddr() > this.context.getLogDownloadEndAddr()) {
                        this.context.mtkM.postEvent(14);
                        this.endGetLog();
                        break;
                    }
                    this.getNextLogPart();
                    break;
                }
                Generic.debug("Expected:" + JavaLibBridge.unsigned2hex(this.context.getLogNextReadAddr(), 8) + " Got:" + JavaLibBridge.unsigned2hex(n, 8) + " (" + JavaLibBridge.unsigned2hex(n2, 8) + ")", null);
                this.recoverFromLogError();
                break;
            }
            case 1: {
                this.context.setLogState(0);
                if (n == 512 && n2 == 512) {
                    boolean bl = true;
                    for (int i = n2 - 1; i >= 0; --i) {
                        if (this.context.readDataBuffer[i] == this.context.expectedResult[i]) continue;
                        bl = false;
                        break;
                    }
                    if (bl) {
                        this.reOpenLogWrite(this.context.logPath);
                        try {
                            this.context.logFile.setPos(this.context.getLogNextReadAddr());
                        }
                        catch (Exception exception) {
                            Generic.debug("C_LOG_CHECK", exception);
                        }
                        if (Generic.isDebug()) {
                            Generic.debug("Starting incremental download from " + JavaLibBridge.unsigned2hex(this.context.getLogNextReadAddr(), 8) + " to " + JavaLibBridge.unsigned2hex(this.context.getLogDownloadEndAddr(), 8));
                        }
                        this.context.setLogState(2);
                        this.getNextLogPart();
                        break;
                    }
                    this.context.setLogState(6);
                    if (Generic.isDebug()) {
                        Generic.debug("Different data - requesting overwrite confirmation");
                    }
                    this.context.mtkM.postEvent(8);
                    break;
                }
                if (Generic.isDebug()) {
                    Generic.debug("Expected:" + JavaLibBridge.unsigned2hex(512, 8) + " Got:" + JavaLibBridge.unsigned2hex(n, 8) + " (" + JavaLibBridge.unsigned2hex(n2, 8) + ")", null);
                }
                this.context.setLogState(1);
                break;
            }
        }
        if (this.context.getLogState() == 0) {
            this.context.mtkM.getHandler().setLogOrEraseOngoing(false);
        }
        this.context.mtkM.postEvent(6);
    }

    protected final void replyToOkToOverwrite(boolean bl) throws BT747Exception {
        if (this.context.getLogState() == 6) {
            if (bl) {
                this.openNewLog(this.context.logPath);
                this.context.setLogNextReadAddr(0);
                this.context.setLogState(2);
            } else {
                this.endGetLog();
            }
        }
    }

    private void requestCheckBlock() {
        this.readLog(512, 512);
    }

    private void closeLog() {
        try {
            if (this.context.logFile != null && this.context.logFile.isOpen()) {
                this.context.logFile.close();
                this.context.logFile = null;
            }
        }
        catch (Exception exception) {
            Generic.debug("CloseLog", exception);
        }
    }

    private void endGetLog() {
        this.context.setLogState(0);
        this.closeLog();
        if (this.context.loggingIsActiveBeforeDownload) {
            this.context.mtkC.cmd(4);
            this.context.mtkC.reqData(7);
        }
        this.context.mtkM.postEvent(7);
    }

    protected final int getStartAddr() {
        return this.context.logDownloadStartAddr;
    }

    protected final void cancelGetLog() {
        this.endGetLog();
    }

    protected final void eraseLog() {
        if (this.context.mtkM.getHandler().isConnected()) {
            this.context.mtkM.getHandler().setEraseOngoing(true);
            this.context.mtkC.doSendCmd(new GpsLinkNmeaCommand("PMTK182,6,1"));
            this.waitEraseDone();
        }
    }

    protected final void recoveryEraseLog() {
        this.context.mtkC.cmd(5);
        this.context.mtkC.reqData(7);
        this.context.mtkC.reqData(15);
        this.context.mtkC.sendCmd(new GpsLinkNmeaCommand("PMTK182,10", false));
        this.context.mtkC.reqData(7);
        this.context.forcedErase = true;
        this.eraseLog();
    }

    private void postRecoveryEraseLog() {
        this.context.mtkC.reqData(7);
        this.context.mtkC.reqData(15);
        this.context.mtkC.sendCmd("PMTK182,9");
        this.context.mtkC.reqData(15);
        this.context.mtkC.reqData(7);
    }

    private void waitEraseDone() {
        this.context.setLogState(4);
        this.context.mtkM.getHandler().setLogOrEraseOngoing(true);
        this.context.mtkM.getHandler().resetLogTimeOut();
    }

    protected void signalEraseDone() {
        this.context.setLogState(0);
        this.context.mtkM.getHandler().setLogOrEraseOngoing(true);
        this.context.mtkM.setEraseOngoing(false);
    }

    protected final void stopErase() {
        if (this.context.mtkM.isEraseOngoing() && this.context.getLogState() == 4) {
            this.context.mtkM.getHandler().updateIgnoreNMEA();
            this.signalEraseDone();
        } else {
            this.context.mtkM.setEraseOngoing(false);
        }
    }

    protected void notifyRun() throws BT747Exception {
        if (this.context.mtkM.getHandler().getOutStandingCmdsCount() == 0 && this.context.getLogState() != 0 && this.context.getLogState() != 4) {
            this.getLogPartNoOutstandingRequests();
        } else if (this.context.getLogState() == 2) {
            this.getNextLogPart();
        } else if (this.context.getLogState() == 4 && this.context.mtkM.getHandler().timeSinceLastStamp() > 2000) {
            this.context.mtkC.reqData(14);
        }
    }

    protected final void notifyDisconnected() {
        if (this.context.getLogState() != 0) {
            this.endGetLog();
        }
    }

    protected final void handleLogFlashStatReply(String string) {
        if (this.context.getLogState() == 4) {
            switch (JavaLibBridge.toInt(string)) {
                case 1: {
                    if (this.context.mtkM.isEraseOngoing()) {
                        this.signalEraseDone();
                    }
                    if (!this.context.forcedErase) break;
                    this.context.forcedErase = false;
                    this.postRecoveryEraseLog();
                    break;
                }
            }
        }
    }

    protected final void readLog(int n, int n2) {
        this.context.mtkC.sendCmd("PMTK182,7," + JavaLibBridge.unsigned2hex(n, 8) + "," + JavaLibBridge.unsigned2hex(n2, 8));
    }

    protected final void setLogRequestAhead(int n) {
        this.context.logRequestAhead = n;
    }

    private static final class MTKLogDownloadContext {
        protected MtkModel mtkM;
        protected MtkController mtkC;
        private int logState = 0;
        private int logDownloadEndAddr;
        private int logNextReadAddr;
        protected RAFile logFile = null;
        protected BT747Path logPath = null;
        protected int startAddr;
        protected int endAddr;
        protected int logNextReqAddr;
        protected int logRequestStep;
        protected boolean isSmart = true;
        protected boolean disableLogging;
        protected boolean loggingIsActiveBeforeDownload = false;
        protected int logDownloadStartAddr;
        protected int logRequestAhead = 0;
        protected byte[] expectedResult;
        protected boolean forcedErase = false;
        protected boolean getFullLogBlocks = true;
        protected int usedLogRequestAhead = 0;
        protected final byte[] readDataBuffer = new byte[2048];

        private MTKLogDownloadContext() {
        }

        protected void setLogState(int n) {
            this.logState = n;
            switch (n) {
                case 0: 
                case 4: {
                    this.mtkM.setLogDownloadOngoing(false);
                    break;
                }
                default: {
                    this.mtkM.setLogDownloadOngoing(true);
                }
            }
        }

        protected int getLogState() {
            return this.logState;
        }

        protected void setLogDownloadEndAddr(int n) {
            this.logDownloadEndAddr = n;
            this.mtkM.setEndAddr(n);
        }

        protected int getLogDownloadEndAddr() {
            return this.logDownloadEndAddr;
        }

        protected void setLogNextReadAddr(int n) {
            this.logNextReadAddr = n;
            this.mtkM.setNextReadAddr(n);
        }

        protected int getLogNextReadAddr() {
            return this.logNextReadAddr;
        }
    }
}

