/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractCollection;
import moio.util.AbstractList;
import moio.util.Cloneable;
import moio.util.IllegalArgumentException;
import moio.util.List;
import moio.util.RandomAccess;
import moio.util.Serializable;
import moio.util.System;

public class ArrayList
extends AbstractList
implements Cloneable,
List,
RandomAccess,
Serializable {
    private int size;
    private transient Object[] data;

    public ArrayList(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new Object[n];
    }

    public ArrayList() {
        this(16);
    }

    public void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n > n2) {
            Object[] objectArray = new Object[Math.max(n2 * 2, n)];
            System.arraycopy(this.data, 0, objectArray, 0, this.size);
            this.data = objectArray;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    public int indexOf(Object object) {
        for (int i = 0; i < this.size; ++i) {
            if (!AbstractCollection.equals(object, this.data[i])) continue;
            return i;
        }
        return -1;
    }

    public Object get(int n) {
        this.checkBoundExclusive(n);
        return this.data[n];
    }

    public boolean add(Object object) {
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.data[this.size++] = object;
        return true;
    }

    public void add(int n, Object object) {
        this.checkBoundInclusive(n);
        ++this.modCount;
        if (this.size == this.data.length) {
            this.ensureCapacity(this.size + 1);
        }
        if (n != this.size) {
            System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        }
        this.data[n] = object;
        ++this.size;
    }

    public Object remove(int n) {
        this.checkBoundExclusive(n);
        Object object = this.data[n];
        ++this.modCount;
        if (n != --this.size) {
            System.arraycopy(this.data, n + 1, this.data, n, this.size - n);
        }
        this.data[this.size] = null;
        return object;
    }

    private void checkBoundInclusive(int n) {
        if (n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }

    private void checkBoundExclusive(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
    }
}

