/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.Cloneable;
import moio.util.NegativeArraySizeException;
import moio.util.Serializable;

public class BitSet
implements Cloneable,
Serializable {
    private long[] bits;

    public BitSet() {
        this(64);
    }

    public BitSet(int n) {
        if (n < 0) {
            throw new NegativeArraySizeException();
        }
        int n2 = n >>> 6;
        if ((n & 0x3F) != 0) {
            ++n2;
        }
        this.bits = new long[n2];
    }

    public boolean equals(Object object) {
        int n;
        if (!(object instanceof BitSet)) {
            return false;
        }
        BitSet bitSet = (BitSet)object;
        int n2 = Math.min(this.bits.length, bitSet.bits.length);
        for (int i = 0; i < n2; ++i) {
            if (this.bits[i] == bitSet.bits[i]) continue;
            return false;
        }
        for (n = i; n < this.bits.length; ++n) {
            if (this.bits[n] == 0L) continue;
            return false;
        }
        for (n = i; n < bitSet.bits.length; ++n) {
            if (bitSet.bits[n] == 0L) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long l = 1234L;
        int n = this.bits.length;
        while (n > 0) {
            l ^= (long)n * this.bits[--n];
        }
        return (int)(l >> 32 ^ l);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        boolean bl = true;
        for (int i = 0; i < this.bits.length; ++i) {
            long l = 1L;
            long l2 = this.bits[i];
            if (l2 == 0L) continue;
            for (int j = 0; j < 64; ++j) {
                if ((l2 & l) != 0L) {
                    if (!bl) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(64 * i + j);
                    bl = false;
                }
                l <<= 1;
            }
        }
        return stringBuffer.append("}").toString();
    }
}

