/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.Comparable;
import moio.util.Number;
import waba.sys.Convert;

public final class Double
extends Number
implements Comparable {
    public static final double NaN = Convert.longBitsToDouble((long)9221120237041090560L);
    private final double value;

    public static boolean isNaN(double d) {
        return Convert.doubleToLongBits((double)d) == 9221120237041090560L;
    }

    public String toString() {
        return this.value + "";
    }

    public int hashCode() {
        long l = Double.doubleToLongBits(this.value);
        return (int)(l ^ l >>> 32);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Double)) {
            return false;
        }
        double d = ((Double)object).value;
        if (this.value == d) {
            return this.value != 0.0 || 1.0 / this.value == 1.0 / d;
        }
        return Double.isNaN(this.value) && Double.isNaN(d);
    }

    public static long doubleToLongBits(double d) {
        return Convert.doubleToLongBits((double)d);
    }

    public int compareTo(Object object) {
        return Double.compare(this.value, ((Double)object).value);
    }

    public static int compare(double d, double d2) {
        if (Double.isNaN(d)) {
            return Double.isNaN(d2) ? 0 : 1;
        }
        if (Double.isNaN(d2)) {
            return -1;
        }
        if (d == 0.0 && d2 == 0.0) {
            return (int)(1.0 / d - 1.0 / d2);
        }
        if (d == d2) {
            return 0;
        }
        return d > d2 ? 1 : -1;
    }
}

