/*
 * Decompiled with CFR 0.152.
 */
package moio.util;

import moio.util.AbstractMap;
import moio.util.AbstractSet;
import moio.util.Cloneable;
import moio.util.IllegalArgumentException;
import moio.util.IllegalStateException;
import moio.util.Iterator;
import moio.util.Map;
import moio.util.NoSuchElementException;
import moio.util.Serializable;
import moio.util.Set;

public class HashMap
extends AbstractMap
implements Cloneable,
Map,
Serializable {
    private int threshold;
    final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set entries;

    public HashMap() {
        this(11, 0.75f);
    }

    public HashMap(int n, float f) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (!(f > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + f);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.loadFactor = f;
        this.threshold = (int)((float)n * f);
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                hashEntry.access();
                Object object3 = hashEntry.value;
                hashEntry.value = object2;
                return object3;
            }
            hashEntry = hashEntry.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(object);
        }
        this.addEntry(object, object2, n, true);
        return null;
    }

    public Object remove(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (AbstractMap.equals(object, hashEntry.key)) {
                ++this.modCount;
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return hashEntry.cleanup();
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public Set keySet() {
        if (this.keys == null) {
            this.keys = new AbstractSet(){

                public int size() {
                    return HashMap.this.size;
                }

                public Iterator iterator() {
                    return HashMap.this.iterator(0);
                }

                public boolean contains(Object object) {
                    return HashMap.this.containsKey(object);
                }

                public boolean remove(Object object) {
                    int n = HashMap.this.size;
                    HashMap.this.remove(object);
                    return n != HashMap.this.size;
                }
            };
        }
        return this.keys;
    }

    public Set entrySet() {
        if (this.entries == null) {
            this.entries = new AbstractSet(){

                public int size() {
                    return HashMap.this.size;
                }

                public Iterator iterator() {
                    return HashMap.this.iterator(2);
                }

                public boolean contains(Object object) {
                    return HashMap.this.getEntry(object) != null;
                }

                public boolean remove(Object object) {
                    HashEntry hashEntry = HashMap.this.getEntry(object);
                    if (hashEntry != null) {
                        HashMap.this.remove(hashEntry.key);
                        return true;
                    }
                    return false;
                }
            };
        }
        return this.entries;
    }

    void addEntry(Object object, Object object2, int n, boolean bl) {
        HashEntry hashEntry = new HashEntry(object, object2);
        hashEntry.next = this.buckets[n];
        this.buckets[n] = hashEntry;
    }

    final HashEntry getEntry(Object object) {
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry = (Map.Entry)object;
        Object object2 = entry.getKey();
        int n = this.hash(object2);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (AbstractMap.equals(hashEntry.key, object2)) {
                return AbstractMap.equals(hashEntry.value, entry.getValue()) ? hashEntry : null;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    final int hash(Object object) {
        return object == null ? 0 : Math.abs(object.hashCode() % this.buckets.length);
    }

    Iterator iterator(int n) {
        return new HashIterator(n);
    }

    private void rehash() {
        HashEntry[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * this.loadFactor);
        this.buckets = new HashEntry[n];
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                int n2 = this.hash(hashEntry.key);
                HashEntry hashEntry2 = this.buckets[n2];
                HashEntry hashEntry3 = hashEntry.next;
                hashEntry.next = this.buckets[n2];
                this.buckets[n2] = hashEntry;
                hashEntry = hashEntry3;
            }
        }
    }

    private final class HashIterator
    implements Iterator {
        private final int type;
        private int knownMod;
        private int count;
        private int idx;
        private HashEntry last;
        private HashEntry next;

        HashIterator(int n) {
            this.knownMod = HashMap.this.modCount;
            this.count = HashMap.this.size;
            this.idx = HashMap.this.buckets.length;
            this.type = n;
        }

        public boolean hasNext() {
            return this.count > 0;
        }

        public Object next() {
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                hashEntry = HashMap.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            this.last = hashEntry;
            if (this.type == 1) {
                return hashEntry.value;
            }
            if (this.type == 0) {
                return hashEntry.key;
            }
            return hashEntry;
        }

        public void remove() {
            if (this.last == null) {
                throw new IllegalStateException();
            }
            HashMap.this.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    static class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        HashEntry(Object object, Object object2) {
            super(object, object2);
        }

        void access() {
        }

        Object cleanup() {
            return this.value;
        }
    }
}

