/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.loc;

import bt747.model.Model;
import bt747.model.ModelEvent;
import bt747.model.ModelListener;
import bt747.sys.Generic;
import bt747.sys.JavaLibBridge;
import bt747.sys.interfaces.BT747Exception;
import gps.log.GPSRecord;

public abstract class LocationSender
implements ModelListener {
    protected int updatePeriod = 3600000;
    Model model = null;
    protected int next_update_time = 0;
    protected double latitude;
    protected double longitude;
    protected float speed;
    protected float heading;
    protected float altitude;
    protected int hdop;
    protected int nsat;
    protected String bluetoothAdress = "";
    private String lastError = "";
    private boolean disabled = false;

    public LocationSender(Model model) {
        this.model = model;
    }

    public void modelEvent(ModelEvent modelEvent) {
        if (this.extractValuesFromEvent(modelEvent) && this.checkUpdateFrequency()) {
            try {
                this.sendOutData();
            }
            catch (BT747Exception bT747Exception) {
                Generic.debug("Location sending", bT747Exception);
            }
        }
    }

    protected boolean extractValuesFromEvent(ModelEvent modelEvent) {
        int n = modelEvent.getType();
        block0 : switch (n) {
            case 3: 
            case 4: {
                GPSRecord gPSRecord = (GPSRecord)modelEvent.getArg();
                this.latitude = gPSRecord.latitude;
                this.longitude = gPSRecord.longitude;
                switch (n) {
                    case 3: {
                        this.speed = gPSRecord.speed;
                        this.heading = gPSRecord.heading;
                        this.altitude = gPSRecord.height;
                        break block0;
                    }
                    case 4: {
                        this.hdop = gPSRecord.hdop / 100;
                        this.nsat = gPSRecord.nsat / 256;
                    }
                }
            }
        }
        return n == 3 || n == 4;
    }

    protected boolean checkUpdateFrequency() {
        int n = JavaLibBridge.getTimeStamp();
        if (n >= this.next_update_time) {
            this.next_update_time = n + this.updatePeriod;
            return true;
        }
        return false;
    }

    protected abstract void sendOutData() throws BT747Exception;

    public void setUpdatePeriod(int n) {
        this.updatePeriod = n;
    }

    public void setBluetoothAdress(String string) {
        this.bluetoothAdress = string;
    }
}

