/*
 * To change this template, choose Tools | Templates and open the template in
 * the editor.
 */

/*
 * MapReference.java
 * 
 * Created on 23 december 2008, 21:59:04
 */

package bt747.j2se_view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

import javax.swing.ScrollPaneConstants;

import net.sf.bt747.j2se.app.list.BT747WaypointListCellRenderer;

import bt747.j2se_view.model.MapWaypoint;
import bt747.j2se_view.model.PositionData;
import bt747.j2se_view.popupmenu.POIActionHandler;
import bt747.j2se_view.popupmenu.TagFilePopupMenu;

/**
 * 
 * @author Mario
 */
@SuppressWarnings("serial")
public class WaypointListMapPanel extends javax.swing.JPanel implements POIActionHandler {

    private WaypointMapKit map;

    /** Creates new form MapReference */
    public WaypointListMapPanel() {
        initComponents();
    }

    private J2SEAppController c;
    private J2SEAppModel m;

    public void init(final J2SEAppController pC) {
        c = pC;
        m = c.getAppModel();

        map.init(c);
        initGui();
    }

    private void initGui() {
        wayPointScrollPane
                .setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_AS_NEEDED);
        // map.setDefaultProvider(JXMapKit.DefaultProviders.OpenStreetMaps);
        waypointList.setModel(m.getPositionData().getWaypointListModel());
        waypointList.setCellRenderer(new BT747WaypointListCellRenderer());
        // waypointList.setPreferredSize(new Dimension(100,0));
        splitPane.setDividerLocation(100);

        new TagFilePopupMenu(wayPointScrollPane, waypointList, this);
        m.getPositionData().addPropertyChangeListener(
                PositionData.WPDISPLAYCHANGE, wpChangeListener);
        m.getPositionData().addPropertyChangeListener(
                PositionData.WAYPOINTSELECTED, wpSelectedListener);
    }

    
    public void addPosition(Object e) {
    	if(e instanceof MapWaypoint) {
    		MapWaypoint w = (MapWaypoint) e;
    		if(!w.getGpsRecord().hasPosition()) {
    			w.setPosition(map.getCenterPosition());
    		}
    	}
    }
    private final PropertyChangeListener wpChangeListener = new PropertyChangeListener() {

        public void propertyChange(PropertyChangeEvent evt) {
            //map.repaint();
            // ? Change  for waypointList ???
        }
    };

    private final PropertyChangeListener wpSelectedListener = new PropertyChangeListener() {

        public void propertyChange(PropertyChangeEvent evt) {
            try {
                final MapWaypoint w = (MapWaypoint) evt.getNewValue();
                if (w != waypointList.getSelectedValue()) {
                    waypointList.setSelectedValue(w, true);
                }
            } catch (Exception e) {
                bt747.sys.Generic.debug("Waypoint selection", e);
                // TODO: handle exception
            }
        }
    };


    // splitPane.setRightComponent(map);
    /**
     * This method is called from within the constructor to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    private void initComponents() {//GEN-BEGIN:initComponents

        splitPane = new javax.swing.JSplitPane();
        wayPointScrollPane = new javax.swing.JScrollPane();
        waypointList = new javax.swing.JList();

        splitPane.setBorder(null);
        splitPane.setOneTouchExpandable(true);
        splitPane.setOpaque(false);
        map = new WaypointMapKit();
        splitPane.setRightComponent(map);

        wayPointScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        wayPointScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);

        waypointList.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "Waypoint" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        waypointList.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        waypointList.setOpaque(false);
        wayPointScrollPane.setViewportView(waypointList);

        splitPane.setLeftComponent(wayPointScrollPane);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(splitPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 182, Short.MAX_VALUE)
                .add(0, 0, 0))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(splitPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 147, Short.MAX_VALUE)
                .add(0, 0, 0))
        );
    }//GEN-END:initComponents

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSplitPane splitPane;
    private javax.swing.JScrollPane wayPointScrollPane;
    private javax.swing.JList waypointList;
    // End of variables declaration//GEN-END:variables

}
