; Script generated by the HM NIS Edit Script Wizard.

;---------------------
;Include Modern UI
!include "MUI.nsh"

;--------------------------------
;General

;Get installation folder from registry if available
;InstallDirRegKey HKCU "Software\Modern UI Test" ""
!define PRODUCT_DIR_REGKEY "Software\Microsoft\Windows\CurrentVersion\App Paths\${PROGRAM_NAME}.exe"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\${PRODUCT_NAME}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
InstallDirRegKey HKLM "${PRODUCT_DIR_REGKEY}" ""

;--------------------------------
;Pages

;!insertmacro MUI_PAGE_STARTMENU Application $ICONS_GROUP
; Instfiles page
Page custom InstallPage
!insertmacro MUI_PAGE_INSTFILES
UninstPage custom un.UninstallPage
!insertmacro MUI_UNPAGE_INSTFILES

;--------------------------------
;Interface Settings

!define MUI_ABORTWARNING

;--------------------------------
;Languages

!insertmacro MUI_LANGUAGE "English"
!include en.nsh
!insertmacro MUI_LANGUAGE "German"
!include de.nsh
!insertmacro MUI_LANGUAGE "French"
!include fr.nsh

;--------------------------------
;Reserve Files

;These files should be inserted before other files in the data block
;Keep these lines before any File command
;Only for solid compression (by default, solid compression is enabled for BZIP2 and LZMA)
ReserveFile "FreeDoko.install.ini"
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS
ReserveFile "FreeDoko.uninstall.ini"


; Uninstallation window

;--------------------------------
;Variables

Var CREATE_DESKTOP_ICON
Var ICONS_GROUP

; load the language files
;LoadLanguageFile "${NSISDIR}\Contrib\Language files\English.nlf"
;LoadLanguageFile "${NSISDIR}\Contrib\Language files\German.nlf"


;!define LANG_ENGLISH 1033
;!define LANG_GERMAN  1031
;!define LANG_FRENCH  ???

; set the text

;--------------------------------
;Installer Sections

Var WindowsLanguageNumber
Var WindowsLanguageNumberLastDigit
Function .onInit
  ;!insertmacro MUI_LANGDLL_DISPLAY
  Call set_language
FunctionEnd

Function set_language
  ; set the language given by the registry
  ReadRegStr $WindowsLanguageNumber "HKCU" "Control Panel\International" "Locale"
  StrCpy $WindowsLanguageNumberLastDigit $WindowsLanguageNumber "" -1
  StrCpy $LANGUAGE ${LANG_ENGLISH}
  StrCmp $WindowsLanguageNumberLastDigit 9 0 +2 ; english
  StrCpy $LANGUAGE ${LANG_ENGLISH}
  StrCmp $WindowsLanguageNumberLastDigit 7 0 +2 ; german
  StrCpy $LANGUAGE ${LANG_GERMAN}
  StrCmp $WindowsLanguageNumberLastDigit A 0 +2 ; spanish
  StrCpy $LANGUAGE ${LANG_ENGLISH}
  StrCmp $WindowsLanguageNumberLastDigit C 0 +2 ; french
  StrCpy $LANGUAGE ${LANG_FRENCH}
FunctionEnd

Function InstallPage
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "FreeDoko.install.ini"

  ; set the text
  !insertmacro MUI_HEADER_TEXT $(LangTitle) $(LangOverview)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 1" "State" \
    $(LangDescription${PRODUCT_NAME})
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 2" "Text" \
    $(LangInstallationDirectory)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 4" "Text" \
    $(LangProgramGroup)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 6" "Text" \
    $(LangCreateSymbolOnDesktop)

  ; set the default values
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 3" "State" "$PROGRAMFILES\${PRODUCT_NAME}"
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 5" "State" ${PRODUCT_NAME}
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.install.ini" "Field 6" "State" "1"

  ; show the window
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "FreeDoko.install.ini"
FunctionEnd

Function un.UninstallPage
  !insertmacro MUI_INSTALLOPTIONS_EXTRACT "FreeDoko.uninstall.ini"

  ; set the text
  !insertmacro MUI_HEADER_TEXT $(LangUninstallTitle) $(LangUninstallOverview)
  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.uninstall.ini" "Field 1" "State" "$(LangUninstallDescription)\r\n$(INSTDIR)"


  !insertmacro MUI_INSTALLOPTIONS_WRITE "FreeDoko.uninstall.ini" "Settings" "NextButtonText" $(LangUninstallButton)

  ; show the window
  !insertmacro MUI_INSTALLOPTIONS_DISPLAY "FreeDoko.uninstall.ini"
FunctionEnd

Section "Installation"
  ;Read the values from
  !insertmacro MUI_INSTALLOPTIONS_READ $CREATE_DESKTOP_ICON "FreeDoko.install.ini" "Field 6" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $ICONS_GROUP "FreeDoko.install.ini" "Field 5" "State"
  !insertmacro MUI_INSTALLOPTIONS_READ $INSTDIR "FreeDoko.install.ini" "Field 3" "State"

  SetOutPath "$INSTDIR"
  SetOverwrite try
  Call install_files

  Call create_icons

  ;Display a messagebox if check box was checked
SectionEnd

Section -Post
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr HKLM "${PRODUCT_DIR_REGKEY}" "" "$INSTDIR\${PROGRAM_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayIcon" "$INSTDIR\${PROGRAM_NAME}.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstDir" "$INSTDIR"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "IconsGroup" "$ICONS_GROUP"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DesktopIcon" "$CREATE_DESKTOP_ICON"

  WriteRegStr HKLM "Software\${PROGRAM_NAME}" "Version" "${PRODUCT_VERSION}"
  WriteRegStr HKLM "Software\${PROGRAM_NAME}" "Directory" "$INSTDIR"
  WriteRegStr HKLM "Software\${PROGRAM_NAME}" "Help Directory" "$INSTDIR\doc\manual"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK $(LangUninstallationFinished)
FunctionEnd

Function un.onInit
  ;!insertmacro MUI_UNGETLANGUAGE
  ;MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 $(LangUninstallation) IDYES +2
  ;Abort
FunctionEnd

Section Uninstall
  ;!insertmacro MUI_STARTMENU_GETFOLDER "Application" $ICONS_GROUP

  ReadRegStr $INSTDIR ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "InstDir"
  ReadRegStr $ICONS_GROUP ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "IconsGroup"
  ReadRegStr $CREATE_DESKTOP_ICON ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DesktopIcon"

  Call un.remove_files
  RMDir "$INSTDIR"

  StrCmp $ICONS_GROUP "" +2
  RMDir /r "$SMPROGRAMS\$ICONS_GROUP"
  StrCmp $CREATE_DESKTOP_ICON "0" +2
  Delete "$DESKTOP\${PROGRAM_NAME}.lnk"

  DeleteRegKey HKLM "${PRODUCT_DIR_REGKEY}"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\DisplayName"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\UninstallString"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\DisplayIcon"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\DisplayVersion"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\URLInfoAbout"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\Publisher"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\InstDir"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\IconsGroup"
  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}\DesktopIcon"

  DeleteRegKey HKLM "Software\${PROGRAM_NAME}\Version"
  DeleteRegKey HKLM "Software\${PROGRAM_NAME}\Directory"
  DeleteRegKey HKLM "Software\${PROGRAM_NAME}\Help Directory"

  SetAutoClose true
SectionEnd
