/*
 * Decompiled with CFR 0.152.
 */
package glguerin.util;

import java.io.File;
import java.lang.reflect.InvocationTargetException;

public class LibLoader {
    public static boolean isVerbose = Boolean.getBoolean("glguerin.util.LibLoader.debug");
    private static LibLoader knownLoader;
    protected final File dirFallback = this.makeFallbackDir();

    public static synchronized LibLoader getLoader() {
        if (knownLoader == null) {
            knownLoader = LibLoader.makeLoader();
        }
        return knownLoader;
    }

    public static LibLoader makeLoader() {
        String string = System.getProperty("glguerin.util.LibLoader.imp", "");
        if (string != null && string.length() > 0) {
            try {
                return (LibLoader)Class.forName(string).newInstance();
            }
            catch (ThreadDeath threadDeath) {
                throw threadDeath;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new LibLoader();
    }

    public LibLoader() {
        this.blab();
    }

    protected void blab() {
        if (isVerbose) {
            System.err.println("# LibLoader dir: " + this.dirFallback);
        }
    }

    public void loadLibrary(String string) {
        try {
            System.loadLibrary(string);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            this.load(string, this.dirFallback);
        }
    }

    protected void load(String string, File file) {
        if (file == null) {
            throw new UnsatisfiedLinkError("Don't know how to load JNI library: " + string);
        }
        String string2 = new File(file, "lib" + string + ".jnilib").getAbsolutePath();
        if (isVerbose) {
            System.err.println("# LibLoader: trying " + string2);
        }
        System.load(string2);
    }

    protected File makeFallbackDir() {
        try {
            Class[] classArray = new Class[]{};
            Object[] objectArray = new Object[]{};
            Class<?> clazz = Class.forName("com.apple.cocoa.foundation.NSBundle");
            if (isVerbose) {
                System.err.println("# LibLoader got NSBundle: " + clazz);
            }
            Object object = clazz.getMethod("mainBundle", classArray).invoke(null, objectArray);
            Object object2 = clazz.getMethod("resourcePath", classArray).invoke(object, objectArray);
            return new File(object2.toString(), "Java");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return null;
    }

    public String toString() {
        return "System.loadLibrary()" + File.pathSeparator + this.dirFallback;
    }
}

