/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.jstestdriver.FileInfo;
import com.google.jstestdriver.hooks.JstdTestCaseProcessor;
import com.google.jstestdriver.hooks.ResourceDependencyResolver;
import com.google.jstestdriver.model.JstdTestCase;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JstdTestCaseFactory {
    private final Set<JstdTestCaseProcessor> processors;
    private final Set<ResourceDependencyResolver> resolvers;

    @Inject
    public JstdTestCaseFactory(Set<JstdTestCaseProcessor> processors, Set<ResourceDependencyResolver> resolvers) {
        this.processors = processors;
        this.resolvers = resolvers;
    }

    public List<JstdTestCase> createCases(List<FileInfo> plugins, List<FileInfo> deps, List<FileInfo> tests) {
        ArrayList<JstdTestCase> testCases = Lists.newArrayList();
        if (!deps.isEmpty() || !tests.isEmpty()) {
            testCases.add(new JstdTestCase(deps, tests, plugins));
        }
        return this.processTestCases(this.resolveDependencies(testCases));
    }

    private List<JstdTestCase> resolveDependencies(List<JstdTestCase> testCases) {
        ArrayList<JstdTestCase> resolved = Lists.newArrayListWithExpectedSize(testCases.size());
        for (JstdTestCase jstdTestCase : testCases) {
            for (ResourceDependencyResolver resolver : this.resolvers) {
                jstdTestCase = resolver.resolve(jstdTestCase);
            }
            resolved.add(jstdTestCase);
        }
        return resolved;
    }

    private List<JstdTestCase> processTestCases(List<JstdTestCase> testCases) {
        for (JstdTestCaseProcessor processor : this.processors) {
            testCases = processor.process(testCases.iterator());
        }
        return testCases;
    }

    public List<JstdTestCase> updateCases(Set<FileInfo> fileSet, List<JstdTestCase> testCases) {
        LinkedHashSet<FileInfo> tests = Sets.newLinkedHashSet();
        for (JstdTestCase testCase : testCases) {
            tests.addAll(testCase.getTests());
        }
        fileSet.removeAll(tests);
        return this.createCases(Collections.<FileInfo>emptyList(), Lists.newArrayList(fileSet), Lists.newArrayList(tests));
    }
}

