/* bdgpExprLink.c was originally generated by the autoSql program, which also 
 * generated bdgpExprLink.h and bdgpExprLink.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "bdgpExprLink.h"


void bdgpExprLinkStaticLoad(char **row, struct bdgpExprLink *ret)
/* Load a row from bdgpExprLink table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{
ret->symbol = row[0];
ret->bdgpName = row[1];
ret->flyBaseId = row[2];
ret->est = row[3];
ret->imageCount = sqlSigned(row[4]);
ret->bodyPartCount = sqlSigned(row[5]);
ret->plate = row[6];
ret->platePos = sqlSigned(row[7]);
ret->newRelease = row[8][0];
}

struct bdgpExprLink *bdgpExprLinkLoad(char **row)
/* Load a bdgpExprLink from row fetched with select * from bdgpExprLink
 * from database.  Dispose of this with bdgpExprLinkFree(). */
{
struct bdgpExprLink *ret;

AllocVar(ret);
ret->symbol = cloneString(row[0]);
ret->bdgpName = cloneString(row[1]);
ret->flyBaseId = cloneString(row[2]);
ret->est = cloneString(row[3]);
ret->imageCount = sqlSigned(row[4]);
ret->bodyPartCount = sqlSigned(row[5]);
ret->plate = cloneString(row[6]);
ret->platePos = sqlSigned(row[7]);
ret->newRelease = row[8][0];
return ret;
}

struct bdgpExprLink *bdgpExprLinkLoadAll(char *fileName) 
/* Load all bdgpExprLink from a whitespace-separated file.
 * Dispose of this with bdgpExprLinkFreeList(). */
{
struct bdgpExprLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileRow(lf, row))
    {
    el = bdgpExprLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bdgpExprLink *bdgpExprLinkLoadAllByChar(char *fileName, char chopper) 
/* Load all bdgpExprLink from a chopper separated file.
 * Dispose of this with bdgpExprLinkFreeList(). */
{
struct bdgpExprLink *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[9];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = bdgpExprLinkLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct bdgpExprLink *bdgpExprLinkCommaIn(char **pS, struct bdgpExprLink *ret)
/* Create a bdgpExprLink out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new bdgpExprLink */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->symbol = sqlStringComma(&s);
ret->bdgpName = sqlStringComma(&s);
ret->flyBaseId = sqlStringComma(&s);
ret->est = sqlStringComma(&s);
ret->imageCount = sqlSignedComma(&s);
ret->bodyPartCount = sqlSignedComma(&s);
ret->plate = sqlStringComma(&s);
ret->platePos = sqlSignedComma(&s);
sqlFixedStringComma(&s, &(ret->newRelease), sizeof(ret->newRelease));
*pS = s;
return ret;
}

void bdgpExprLinkFree(struct bdgpExprLink **pEl)
/* Free a single dynamically allocated bdgpExprLink such as created
 * with bdgpExprLinkLoad(). */
{
struct bdgpExprLink *el;

if ((el = *pEl) == NULL) return;
freeMem(el->symbol);
freeMem(el->bdgpName);
freeMem(el->flyBaseId);
freeMem(el->est);
freeMem(el->plate);
freez(pEl);
}

void bdgpExprLinkFreeList(struct bdgpExprLink **pList)
/* Free a list of dynamically allocated bdgpExprLink's */
{
struct bdgpExprLink *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    bdgpExprLinkFree(&el);
    }
*pList = NULL;
}

void bdgpExprLinkOutput(struct bdgpExprLink *el, FILE *f, char sep, char lastSep) 
/* Print out bdgpExprLink.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->symbol);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->bdgpName);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->flyBaseId);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->est);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->imageCount);
fputc(sep,f);
fprintf(f, "%d", el->bodyPartCount);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->plate);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%d", el->platePos);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%c", el->newRelease);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

