# cgapSageLib.sql was originally generated by the autoSql program, which also 
# generated cgapSageLib.c and cgapSageLib.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#CGAP SAGE libraries info
CREATE TABLE cgapSageLib (
    libId int unsigned not null,	# Numeric library ID
    oldLibName varchar(255) not null,	# Old library name
    newLibName varchar(255) not null,	# New library name
    totalTags int unsigned not null,	# Total tags including linker
    totalTagsNoLinker int unsigned not null,	# Total tags after eliminating linker
    uniqueTags int unsigned not null,	# Unique tags
    quality int unsigned not null,	# Library quality
    tissue varchar(255) not null,	# Organ/tissue
    tissuePrep varchar(255) not null,	# Tissue preparation
    cellType longblob not null,	# Cell type
    keywords varchar(255) not null,	# Keywords
    age varchar(255) not null,	# Patient age
    sex set("male", "female") not null,	# Patient sex
    mutations varchar(255) not null,	# Mutations
    otherInfo longblob not null,	# Other information
    tagEnzyme varchar(255) not null,	# Tagging enzyme
    anchorEnzyme varchar(255) not null,	# Anchoring enzyme
    cellSupplier varchar(255) not null,	# Tissue or cell line supplier
    libProducer varchar(255) not null,	# Library producer
    laboratory varchar(255) not null,	# Laboratory
    refs longblob not null,	# References
              #Indices
    PRIMARY KEY(libId)
);
