# hgFindSpec.sql was originally generated by the autoSql program, which also 
# generated hgFindSpec.c and hgFindSpec.h.  This creates the database representation of
# an object which can be loaded and saved from RAM in a fairly 
# automatic way.

#This defines a search to be performed by hgFind.
CREATE TABLE hgFindSpec (
    searchName varchar(255) not null,	# Unique name for this search.  Defaults to searchTable if not specified in .ra.
    searchTable varchar(255) not null,	# (Non-unique!) Table to be searched.  (Like trackDb.tableName: if split, omit chr*_ prefix.)
    searchMethod varchar(255) not null,	# Type of search (exact, prefix, fuzzy).
    searchType varchar(255) not null,	# Type of search (bed, genePred, knownGene etc).
    shortCircuit tinyint unsigned not null,	# If nonzero, and there is a result from this search, jump to the result instead of performing other searches.
    termRegex varchar(255) not null,	# Regular expression (see man 7 regex) to eval on search term: if it matches, perform search query.
    query varchar(255) not null,	# sprintf format string for SQL query on a given table and value.
    xrefTable varchar(255) not null,	# If search is xref, perform xrefQuery on search term, then query with that result.
    xrefQuery varchar(255) not null,	# sprintf format string for SQL query on a given (xref) table and value.
    searchPriority float not null,	# 0-1000 - relative order/importance of this search.  0 is top.
    searchDescription varchar(255) not null,	# Description of table/search (default: trackDb.{longLabel,tableName})
    searchSettings longblob not null,	# Name/value pairs for searchType-specific stuff.
              #Indices
    PRIMARY KEY(searchName)
);
