/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.reader;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.KeyDef;
import org.dita.dost.util.StringUtils;
import org.dita.dost.util.URLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public final class KeydefFilter
extends AbstractXMLFilter {
    private URI currentDir = null;
    private final Map<String, KeyDef> keysDefMap = new HashMap<String, KeyDef>();
    private final Map<String, String> keysRefMap = new HashMap<String, String>();

    public Map<String, KeyDef> getKeysDMap() {
        return this.keysDefMap;
    }

    public void setCurrentDir(URI dir) {
        this.currentDir = dir;
    }

    public void reset() {
        this.currentDir = null;
        this.keysDefMap.clear();
        this.keysRefMap.clear();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.handleKeysAttr(atts);
        this.getContentHandler().startElement(uri, localName, qName, atts);
    }

    @Override
    public void endDocument() throws SAXException {
        this.checkMultiLevelKeys(this.keysDefMap, this.keysRefMap);
        this.getContentHandler().endDocument();
    }

    private void handleKeysAttr(Attributes atts) {
        String attrValue = atts.getValue("keys");
        if (attrValue != null) {
            URI target = URLUtils.toURI(atts.getValue("href"));
            URI copyTo = URLUtils.toURI(atts.getValue("copy-to"));
            if (copyTo != null) {
                target = copyTo;
            }
            String keyRef = atts.getValue("keyref");
            for (String key : attrValue.trim().split("\\s+")) {
                if (!this.keysDefMap.containsKey(key)) {
                    if (target != null && !target.toString().isEmpty()) {
                        String attrScope = atts.getValue("scope");
                        String attrFormat = atts.getValue("format");
                        if (attrScope != null && (attrScope.equals("external") || attrScope.equals("peer"))) {
                            this.keysDefMap.put(key, new KeyDef(key, target, attrScope, attrFormat, null, null));
                            continue;
                        }
                        String tail = null;
                        if (target.getFragment() != null) {
                            tail = target.getFragment();
                            target = URLUtils.stripFragment(target);
                        }
                        if (!target.isAbsolute()) {
                            target = this.currentDir.resolve(target);
                        }
                        this.keysDefMap.put(key, new KeyDef(key, URLUtils.setFragment(target, tail), "local", attrFormat, null, null));
                        continue;
                    }
                    if (!StringUtils.isEmptyString(keyRef)) {
                        this.keysRefMap.put(key, keyRef);
                        continue;
                    }
                    this.keysDefMap.put(key, new KeyDef(key, null, null, null, null, null));
                    continue;
                }
                this.logger.info(MessageUtils.getMessage("DOTJ045I", key).setLocation(atts).toString());
            }
        }
    }

    private List<String> getKeysList(String key, Map<String, String> keysRefMap) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, String> entry : keysRefMap.entrySet()) {
            if (!entry.getValue().equals(key)) continue;
            String entryKey = entry.getKey();
            list.add(entryKey);
            if (!keysRefMap.containsValue(entryKey)) continue;
            List<String> tempList = this.getKeysList(entryKey, keysRefMap);
            list.addAll(tempList);
        }
        return list;
    }

    private void checkMultiLevelKeys(Map<String, KeyDef> keysDefMap, Map<String, String> keysRefMap) {
        HashMap<String, KeyDef> tempMap = new HashMap<String, KeyDef>();
        for (Map.Entry<String, KeyDef> entry : keysDefMap.entrySet()) {
            String key = entry.getKey();
            KeyDef value = entry.getValue();
            if (!keysRefMap.containsValue(key)) continue;
            List<String> keysList = this.getKeysList(key, keysRefMap);
            for (String multikey : keysList) {
                tempMap.put(multikey, value);
            }
        }
        keysDefMap.putAll(tempMap);
    }
}

