/*
 * Decompiled with CFR 0.152.
 */
package org.dita.dost.writer;

import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dita.dost.log.MessageUtils;
import org.dita.dost.util.Configuration;
import org.dita.dost.util.Constants;
import org.dita.dost.util.XMLUtils;
import org.dita.dost.writer.AbstractXMLFilter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class NormalizeTableFilter
extends AbstractXMLFilter {
    private static final String ATTRIBUTE_NAME_COLNAME = "colname";
    private static final String ATTRIBUTE_NAME_COLNUM = "colnum";
    private static final String ATTRIBUTE_NAME_COLWIDTH = "colwidth";
    private static final String COLUMN_NAME_COL = "col";
    private static final String ATTR_MORECOLS = "morecols";
    private static final String ATTR_X = "x";
    private static final String ATTR_Y = "y";
    private final Deque<String> classStack = new LinkedList<String>();
    private final Map<String, String> ns = new HashMap<String, String>();
    private int depth = 0;
    private final Deque<TableState> tableStack = new LinkedList<TableState>();
    private TableState tableState;
    private Configuration.Mode processingMode;

    @Deprecated
    public void setProcessingMode(Configuration.Mode processingMode) {
        this.processingMode = processingMode;
    }

    @Override
    public void startDocument() throws SAXException {
        String mode = (String)this.params.get("processing-mode");
        this.processingMode = mode != null ? Configuration.Mode.valueOf(mode.toUpperCase()) : Configuration.Mode.LAX;
        this.getContentHandler().startDocument();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.ns.put(prefix, uri);
        this.getContentHandler().startPrefixMapping(prefix, uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        this.getContentHandler().endPrefixMapping(prefix);
        this.ns.remove(prefix);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        ++this.depth;
        if (this.depth == 1 && !this.ns.containsKey("dita-ot")) {
            this.startPrefixMapping("dita-ot", "http://dita-ot.sourceforge.net/ns/201007/dita-ot");
        }
        AttributesImpl res = new AttributesImpl(atts);
        String cls = atts.getValue("class");
        this.classStack.addFirst(cls);
        if (Constants.TOPIC_TGROUP.matches(cls)) {
            this.tableState = new TableState();
            this.tableStack.addFirst(this.tableState);
            this.tableState.cols = this.getColCount(atts);
            this.tableState.colSpec = new ArrayList<String>();
        } else if (Constants.TOPIC_COLSPEC.matches(cls)) {
            this.processColspec(res);
        } else if (Constants.TOPIC_TBODY.matches(cls) || Constants.TOPIC_THEAD.matches(cls)) {
            if (this.tableState.columnNumberEnd < this.tableState.cols && this.tableState.cols != -1) {
                int length = this.tableState.cols - this.tableState.totalColumns;
                for (int i = 0; i < length; ++i) {
                    this.generateColSpec();
                }
            }
        } else if (Constants.TOPIC_ROW.matches(cls)) {
            if (this.tableState == null) {
                this.tableState = new TableState();
            }
            this.tableState.columnNumber = 1;
            this.tableState.columnNumberEnd = 0;
            ++this.tableState.rowNumber;
            if (this.tableState.previousRow != null) {
                List<Span> fromPrew = this.tableState.previousRow.stream().map(s -> {
                    if (s == null) {
                        return null;
                    }
                    return s.y > 1 ? new Span(s.x, s.y - 1) : null;
                }).toList();
                this.tableState.currentRow = new ArrayList<Span>(fromPrew);
            } else {
                this.tableState.currentRow = new ArrayList();
            }
            this.tableState.currentColumn = 0;
        } else if (Constants.TOPIC_ENTRY.matches(cls)) {
            if (this.tableState == null) {
                this.tableState = new TableState();
            }
            this.processEntry(res);
        }
        this.getContentHandler().startElement(uri, localName, qName, res);
    }

    private void generateColSpec() throws SAXException {
        AttributesImpl attr = new AttributesImpl();
        XMLUtils.addOrSetAttribute(attr, "class", Constants.TOPIC_COLSPEC.toString());
        this.processColspec(attr);
        this.getContentHandler().startElement("", Constants.TOPIC_COLSPEC.localName, Constants.TOPIC_COLSPEC.localName, attr);
        this.getContentHandler().endElement("", Constants.TOPIC_COLSPEC.localName, Constants.TOPIC_COLSPEC.localName);
    }

    private void processEntry(AttributesImpl res) throws SAXException {
        try {
            this.tableState.columnNumber = this.getStartNumber(res, this.tableState.columnNumberEnd);
            int colspan = this.getColSpan(res);
            int rowspan = this.getRowSpan(res);
            if (this.tableState.previousRow != null) {
                Span prev = this.tableState.previousRow.get(this.tableState.currentColumn);
                while (prev != null && prev.y > 1) {
                    for (int i = 0; i < prev.x; ++i) {
                        ++this.tableState.currentColumn;
                        this.grow(this.tableState.currentRow, this.tableState.currentColumn + 1);
                    }
                    prev = this.tableState.previousRow.get(this.tableState.currentColumn);
                }
            } else {
                Span prev = new Span(1, 1);
            }
            this.grow(this.tableState.currentRow, this.tableState.currentColumn + colspan);
            Span span = new Span(colspan, rowspan);
            this.tableState.currentRow.set(this.tableState.currentColumn, span);
            XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLNAME, COLUMN_NAME_COL + (this.tableState.currentColumn + 1));
            if (res.getValue("namest") != null) {
                XMLUtils.addOrSetAttribute(res, "namest", COLUMN_NAME_COL + this.tableState.columnNumber);
            }
            if (res.getValue("nameend") != null) {
                XMLUtils.addOrSetAttribute(res, "nameend", COLUMN_NAME_COL + this.getEndNumber(res, this.tableState.columnNumber));
                XMLUtils.addOrSetAttribute(res, "http://dita-ot.sourceforge.net/ns/201007/dita-ot", ATTR_MORECOLS, "dita-ot:morecols", "CDATA", Integer.toString(span.x - 1));
            }
            XMLUtils.addOrSetAttribute(res, "http://dita-ot.sourceforge.net/ns/201007/dita-ot", ATTR_X, "dita-ot:x", "CDATA", Integer.toString(this.tableState.currentColumn + 1));
            XMLUtils.addOrSetAttribute(res, "http://dita-ot.sourceforge.net/ns/201007/dita-ot", ATTR_Y, "dita-ot:y", "CDATA", Integer.toString(this.tableState.rowNumber));
            this.tableState.currentColumn += colspan;
            this.tableState.columnNumberEnd = this.getEndNumber(res, this.tableState.columnNumber);
        }
        catch (IndexOutOfBoundsException e) {
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new SAXException(MessageUtils.getMessage("DOTJ082E", new String[0]).setLocation(res).toString());
            }
            this.logger.error(MessageUtils.getMessage("DOTJ082E", new String[0]).setLocation(res).toString());
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.getContentHandler().endElement(uri, localName, qName);
        String cls = this.classStack.removeFirst();
        if (Constants.TOPIC_TGROUP.matches(cls)) {
            this.tableStack.removeFirst();
            this.tableState = this.tableStack.peekFirst();
        } else if (Constants.TOPIC_ROW.matches(cls)) {
            this.tableState.previousRow = this.tableState.currentRow;
            this.tableState.currentRow = null;
            this.tableState.currentColumn = -1;
        }
        if (this.depth == 1) {
            this.endPrefixMapping("dita-ot");
        }
        --this.depth;
    }

    private void grow(List<?> array, int size) {
        while (array.size() < size) {
            array.add(null);
        }
    }

    private int getColSpan(Attributes atts) {
        String start = atts.getValue("namest");
        String end = atts.getValue("nameend");
        if (start != null && end != null) {
            int colnumStart = this.tableState.colSpec.indexOf(start);
            int colnumEnd = this.tableState.colSpec.indexOf(end);
            int ret = colnumEnd - colnumStart + 1;
            return ret <= 0 ? 1 : ret;
        }
        return 1;
    }

    private int getRowSpan(Attributes atts) {
        String span = atts.getValue("morerows");
        if (span != null) {
            return Integer.parseInt(span) + 1;
        }
        return 1;
    }

    private int getColCount(Attributes atts) throws SAXException {
        String c = atts.getValue("cols").trim();
        try {
            return Integer.parseInt(c);
        }
        catch (NumberFormatException e) {
            if (this.processingMode == Configuration.Mode.STRICT) {
                throw new SAXException(MessageUtils.getMessage("DOTJ062E", "cols", c).setLocation(atts).toString());
            }
            this.logger.error(MessageUtils.getMessage("DOTJ062E", "cols", c).setLocation(atts).toString());
            return -1;
        }
    }

    private void processColspec(AttributesImpl res) {
        this.tableState.columnNumber = this.tableState.columnNumberEnd + 1;
        Object colName = res.getValue(ATTRIBUTE_NAME_COLNAME) != null ? res.getValue(ATTRIBUTE_NAME_COLNAME) : COLUMN_NAME_COL + this.tableState.columnNumber;
        this.grow(this.tableState.colSpec, this.tableState.columnNumber);
        this.tableState.colSpec.set(this.tableState.columnNumber - 1, (String)colName);
        String colNum = res.getValue(ATTRIBUTE_NAME_COLNUM);
        if (colNum == null || colNum.isEmpty()) {
            XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLNUM, Integer.toString(this.tableState.columnNumber));
        }
        this.tableState.columnNumberEnd = this.tableState.columnNumber;
        XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLNAME, COLUMN_NAME_COL + this.tableState.columnNumber);
        this.tableState.totalColumns = this.tableState.columnNumberEnd;
        String colWidth = res.getValue(ATTRIBUTE_NAME_COLWIDTH);
        if (colWidth != null) {
            if (colWidth.isEmpty()) {
                XMLUtils.removeAttribute(res, ATTRIBUTE_NAME_COLWIDTH);
            } else if (colWidth.equals("*")) {
                XMLUtils.addOrSetAttribute(res, ATTRIBUTE_NAME_COLWIDTH, "1*");
            }
        }
    }

    private int getEndNumber(Attributes atts, int columnStart) {
        String end = atts.getValue("nameend");
        if (end == null) {
            return columnStart;
        }
        int ret = this.tableState.colSpec.indexOf(end) + 1;
        if (ret == 0) {
            return columnStart;
        }
        return ret;
    }

    private int getStartNumber(Attributes atts, int previousEnd) {
        String num = atts.getValue(ATTRIBUTE_NAME_COLNUM);
        String start = atts.getValue("namest");
        String name = atts.getValue(ATTRIBUTE_NAME_COLNAME);
        if (num != null) {
            return Integer.parseInt(num);
        }
        if (start != null) {
            int ret = this.tableState.colSpec.indexOf(start) + 1;
            if (ret == 0) {
                return previousEnd + 1;
            }
            return ret;
        }
        if (name != null) {
            int ret = this.tableState.colSpec.indexOf(name) + 1;
            if (ret == 0) {
                return previousEnd + 1;
            }
            return ret;
        }
        return previousEnd + 1;
    }

    private static class TableState {
        public List<String> colSpec;
        public int rowNumber = 0;
        public ArrayList<Span> previousRow;
        public ArrayList<Span> currentRow;
        public int currentColumn;
        public int columnNumber = 1;
        public int columnNumberEnd = 0;
        public int totalColumns = 0;
        public int cols;

        private TableState() {
        }
    }

    private record Span(int x, int y) {
    }
}

