/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class LoggingOutputStream
extends FilterOutputStream {
    private static final byte MIN_VISIBLE_CHAR = 32;
    private static final byte MAX_VISIBLE_CHAR = 126;
    private static final byte PREFIX = 61;
    private static final byte LF = 10;
    private static final byte CR = 13;
    private static final byte START1 = 48;
    private static final byte START2 = 55;
    private byte[] buffer = new byte[1024];

    public LoggingOutputStream(OutputStream out) {
        super(out);
    }

    private int quote(byte[] b, int off, int len) {
        int buffered = 0;
        int i = 0;
        while (i < len) {
            int n = this.quote(b[i], buffered);
            buffered += n;
            ++i;
        }
        return buffered;
    }

    private int quote(byte b, int bufferOffset) {
        if (b != 10 && b != 13 && (b == 61 || b < 32 || b > 126)) {
            this.ensureBufferSize(bufferOffset + 2);
            this.buffer[bufferOffset] = 61;
            this.buffer[bufferOffset + 1] = LoggingOutputStream.toHex((b & 0xF0) >> 4);
            this.buffer[bufferOffset + 2] = LoggingOutputStream.toHex(b & 0xF);
            return 3;
        }
        this.ensureBufferSize(bufferOffset);
        this.buffer[bufferOffset] = b;
        return 1;
    }

    private static final byte toHex(int x) {
        if (x < 10) {
            return (byte)(48 + x);
        }
        return (byte)(55 + x);
    }

    private void ensureBufferSize(int expectedSize) {
        if (expectedSize >= this.buffer.length) {
            byte[] newBuffer = new byte[(int)((double)this.buffer.length * 1.4)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        int n = this.quote(b, 0, b.length);
        try {
            this.out.write(this.buffer, 0, n);
            this.out.flush();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        int n = this.quote(b, off, len);
        try {
            this.out.write(this.buffer, 0, n);
            this.out.flush();
        }
        catch (IOException iOException) {}
    }

    @Override
    public void write(int b) throws IOException {
        int n = this.quote((byte)b, 0);
        try {
            this.out.write(this.buffer, 0, n);
            this.out.flush();
        }
        catch (IOException iOException) {}
    }
}

