/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.brainstorm;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.xmind.gef.IGraphicalViewer;
import org.xmind.gef.IViewer;
import org.xmind.gef.Request;
import org.xmind.gef.part.IPart;
import org.xmind.ui.color.IColorSelection;
import org.xmind.ui.color.PaletteContents;
import org.xmind.ui.color.PaletteViewer;
import org.xmind.ui.commands.CommandMessages;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.richtext.RichTextUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundPopup
extends PopupDialog {
    private IGraphicalViewer viewer;
    private PaletteViewer paletteViewer;
    boolean isOpenColorDialog = false;

    public BackgroundPopup(IGraphicalViewer viewer) {
        this(viewer.getControl().getShell());
        this.viewer = viewer;
    }

    public BackgroundPopup(IWorkbenchWindow window) {
        this(window.getShell());
    }

    public BackgroundPopup(Shell shell) {
        super(shell, 2064, true, true, true, false, false, "Background", null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData layoutData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)layoutData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        this.createColorContents(composite);
        return composite;
    }

    private void createColorContents(Composite composite) {
        GridLayoutFactory layout = GridLayoutFactory.fillDefaults().spacing(0, 0);
        GridDataFactory layoutData = GridDataFactory.fillDefaults().grab(true, false);
        layout.copy().margins(4, 4).applyTo(composite);
        if (this.paletteViewer == null) {
            this.paletteViewer = new PaletteViewer(){

                protected RGB openNativeColorDialog(Shell shell, RGB oldColor) {
                    BackgroundPopup.this.isOpenColorDialog = true;
                    RGB ret = super.openNativeColorDialog(shell, oldColor);
                    BackgroundPopup.this.isOpenColorDialog = false;
                    return ret;
                }
            };
            this.paletteViewer.setShowAutoItem(false);
            this.paletteViewer.setShowNoneItem(false);
            this.paletteViewer.setShowCustomItem(true);
            this.paletteViewer.addSelectionChangedListener((ISelectionChangedListener)new SelectionChangedListener());
        }
        this.paletteViewer.createControl(composite);
        layoutData.applyTo(this.paletteViewer.getControl());
        this.paletteViewer.setAutoColor(RichTextUtils.DEFAULT_FOREGROUND.getRGB());
        this.paletteViewer.setInput((Object)PaletteContents.getDefault());
    }

    protected Point getInitialLocation(Point initialSize) {
        return new Point(50, 50);
    }

    public boolean close() {
        if (this.isOpenColorDialog) {
            return false;
        }
        return super.close();
    }

    private void setSelection(ISelection selection) {
        if (selection == null || !(selection instanceof IColorSelection)) {
            return;
        }
        this.changeBackgroundColor((IColorSelection)selection);
    }

    private void changeBackgroundColor(IColorSelection selection) {
        Request request = new Request("modify_style").setViewer((IViewer)this.viewer);
        request.setParameter("commandLabel", (Object)CommandMessages.Command_ModifySheetBackgroundColor);
        String color = ColorUtils.toString((RGB)selection.getColor());
        request.setParameter("styleProperty.svg:fill", (Object)color);
        request.setTargets(this.fillParts());
        this.viewer.getEditDomain().handleRequest(request);
    }

    private List<IPart> fillParts() {
        ArrayList<IPart> parts = new ArrayList<IPart>();
        ISelection selection = this.viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection s = (IStructuredSelection)selection;
            Object[] objectArray = s.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object o = objectArray[n2];
                IPart part = this.viewer.findPart(o);
                parts.add(part);
                ++n2;
            }
        }
        return parts;
    }

    private class SelectionChangedListener
    implements ISelectionChangedListener {
        private SelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            BackgroundPopup.this.setSelection(event.getSelection());
        }
    }
}

