/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.eclipse.core.runtime.IPath;
import org.xmind.core.util.FileUtils;
import org.xmind.ui.editor.EditorHistoryItem;
import org.xmind.ui.editor.IEditorHistory;
import org.xmind.ui.editor.IEditorHistoryItem;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.EditorHistoryImpl;
import org.xmind.ui.internal.editor.IEditorHistoryLoader;
import org.xmind.ui.util.Logger;

public class EditorHistoryPersistenceHelper
implements IEditorHistoryLoader,
IEditorHistory.IEditorHistoryListener {
    private static final String VALUE_SEPARATOR = "#$#";
    private static final String KEY_PREFIX = "item.";
    private static final String PINNED_KEY_HISTORY_ITEM_PREFIX = "pinned.editor.history.item.";
    private static final String UNPINNED_KEY_HISTORY_ITEM_PREFIX = "unpinned.editor.history.item.";
    private static final String PINNED_KEY_PREFIX = "pinned.item.";
    private static final String THUMBNAIL_PREFIX = "thumbnail.";
    private static final String OLD_FILE_NAME = "workbookHistory.properties";
    private static final String FILE_NAME = ".workbookHistory.properties";
    private static final String THUMBNAIL_DIR_NAME = ".thumbnailHistory";
    private static final Object END_OF_QUEUE = new Object();
    private final IPath basePath;
    private final BlockingQueue<Object> stateQueue;
    private Thread thread;
    private EditorHistoryImpl service;

    public EditorHistoryPersistenceHelper(IPath basePath) {
        this.basePath = basePath;
        this.stateQueue = new LinkedBlockingQueue<Object>();
        this.thread = null;
        this.service = null;
    }

    public void setService(EditorHistoryImpl service) {
        EditorHistoryImpl oldService = this.service;
        if (service == oldService) {
            return;
        }
        this.service = service;
        if (oldService != null) {
            oldService.removeEditorHistoryListener(this);
        }
        if (service != null) {
            service.addEditorHistoryListener(this);
        }
        if (oldService == null && service != null) {
            this.startThread();
        } else if (oldService != null && service == null) {
            this.stopThread();
        }
    }

    @Override
    public void load(IEditorHistoryLoader.IEditorHistoryLoaderCallback callback) {
        Properties historyRepository = this.load();
        int index = 0;
        while (index < historyRepository.size()) {
            String unpinnedKey = KEY_PREFIX + index;
            String pinnedKey = PINNED_KEY_PREFIX + index;
            String pinnedThumbnailKey = THUMBNAIL_PREFIX + pinnedKey;
            String unpinnedThumbnailKey = THUMBNAIL_PREFIX + unpinnedKey;
            String pinedEditorHistoryItemKey = PINNED_KEY_HISTORY_ITEM_PREFIX + index;
            String unPinedEditorHistoryItemKey = UNPINNED_KEY_HISTORY_ITEM_PREFIX + index;
            String unpinnedInputURI = historyRepository.getProperty(unpinnedKey);
            String pinnedInputURI = historyRepository.getProperty(pinnedKey);
            String unpinnedThumbnailURI = historyRepository.getProperty(unpinnedThumbnailKey);
            String pinnedThumbnailURI = historyRepository.getProperty(pinnedThumbnailKey);
            unpinnedInputURI = this.fixFileUri(unpinnedInputURI);
            pinnedInputURI = this.fixFileUri(pinnedInputURI);
            unpinnedThumbnailURI = this.fixFileUri(unpinnedThumbnailURI);
            pinnedThumbnailURI = this.fixFileUri(pinnedThumbnailURI);
            String pinedItemJson = historyRepository.getProperty(pinedEditorHistoryItemKey);
            IEditorHistoryItem pinnedItem = EditorHistoryItem.readEditorHistoryItem(pinnedInputURI, pinedItemJson);
            String unpinedItemJson = historyRepository.getProperty(unPinedEditorHistoryItemKey);
            IEditorHistoryItem unpinedItem = EditorHistoryItem.readEditorHistoryItem(unpinnedInputURI, unpinedItemJson);
            try {
                if (unpinnedInputURI != null) {
                    URI unpinnedURI = new URI(unpinnedInputURI);
                    callback.inputURILoaded(unpinnedURI);
                    if (unpinedItem != null) {
                        callback.editorHistoryItemsLoaded(unpinnedURI, unpinedItem);
                    }
                    if (unpinnedThumbnailURI != null && !unpinnedInputURI.isEmpty()) {
                        callback.thumbnailURILoaded(unpinnedURI, new URI(unpinnedThumbnailURI));
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            try {
                if (pinnedInputURI != null) {
                    URI pinnedURI = new URI(pinnedInputURI);
                    callback.pinnedInputURILoaded(pinnedURI);
                    if (pinnedItem != null) {
                        callback.editorHistoryItemsLoaded(pinnedURI, pinnedItem);
                    }
                    if (pinnedThumbnailURI != null && !pinnedInputURI.isEmpty()) {
                        callback.thumbnailURILoaded(pinnedURI, new URI(pinnedThumbnailURI));
                    }
                }
            }
            catch (URISyntaxException uRISyntaxException) {}
            ++index;
        }
    }

    private String fixFileUri(String uri) {
        if (uri != null && uri.startsWith("file:")) {
            boolean error;
            String specialPart = uri.substring(5);
            boolean bl = error = specialPart.startsWith("//") && !specialPart.startsWith("///");
            if (error) {
                return "file:/" + specialPart;
            }
        }
        return uri;
    }

    @Override
    public URI saveThumbnail(InputStream thumbnailData) throws IOException {
        File thumbnailDir = this.getThumbnailDir();
        if (thumbnailDir == null) {
            return null;
        }
        if (!thumbnailDir.exists()) {
            thumbnailDir.mkdirs();
        }
        String thumbnailName = UUID.randomUUID().toString();
        File thumbnailFile = new File(thumbnailDir, thumbnailName);
        FileOutputStream output = new FileOutputStream(thumbnailFile);
        try {
            FileUtils.transfer((InputStream)thumbnailData, (OutputStream)output, (boolean)false);
        }
        finally {
            ((OutputStream)output).close();
        }
        return thumbnailFile.toURI();
    }

    private File getThumbnailDir() {
        IPath basePath = MindMapUIPlugin.getDefault().getStateLocation();
        if (basePath == null) {
            return null;
        }
        IPath filePath = basePath.append(THUMBNAIL_DIR_NAME);
        return filePath.toFile();
    }

    @Override
    public void dispose() {
        this.setService(null);
    }

    private void startThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                EditorHistoryPersistenceHelper.this.runLoop();
            }
        });
        thread.setName("EditorHistoryPersistenceThread");
        thread.setPriority(1);
        thread.setDaemon(true);
        this.thread = thread;
        thread.start();
        this.editorHistoryChanged();
    }

    private void stopThread() {
        if (this.service != null) {
            this.service.removeEditorHistoryListener(this);
        }
        this.stateQueue.offer(END_OF_QUEUE);
        Thread thread = this.thread;
        this.thread = null;
        if (thread != null) {
            thread.interrupt();
        }
    }

    @Override
    public void editorHistoryChanged() {
        if (this.service == null) {
            return;
        }
        EditorHistoryState state = EditorHistoryState.createFrom(this.service);
        this.stateQueue.offer(state);
    }

    private void runLoop() {
        try {
            while (this.thread != null) {
                Object state = this.stateQueue.take();
                if (state != END_OF_QUEUE) {
                    this.save((EditorHistoryState)state);
                    Thread.sleep(0L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private void save(EditorHistoryState persistable) {
        File oldHistoryFile;
        String thumbnailKey;
        URI thumbnail;
        String key;
        URI input;
        Properties repository = new Properties();
        URI[] pinnedInputURIs = persistable.getPinnedInputURIs();
        URI[] unpinnedInputURIs = persistable.getUnpinnedInputURIs();
        int index = 0;
        while (index < pinnedInputURIs.length) {
            input = pinnedInputURIs[index];
            if (input != null) {
                key = PINNED_KEY_PREFIX + index;
                repository.setProperty(key, input.toString());
                String pinnedEditorHistoryItemKey = PINNED_KEY_HISTORY_ITEM_PREFIX + index;
                IEditorHistoryItem pinnedItem = persistable.getEditorHistoryItem(input);
                if (pinnedItem != null) {
                    repository.setProperty(pinnedEditorHistoryItemKey, pinnedItem.toJson());
                }
                thumbnail = persistable.getThumbnail(input);
                thumbnailKey = THUMBNAIL_PREFIX + key;
                if (thumbnail != null) {
                    repository.setProperty(thumbnailKey, thumbnail.toString());
                }
            }
            ++index;
        }
        index = 0;
        while (index < unpinnedInputURIs.length) {
            input = unpinnedInputURIs[index];
            if (input != null) {
                key = KEY_PREFIX + index;
                repository.setProperty(key, input.toString());
                String unpinedEditorHistoryItemKey = UNPINNED_KEY_HISTORY_ITEM_PREFIX + index;
                IEditorHistoryItem unpinnedItem = persistable.getEditorHistoryItem(input);
                if (unpinnedItem != null) {
                    repository.setProperty(unpinedEditorHistoryItemKey, unpinnedItem.toJson());
                }
                thumbnail = persistable.getThumbnail(input);
                thumbnailKey = THUMBNAIL_PREFIX + key;
                if (thumbnail != null) {
                    repository.setProperty(thumbnailKey, thumbnail.toString());
                }
            }
            ++index;
        }
        File file = this.getHistoryFile();
        if (file != null) {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            try {
                OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                try {
                    repository.store(out, "Generated by org.xmind.ui.internal.editor.EditorHistoryService");
                }
                finally {
                    out.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to save workbook history to " + file.getAbsolutePath());
            }
        }
        if ((oldHistoryFile = this.getOldHistoryFile()) != null && oldHistoryFile.exists()) {
            oldHistoryFile.delete();
        }
    }

    public Properties load() {
        Properties repository = new Properties();
        File file = this.getHistoryFile();
        if (file != null && file.exists()) {
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
                try {
                    repository.load(reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to load workbook history from " + file.getAbsolutePath());
            }
        } else {
            repository = this.loadOldHistoryRepository();
        }
        return repository;
    }

    private Properties loadOldHistoryRepository() {
        Properties repository = new Properties();
        File file = this.getOldHistoryFile();
        if (file != null && file.exists()) {
            try {
                FileReader reader = new FileReader(file);
                try {
                    repository.load(reader);
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException e) {
                Logger.log(e, "Failed to load workbook history from " + file.getAbsolutePath());
            }
            int count = 0;
            ArrayList<Object> items = new ArrayList<Object>();
            int size = repository.size();
            int i = 0;
            while (i < size) {
                if (count >= 100) break;
                Object key = KEY_PREFIX + i;
                String value = repository.getProperty((String)key);
                if (value != null) {
                    items.add(value);
                    repository.remove(key);
                    ++count;
                }
                ++i;
            }
            Set<Object> oldVersionKeys = repository.keySet();
            for (Object key : oldVersionKeys) {
                if (count >= 100) break;
                String string = (String)key;
                String info = repository.getProperty(string);
                items.add(String.valueOf(string) + VALUE_SEPARATOR + info);
                ++count;
            }
            repository = new Properties();
            int countForPinned = 0;
            int countForUnpinned = 0;
            for (String string : items) {
                int index = string.indexOf(VALUE_SEPARATOR);
                if (index < 0) continue;
                String input = string.substring(0, index);
                String info = string.substring(index + VALUE_SEPARATOR.length());
                if (info == null || info.isEmpty()) continue;
                String thumbnail = EditorHistoryPersistenceHelper.extractThumbnailFromOldInfo(info);
                String thumbnailKey = THUMBNAIL_PREFIX;
                boolean isPinned = EditorHistoryPersistenceHelper.isPinnedBasedOldInfo(info);
                if (isPinned) {
                    String pinnedKey = PINNED_KEY_PREFIX + countForPinned;
                    thumbnailKey = THUMBNAIL_PREFIX + pinnedKey;
                    repository.setProperty(pinnedKey, input);
                    ++countForPinned;
                } else {
                    String unpinnedKey = KEY_PREFIX + countForUnpinned;
                    thumbnailKey = THUMBNAIL_PREFIX + unpinnedKey;
                    repository.setProperty(unpinnedKey, input);
                    ++countForUnpinned;
                }
                if (thumbnail == null || thumbnail.isEmpty()) continue;
                URI thumbnailURI = new File(thumbnail).toURI();
                repository.setProperty(thumbnailKey, thumbnailURI.toString());
            }
        }
        return repository;
    }

    private static String extractThumbnailFromOldInfo(String info) {
        int sepPos;
        String thumbnail = info;
        if (info != null && (sepPos = info.indexOf(44)) > 0) {
            thumbnail = info.substring(0, sepPos);
        }
        return thumbnail;
    }

    private static boolean isPinnedBasedOldInfo(String info) {
        return info != null && info.endsWith(",favor");
    }

    private File getHistoryFile() {
        if (this.basePath == null) {
            return null;
        }
        IPath filePath = this.basePath.append(FILE_NAME);
        return filePath.toFile();
    }

    private File getOldHistoryFile() {
        if (this.basePath == null) {
            return null;
        }
        IPath filePath = this.basePath.append(OLD_FILE_NAME);
        return filePath.toFile();
    }

    private static class EditorHistoryState {
        private final URI[] unpinnedInputURIs;
        private final URI[] pinnedInputURIs;
        private final Map<URI, URI> thumbnailURIs;
        private final Map<URI, IEditorHistoryItem> editorHistoryItems;

        private EditorHistoryState(EditorHistoryImpl service) {
            IEditorHistoryItem item;
            URI thumbnailURI;
            URI uri;
            this.unpinnedInputURIs = service.getUnpinnedInputURIs(100);
            this.pinnedInputURIs = service.getPinnedInputURIs();
            this.thumbnailURIs = new HashMap<URI, URI>();
            this.editorHistoryItems = new HashMap<URI, IEditorHistoryItem>();
            URI[] uRIArray = this.pinnedInputURIs;
            int n = this.pinnedInputURIs.length;
            int n2 = 0;
            while (n2 < n) {
                uri = uRIArray[n2];
                thumbnailURI = service.getThumbnail(uri);
                if (thumbnailURI != null) {
                    this.thumbnailURIs.put(uri, thumbnailURI);
                }
                if ((item = service.getItem(uri)) != null) {
                    this.editorHistoryItems.put(uri, item);
                }
                ++n2;
            }
            uRIArray = this.unpinnedInputURIs;
            n = this.unpinnedInputURIs.length;
            n2 = 0;
            while (n2 < n) {
                uri = uRIArray[n2];
                thumbnailURI = service.getThumbnail(uri);
                if (thumbnailURI != null) {
                    this.thumbnailURIs.put(uri, thumbnailURI);
                }
                if ((item = service.getItem(uri)) != null) {
                    this.editorHistoryItems.put(uri, item);
                }
                ++n2;
            }
        }

        public static EditorHistoryState createFrom(EditorHistoryImpl service) {
            return new EditorHistoryState(service);
        }

        public URI[] getPinnedInputURIs() {
            return this.pinnedInputURIs;
        }

        public URI[] getUnpinnedInputURIs() {
            return this.unpinnedInputURIs;
        }

        public URI getThumbnail(URI input) {
            return this.thumbnailURIs.get(input);
        }

        public IEditorHistoryItem getEditorHistoryItem(URI input) {
            return this.editorHistoryItems.get(input);
        }
    }
}

