/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.editor;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.ErrorSupportProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.AbstractHyperlink;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.statushandlers.AbstractStatusAreaProvider;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.xmind.core.Core;
import org.xmind.core.CoreException;
import org.xmind.core.IAdaptable;
import org.xmind.core.IDeserializer;
import org.xmind.core.IFileEntry;
import org.xmind.core.IRevision;
import org.xmind.core.IRevisionManager;
import org.xmind.core.IRevisionRepository;
import org.xmind.core.ISerializer;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.ICoreEventSource2;
import org.xmind.core.io.DirectoryInputSource;
import org.xmind.core.io.DirectoryOutputTarget;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IOutputTarget;
import org.xmind.core.io.IStorage;
import org.xmind.core.util.CloneHandler;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.IProgressReporter;
import org.xmind.core.util.ProgressReporter;
import org.xmind.ui.blackbox.BlackBox;
import org.xmind.ui.blackbox.IBlackBoxMap;
import org.xmind.ui.internal.MindMapMessages;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.dialogs.BlackBoxDialog;
import org.xmind.ui.internal.editor.AbstractWorkbookRef;
import org.xmind.ui.internal.editor.IEncryptable;
import org.xmind.ui.internal.editor.IMindMapPreviewGenerator;
import org.xmind.ui.internal.editor.WorkbookRefEncryptable;
import org.xmind.ui.internal.protocols.FilePathParser;
import org.xmind.ui.internal.utils.CommandUtils;
import org.xmind.ui.internal.zen.ZenDeserializer;
import org.xmind.ui.mindmap.IWorkbookRef;
import org.xmind.ui.mindmap.MindMapImageExporter;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.ImageFormat;
import org.xmind.ui.util.Logger;

public class LocalFileWorkbookRef
extends AbstractWorkbookRef {
    private static boolean DEBUG_BACKUP = MindMapUIPlugin.isDebugging("/debug/save/localfile/backup");
    private final LocalFileBackup backup;
    private long timestamp;
    private final ErrorSupportProvider errorSupportProvider;

    protected LocalFileWorkbookRef(URI uri, IMemento memento) {
        super(uri, memento);
        Assert.isNotNull((Object)uri);
        Assert.isLegal((boolean)"file".equals(uri.getScheme()), (String)("Invalid file URI: " + uri.toString()));
        this.backup = new LocalFileBackup(new File(uri));
        this.errorSupportProvider = new LocalFileErrorSupportProvider();
    }

    @Override
    public <T> T getAdapter(Class<T> adapter) {
        if (ErrorSupportProvider.class.equals(adapter)) {
            return adapter.cast(this.errorSupportProvider);
        }
        return super.getAdapter(adapter);
    }

    @Override
    public String getSaveWizardId() {
        return "org.xmind.ui.saveWizards.localFile";
    }

    private File getFile() {
        return new File(this.getURI());
    }

    public String getName() {
        String name = this.getFile().getName();
        if (name != null) {
            int dotIndex = name.lastIndexOf(46);
            if (dotIndex < 0) {
                return name;
            }
            return name.substring(0, dotIndex);
        }
        return super.getName();
    }

    public String getDescription() {
        return this.getFile().getAbsolutePath();
    }

    public int hashCode() {
        return this.getFile().hashCode();
    }

    public boolean equals(Object obj) {
        File thatFile;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof LocalFileWorkbookRef)) {
            return false;
        }
        LocalFileWorkbookRef that = (LocalFileWorkbookRef)obj;
        File thisFile = this.getFile();
        return thisFile == (thatFile = that.getFile()) || thisFile != null && thisFile.equals(thatFile);
    }

    public String toString() {
        return this.getFile().toString();
    }

    public boolean canSave() {
        return true;
    }

    @Override
    public boolean canImportFrom(IWorkbookRef source) {
        return true;
    }

    public long getModificationTime() {
        return this.getFile().lastModified();
    }

    @Override
    protected IWorkbook doLoadWorkbookFromURI(IProgressMonitor monitor, URI uri) throws InterruptedException, InvocationTargetException {
        File file = new File(uri);
        IStorage storage = this.getTempStorage();
        if (this.isJsonFormat(file, storage)) {
            return this.doLoadWorkbookFromJson(monitor, storage);
        }
        return this.doLoadWorkbookFromXml(monitor, storage);
    }

    private boolean isJsonFormat(File file, IStorage storage) throws InvocationTargetException {
        boolean bl;
        block8: {
            PreParser parser = new PreParser();
            parser.setWorkbookStorage(storage);
            InputStream stream = null;
            try {
                if (file.isDirectory()) {
                    parser.setInputSource((IInputSource)new DirectoryInputSource(file));
                } else {
                    stream = new FileInputStream(file);
                    parser.setInputStream(stream);
                }
                bl = parser.isJsonFormat();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        stream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new InvocationTargetException(e);
                }
            }
            stream.close();
        }
        return bl;
    }

    private IWorkbook doLoadWorkbookFromJson(IProgressMonitor monitor, IStorage storage) throws InvocationTargetException, InterruptedException {
        try {
            ZenDeserializer deserializer = new ZenDeserializer(storage);
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.setWorkbookStorageAsInputSource();
            ProgressReporter reporter = new ProgressReporter(monitor);
            deserializer.deserializeManifest((IProgressReporter)reporter);
            String passwordHint = deserializer.getManifest().getPasswordHint();
            this.getEncryptable().setPasswordHint(passwordHint);
            deserializer.deserialize((IProgressReporter)reporter);
            return deserializer.getWorkbook();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            if (e.getType() == 100) {
                throw new InterruptedException();
            }
            if (e.getType() == 17 && this.getEncryptable() != null) {
                this.getEncryptable().reset();
            }
            throw new InvocationTargetException(e);
        }
    }

    private IWorkbook doLoadWorkbookFromXml(IProgressMonitor monitor, IStorage storage) throws InvocationTargetException, InterruptedException {
        try {
            IDeserializer deserializer = Core.getWorkbookBuilder().newDeserializer();
            deserializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            deserializer.setWorkbookStorage(storage);
            deserializer.setWorkbookStorageAsInputSource();
            ProgressReporter reporter = new ProgressReporter(monitor);
            deserializer.deserializeManifest((IProgressReporter)reporter);
            String passwordHint = deserializer.getManifest().getPasswordHint();
            this.getEncryptable().setPasswordHint(passwordHint);
            deserializer.deserialize((IProgressReporter)reporter);
            return deserializer.getWorkbook();
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            if (e.getType() == 100) {
                throw new InterruptedException();
            }
            if (e.getType() == 17 && this.getEncryptable() != null) {
                this.getEncryptable().reset();
            }
            throw new InvocationTargetException(e);
        }
    }

    @Override
    protected void doSaveWorkbookToURI(IProgressMonitor monitor, IWorkbook workbook, URI uri) throws InterruptedException, InvocationTargetException {
        this.doSaveWorkbookToURIFromSource(monitor, workbook, uri, null, null);
    }

    protected void doSaveWorkbookToURIFromSource(IProgressMonitor monitor, IWorkbook workbook, URI uri, IWorkbookRef source, IWorkbook sourceWorkbook) throws InterruptedException, InvocationTargetException {
        IEncryptable encryptable;
        boolean previewSaved;
        HashSet<String> encryptionIgnoredEntries;
        block38: {
            this.appendLog("[save] doSaveWorkbookToURIFromSource start...");
            encryptionIgnoredEntries = new HashSet<String>();
            previewSaved = false;
            if (source != null) {
                try {
                    InputStream previewData = source.getPreviewImageData(sourceWorkbook.getPrimarySheet().getId(), null);
                    if (previewData == null) break block38;
                    try {
                        IFileEntry previewEntry = workbook.getManifest().createFileEntry(MindMapImageExporter.toThumbnailArchivePath(ImageFormat.PNG));
                        previewEntry.decreaseReference();
                        previewEntry.increaseReference();
                        OutputStream output = previewEntry.openOutputStream();
                        try {
                            FileUtils.transfer((InputStream)previewData, (OutputStream)output, (boolean)false);
                        }
                        finally {
                            output.close();
                        }
                        encryptionIgnoredEntries.add(previewEntry.getPath());
                    }
                    finally {
                        previewData.close();
                    }
                    previewSaved = true;
                }
                catch (IOException e) {
                    Logger.log(e, "Failed to import preview image");
                    this.appendLog("[save] failed to import preview image...");
                }
            }
        }
        if (!previewSaved) {
            try {
                this.savePreviewImage(workbook, encryptionIgnoredEntries);
            }
            catch (InvocationTargetException e) {
                Logger.log(e, "Failed to save preview image");
                this.appendLog("[save] failed to save preview image...");
            }
        }
        try {
            this.saveRevisions(workbook);
        }
        catch (CoreException e) {
            Logger.log(e, "Failed to save revisions");
            this.appendLog("[save] failed to save revisions...");
        }
        this.appendLog("[save] new file...");
        File file = new File(uri);
        this.appendLog("[save] serialize start...");
        ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
        serializer.setWorkbook(workbook);
        serializer.setEntryStreamNormalizer(this.getEncryptionHandler());
        serializer.setEncryptionIgnoredEntries(encryptionIgnoredEntries.toArray(new String[encryptionIgnoredEntries.size()]));
        String passwordHint = this.getEncryptable().getPasswordHint();
        if (passwordHint == null && source != null && (encryptable = (IEncryptable)source.getAdapter(IEncryptable.class)) != null) {
            passwordHint = encryptable.getPasswordHint();
        }
        if (passwordHint != null) {
            workbook.getManifest().setPasswordHint(passwordHint);
        }
        OutputStream stream = null;
        boolean deleteTarget = false;
        long oldLastModified = file.lastModified();
        try {
            try {
                if (file.isDirectory()) {
                    this.backup.deleteBackup();
                    this.appendLog("[save] setOutputTarget...");
                    serializer.setOutputTarget((IOutputTarget)new DirectoryOutputTarget(file));
                } else {
                    this.backup.makeBackup();
                    this.appendLog("[save] new FileOutputStream...");
                    stream = new FileOutputStream(file);
                    this.appendLog("[save] setOutputStream...");
                    serializer.setOutputStream(stream);
                }
                serializer.serialize((IProgressReporter)new ProgressReporter(monitor));
                this.appendLog("[save] serialize success...");
                this.backup.deleteBackup();
                this.appendLog("[save] doSaveWorkbookToURIFromSource over...");
            }
            catch (FileNotFoundException e) {
                this.appendLog("[save] FileNotFoundException...");
                this.backup.restoreBackup();
                deleteTarget = true;
                this.promptDialog(MindMapMessages.LocalFileWorkbookRef_saveFailed_title, MindMapMessages.LocalFileWorkbookRef_saveFailed_description);
                throw new InvocationTargetException(e);
            }
            catch (SecurityException e) {
                this.appendLog("[save] SecurityException...");
                this.backup.restoreBackup();
                deleteTarget = true;
                this.promptDialog(MindMapMessages.LocalFileWorkbookRef_saveFailed_title, MindMapMessages.LocalFileWorkbookRef_saveFailed_description);
                throw new InvocationTargetException(e);
            }
            catch (IOException e) {
                this.appendLog("[save] IOException...");
                this.backup.restoreBackup();
                deleteTarget = true;
                this.promptDialog(MindMapMessages.LocalFileWorkbookRef_saveFailed_title, MindMapMessages.LocalFileWorkbookRef_saveFailed_description2);
                throw new InvocationTargetException(e);
            }
            catch (CoreException e) {
                this.appendLog("[save] CoreException...");
                this.backup.restoreBackup();
                deleteTarget = true;
                if (e.getType() == 100) {
                    Logger.log(e, "Canceled to save file");
                    throw new InterruptedException();
                }
                if (e.getType() == 17) {
                    if (this.getEncryptable() != null) {
                        this.getEncryptable().reset();
                    }
                } else {
                    this.promptDialog(MindMapMessages.LocalFileWorkbookRef_saveFailed_title, MindMapMessages.LocalFileWorkbookRef_saveFailed_description2);
                }
                throw new InvocationTargetException(e);
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Logger.log(e, "Failed to close stream after save file");
                }
            }
            if (deleteTarget) {
                deleteTarget = false;
                if (source == null) {
                    file.setLastModified(oldLastModified);
                } else {
                    file.delete();
                }
            }
        }
    }

    private void savePreviewImage(IWorkbook workbook, Set<String> encryptionIgnoredEntries) throws InvocationTargetException {
        IMindMapPreviewGenerator previewGenerator = this.findPreviewGenerator();
        if (previewGenerator != null) {
            Properties previewProperties;
            ImageFormat previewFormat = ImageFormat.PNG;
            IFileEntry entry = workbook.getManifest().createFileEntry(MindMapImageExporter.toThumbnailArchivePath(previewFormat), previewFormat.getMediaType());
            entry.decreaseReference();
            entry.increaseReference();
            try {
                OutputStream previewOutput = entry.openOutputStream();
                try {
                    previewProperties = previewGenerator.generateMindMapPreview(this, workbook.getPrimarySheet(), previewOutput, null);
                }
                finally {
                    previewOutput.close();
                }
            }
            catch (IOException e) {
                throw new InvocationTargetException(e);
            }
            workbook.getMeta().setValue("Thumbnail/Origin/X", previewProperties.getProperty("Thumbnail/Origin/X"));
            workbook.getMeta().setValue("Thumbnail/Origin/Y", previewProperties.getProperty("Thumbnail/Origin/Y"));
            workbook.getMeta().setValue("Thumbnail/BackgroundColor", previewProperties.getProperty("Thumbnail/BackgroundColor"));
            encryptionIgnoredEntries.add(entry.getPath());
        }
    }

    private void saveRevisions(IWorkbook workbook) throws CoreException {
        if (!this.isContentDirty(workbook) || !this.shouldSaveNewRevisions(workbook)) {
            return;
        }
        IRevisionRepository repo = workbook.getRevisionRepository();
        for (ISheet sheet : workbook.getSheets()) {
            IRevisionManager manager = repo.getRevisionManager(sheet.getId(), "application/vnd.xmind.sheet");
            IRevision latestRevision = manager.getLatestRevision();
            if (latestRevision != null && sheet.getModifiedTime() != 0L && sheet.getModifiedTime() <= latestRevision.getTimestamp()) continue;
            try {
                manager.addRevision((IAdaptable)sheet);
            }
            catch (Throwable throwable) {
                throw new CoreException(3, "Invalid content for revisions.");
            }
        }
    }

    private boolean isContentDirty(IWorkbook workbook) {
        if (workbook == null) {
            return false;
        }
        if (this.getCommandStack() != null && this.getCommandStack().isDirty()) {
            return true;
        }
        return workbook instanceof ICoreEventSource2 && ((ICoreEventSource2)workbook).hasOnceListeners("workbookPreSaveOnce");
    }

    private boolean shouldSaveNewRevisions(IWorkbook workbook) {
        String value = workbook.getMeta().getValue("Configurations/AutoRevisionGeneration");
        return value == null || "Yes".equalsIgnoreCase(value);
    }

    private void promptDialog(final String title, final String message) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openWarning((Shell)Display.getDefault().getActiveShell(), (String)title, (String)message);
            }
        });
    }

    @Override
    protected void doImportFrom(IProgressMonitor monitor, IWorkbookRef source) throws InterruptedException, InvocationTargetException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkbook sourceWorkbook = source.getWorkbook();
        Assert.isTrue((sourceWorkbook != null ? 1 : 0) != 0);
        URI targetURI = this.getURI();
        Assert.isTrue((targetURI != null ? 1 : 0) != 0);
        IStorage storage = this.getTempStorage();
        IEncryptable sourceEncryptable = (IEncryptable)source.getAdapter(IEncryptable.class);
        if (sourceEncryptable != null && sourceEncryptable.hasPassword() && sourceEncryptable instanceof WorkbookRefEncryptable) {
            this.getEncryptable().setPassword(sourceEncryptable.getPassword());
            this.getEncryptable().setPasswordHint(sourceEncryptable.getPasswordHint());
        }
        this.doClearTempStorageBeforeImport((IProgressMonitor)subMonitor.newChild(5), storage);
        try {
            IWorkbook workbook = this.doCloneWorkbookForImport((IProgressMonitor)subMonitor.newChild(40), sourceWorkbook, source.getURI(), storage);
            this.doSaveWorkbookToURIFromSource((IProgressMonitor)subMonitor.newChild(50), workbook, targetURI, source, sourceWorkbook);
        }
        finally {
            subMonitor.setWorkRemaining(5);
            this.doClearTempStorageAfterImport((IProgressMonitor)subMonitor.newChild(5), storage);
        }
    }

    protected void doClearTempStorageBeforeImport(IProgressMonitor monitor, IStorage storage) throws InterruptedException, InvocationTargetException {
        storage.clear();
    }

    protected void doClearTempStorageAfterImport(IProgressMonitor monitor, IStorage storage) {
        storage.clear();
    }

    protected IWorkbook doCloneWorkbookForImport(IProgressMonitor monitor, IWorkbook sourceWorkbook, URI sourceURI, IStorage storage) throws InterruptedException, InvocationTargetException {
        try {
            IWorkbook workbook = Core.getWorkbookBuilder().createWorkbook(storage);
            ISerializer serializer = Core.getWorkbookBuilder().newSerializer();
            serializer.setWorkbook(workbook);
            serializer.setWorkbookStorageAsOutputTarget();
            serializer.setEntryStreamNormalizer(this.getEncryptionHandler());
            serializer.serialize(null);
            new CloneHandler().withWorkbooks(sourceWorkbook, workbook).copyWorkbookContents();
            String oldFilePath = sourceURI != null && "file".equals(sourceURI.getScheme()) ? new File(sourceURI).getAbsolutePath() : null;
            this.updateAllRelativeFileHyperlinks(workbook, oldFilePath, this.getFile().getAbsolutePath());
            return workbook;
        }
        catch (IOException e) {
            throw new InvocationTargetException(e);
        }
        catch (CoreException e) {
            if (e.getType() == 100) {
                throw new InterruptedException();
            }
            throw new InvocationTargetException(e);
        }
    }

    private void updateAllRelativeFileHyperlinks(IWorkbook workbook, String oldFilePath, String newFilePath) {
        String newBase;
        String oldBase = oldFilePath == null ? FilePathParser.ABSTRACT_FILE_BASE : new File(oldFilePath).getParent();
        if (oldBase.equals(newBase = new File(newFilePath).getParent())) {
            return;
        }
        List sheets = workbook.getSheets();
        for (ISheet sheet : sheets) {
            this.updateRelativeFileHyperlinks(sheet.getRootTopic(), oldBase, newBase);
        }
    }

    private void updateRelativeFileHyperlinks(ITopic topic, String oldBase, String newBase) {
        List topics;
        String path;
        String hyperlink = topic.getHyperlink();
        if (FilePathParser.isFileURI(hyperlink) && FilePathParser.isPathRelative(path = FilePathParser.toPath(hyperlink))) {
            String absolutePath = FilePathParser.toAbsolutePath(oldBase, path);
            hyperlink = FilePathParser.toRelativePath(newBase, absolutePath);
            topic.setHyperlink(FilePathParser.toURI(hyperlink, true));
        }
        if ((topics = topic.getAllChildren()) != null) {
            for (ITopic temptopic : topics) {
                this.updateRelativeFileHyperlinks(temptopic, oldBase, newBase);
            }
        }
    }

    @Override
    public boolean activateNotifier() {
        File file = this.getFile();
        if (!file.exists()) {
            this.fileRemoved(MindMapMessages.LocalFileWorkbookRef_removeDialog_title, MindMapMessages.LocalFileWorkbookRef_removeDialog_message, new String[]{MindMapMessages.LocalFileWorkbookRef_removeDialog_saveAs_button, MindMapMessages.LocalFileWorkbookRef_removeDialog_delete_button}, false);
            return true;
        }
        if (file.lastModified() != this.timestamp) {
            this.fileChanged(MindMapMessages.LocalFileWorkbookRef_changeDialog_title, MindMapMessages.LocalFileWorkbookRef_changeDialog_message, new String[]{MindMapMessages.LocalFileWorkbookRef_changeDialog_update_button, MindMapMessages.LocalFileWorkbookRef_changeDialog_cancel_button});
            return true;
        }
        return false;
    }

    public void open(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        this.timestamp = this.getFile().lastModified();
        super.open(monitor);
    }

    public void save(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
        super.save(monitor);
        this.timestamp = this.getFile().lastModified();
    }

    public boolean exists() {
        return this.getFile().exists();
    }

    protected void log(Throwable e, String message) {
        Logger.log(e, message);
    }

    private static class LocalFileBackup {
        private final File file;
        private final File tempFile;

        public LocalFileBackup(File file) {
            this.file = file;
            this.tempFile = new File(Core.getWorkspace().getTempFile("saving/" + UUID.randomUUID() + ".xmind"));
        }

        public void makeBackup() {
            if (!this.file.exists() || !this.file.canRead()) {
                this.tempFile.delete();
                return;
            }
            if (DEBUG_BACKUP) {
                System.out.println("Making local file backup for: " + this.file.getAbsolutePath());
                System.out.println("    to: " + this.tempFile.getAbsolutePath());
            }
            try {
                FileUtils.transfer((File)this.file, (File)this.tempFile);
            }
            catch (IOException e) {
                MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to make backup of local file: " + this.file.getAbsolutePath(), (Throwable)e));
            }
        }

        public void restoreBackup() {
            if (!this.tempFile.exists() || !this.tempFile.canRead()) {
                return;
            }
            if (DEBUG_BACKUP) {
                System.out.println("Restoring local file backup for: " + this.file.getAbsolutePath());
                System.out.println("    from: " + this.tempFile.getAbsolutePath());
            }
            try {
                FileUtils.transfer((File)this.tempFile, (File)this.file);
            }
            catch (IOException e) {
                MindMapUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.xmind.ui.mindmap", "Failed to restore backup of local file: " + this.file.getAbsolutePath(), (Throwable)e));
            }
        }

        public void deleteBackup() {
            if (DEBUG_BACKUP) {
                System.out.println("Deleting local file backup for: " + this.file.getAbsolutePath());
                System.out.println("    at: " + this.tempFile.getAbsolutePath());
            }
            this.tempFile.delete();
        }
    }

    private class LocalFileErrorSupportProvider
    extends AbstractStatusAreaProvider {
        private LocalFileErrorSupportProvider() {
        }

        public Control createSupportArea(Composite parent, StatusAdapter statusAdapter) {
            IBlackBoxMap[] blackBoxMaps = BlackBox.getMaps();
            if (!MindMapUIPlugin.getDefault().getPreferenceStore().getBoolean("autoBackupEnable") || blackBoxMaps == null || blackBoxMaps.length == 0) {
                return null;
            }
            Composite hyperParent = new Composite(parent, 0);
            GridLayout layout = new GridLayout(2, false);
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            hyperParent.setLayout((Layout)layout);
            hyperParent.setBackground(parent.getBackground());
            Label preLink = new Label(hyperParent, 0);
            preLink.setText(MindMapMessages.LoadWorkbookJob_errorDialog_Pre_message);
            preLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
            preLink.setBackground(parent.getBackground());
            Hyperlink hyperlink = new Hyperlink(hyperParent, 0);
            hyperlink.setBackground(parent.getBackground());
            hyperlink.setUnderlined(true);
            hyperlink.setText(MindMapMessages.LoadWorkbookJob_errorDialog_GoToBackup_message);
            hyperlink.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
            hyperlink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    LocalFileErrorSupportProvider.this.showBlackBoxView();
                }
            });
            hyperlink.setFont(FontUtils.getBoldRelative((String)"org.eclipse.jface.defaultfont", (int)0));
            try {
                Field fPaintFocus = AbstractHyperlink.class.getDeclaredField("paintFocus");
                fPaintFocus.setAccessible(true);
                fPaintFocus.set(hyperlink, false);
            }
            catch (Throwable throwable) {}
            return hyperParent;
        }

        private void showBlackBoxView() {
            IWorkbenchPage page;
            IWorkbenchWindow window;
            final File damagedFile = LocalFileWorkbookRef.this.getFile();
            if (PlatformUI.isWorkbenchRunning() && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        CommandUtils.executeCommand("org.xmind.ui.dialog.openBlackBoxDialog", window);
                        Object data = Display.getCurrent().getActiveShell().getData("blackBoxDialog");
                        if (data instanceof BlackBoxDialog) {
                            BlackBoxDialog dialog = (BlackBoxDialog)((Object)data);
                            dialog.setDamagedFile(damagedFile);
                        }
                    }
                });
            }
        }
    }

    private static class PreParser {
        private IInputSource inputSource;
        private InputStream inputStream;
        private IStorage storage;

        public void setInputSource(IInputSource source) {
            if (source == null) {
                throw new IllegalArgumentException("input source is null");
            }
            this.inputSource = source;
            this.inputStream = null;
        }

        public void setInputStream(InputStream stream) {
            if (stream == null) {
                throw new IllegalArgumentException("input stream is null");
            }
            this.inputStream = stream;
            this.inputSource = null;
        }

        public void setWorkbookStorage(IStorage storage) {
            if (storage == null) {
                throw new IllegalArgumentException("storage is null");
            }
            this.storage = storage;
        }

        public boolean isJsonFormat() {
            IInputSource source;
            block7: {
                try {
                    if (this.inputStream != null) {
                        ZipInputStream zin = new ZipInputStream(this.inputStream);
                        try {
                            FileUtils.extractZipFile((ZipInputStream)zin, (IOutputTarget)this.storage.getOutputTarget());
                            break block7;
                        }
                        finally {
                            zin.close();
                        }
                    }
                    if (this.inputSource != null) {
                        FileUtils.transfer((IInputSource)this.inputSource, (IOutputTarget)this.storage.getOutputTarget());
                    }
                }
                catch (IOException iOException) {
                    return false;
                }
            }
            return this.storage != null && (source = this.storage.getInputSource()) != null && source.hasEntry("content.json") && source.isEntryAvailable("content.json");
        }
    }
}

