/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.layers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.xmind.gef.draw2d.IRelayerableFigure;
import org.xmind.gef.draw2d.IRelayeredPane;
import org.xmind.ui.internal.layers.BaseLayer;

public class CoverLayer
extends BaseLayer
implements IRelayeredPane,
FigureListener {
    private List<IFigure> backgroundLayers = null;
    private List<IRelayerableFigure> highlights = null;

    public CoverLayer() {
        this.setMainAlpha(128);
    }

    public void addRelayerableFigure(IRelayerableFigure figure) {
        if (figure == null) {
            return;
        }
        if (this.highlights == null) {
            this.highlights = new ArrayList<IRelayerableFigure>();
        }
        this.highlights.add(figure);
        figure.setRelayered(true);
        figure.addFigureListener((FigureListener)this);
        this.repaint();
    }

    public void removeRelayerableFigure(IRelayerableFigure figure) {
        if (figure == null) {
            return;
        }
        if (this.highlights == null) {
            return;
        }
        this.highlights.remove(figure);
        figure.setRelayered(false);
        figure.removeFigureListener((FigureListener)this);
        this.repaint();
    }

    public List<IRelayerableFigure> getRelayerableFigures() {
        return this.highlights;
    }

    public void addBackgroundLayer(IFigure layer) {
        if (layer == null) {
            return;
        }
        if (this.backgroundLayers == null) {
            this.backgroundLayers = new ArrayList<IFigure>();
        }
        this.backgroundLayers.add(layer);
        this.repaint();
    }

    public void removeBackgroundLayer(IFigure layer) {
        if (layer == null) {
            return;
        }
        if (this.backgroundLayers != null) {
            this.backgroundLayers.remove(layer);
            this.repaint();
        }
    }

    @Override
    public void paint(Graphics graphics) {
        this.simplePaint(graphics);
    }

    protected void paintFigure(Graphics graphics) {
        super.paintFigure(graphics);
        if (this.highlights != null && !this.highlights.isEmpty()) {
            this.paintCover(graphics);
        }
    }

    protected void paintCover(Graphics graphics) {
        graphics.setAlpha(this.getMainAlpha());
        graphics.setBackgroundColor(this.getCoverColor());
        graphics.fillRectangle(this.getBounds());
    }

    protected Color getCoverColor() {
        Color color = this.getLocalBackgroundColor();
        if (color == null) {
            color = ColorConstants.black;
        }
        return color;
    }

    @Override
    protected void paintClientArea(Graphics graphics) {
        if (this.usesSubAlphaGraphics()) {
            Graphics ag = this.createAlphaGraphics(graphics, this.getSubAlpha());
            this.paintChildren(ag);
            ag.dispose();
        } else {
            graphics.setAlpha(this.getSubAlpha());
            this.paintChildren(graphics);
        }
    }

    protected void paintChildren(Graphics graphics) {
        super.paintChildren(graphics);
        if (this.highlights != null) {
            Rectangle clip = Rectangle.SINGLETON;
            int i = 0;
            while (i < this.highlights.size()) {
                IRelayerableFigure child = this.highlights.get(i);
                if (child.isVisible() && child.intersects(graphics.getClip(clip))) {
                    this.paintHighlight(graphics, child);
                }
                ++i;
            }
        }
    }

    private void paintHighlight(Graphics graphics, IRelayerableFigure figure) {
        this.paintBackgroundLayers(graphics, figure);
        graphics.clipRect(figure.getBounds());
        figure.paintRelayered(graphics);
        graphics.restoreState();
    }

    private void paintBackgroundLayers(Graphics graphics, IRelayerableFigure figure) {
        if (this.backgroundLayers == null || this.backgroundLayers.isEmpty()) {
            return;
        }
        for (IFigure layer : this.backgroundLayers) {
            graphics.clipRect(figure.getBounds());
            layer.paint(graphics);
            graphics.restoreState();
        }
    }

    public void figureMoved(IFigure source) {
        this.repaint();
    }
}

