/*
 * Decompiled with CFR 0.152.
 */
package net.xmind.signin.internal;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.service.datalocation.Location;

public class UpdateData {
    private static final String VERSION_TYPE = "Version";
    private static final String DOWNLOAD_URL_TYPE = "DownloadURL";
    private static final String ALL_DOWNLOADS_TYPE = "AllDownloadsURL";
    private static final String SIZE_TYPE = "Size";
    private static final String WHATS_NEW_TYPE = "WhatsNew";
    private static final String CAN_INSTALL_TYPE = "CanInstall";
    private static final String INSTALLER_PATH = "InstallerPath";
    private static final String BUILD_ID_TYPE = "BuildId";
    private Properties data;

    private UpdateData(Properties data) {
        this.data = data;
    }

    private String getValue(String name) {
        return this.data.getProperty(name);
    }

    private long parseLong(String value, long defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value, 10);
        }
        catch (NumberFormatException numberFormatException) {
            return defaultValue;
        }
    }

    private boolean parseBoolean(String value, boolean defaultValue) {
        if (value == null) {
            return defaultValue;
        }
        if ("yes".equalsIgnoreCase(value) || "true".equalsIgnoreCase(value)) {
            return true;
        }
        if ("no".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) {
            return false;
        }
        return defaultValue;
    }

    private void setValue(String name, String value) {
        if (value == null) {
            this.data.remove(name);
        } else {
            this.data.setProperty(name, value);
        }
    }

    public String getDownloadURL() {
        return this.getValue(DOWNLOAD_URL_TYPE);
    }

    public String getAllDownloadsURL() {
        return this.getValue(ALL_DOWNLOADS_TYPE);
    }

    public String getVersion() {
        return this.getValue(VERSION_TYPE);
    }

    public String getBuildId() {
        return this.getValue(BUILD_ID_TYPE);
    }

    public long getSize() {
        return this.parseLong(this.getValue(SIZE_TYPE), 0L);
    }

    public String getWhatsNew() {
        return this.getValue(WHATS_NEW_TYPE);
    }

    public boolean canInstall() {
        return this.parseBoolean(this.getValue(CAN_INSTALL_TYPE), false);
    }

    public File getInstallerFile() {
        String path = this.getValue(INSTALLER_PATH);
        if (path == null) {
            return null;
        }
        return new File(path);
    }

    public void setDownloadURL(String downloadURL) {
        this.setValue(DOWNLOAD_URL_TYPE, downloadURL);
    }

    public void setAllDownloadsURL(String allDownloadsURL) {
        this.setValue(ALL_DOWNLOADS_TYPE, allDownloadsURL);
    }

    public void setVersion(String version) {
        this.setValue(VERSION_TYPE, version);
    }

    public void setBuildId(String buildId) {
        this.setValue(BUILD_ID_TYPE, buildId);
    }

    public void setSize(long size) {
        this.setValue(SIZE_TYPE, Long.toString(size));
    }

    public void setWhatsNew(String whatsNew) {
        this.setValue(WHATS_NEW_TYPE, whatsNew);
    }

    public void setCanInstall(boolean canInstall) {
        this.setValue(CAN_INSTALL_TYPE, Boolean.toString(canInstall));
    }

    public void setInstallerFile(File installerFile) {
        String path = installerFile == null ? null : installerFile.getAbsolutePath();
        this.setValue(INSTALLER_PATH, path);
    }

    public boolean save() {
        File file = UpdateData.getUpdateDataFile();
        File dir = file.getParentFile();
        if (!dir.isDirectory()) {
            dir.mkdirs();
        }
        if (!dir.isDirectory()) {
            return false;
        }
        FileOutputStream stream = new FileOutputStream(file);
        try {
            this.data.store(stream, "Generated by XMind about software updates.");
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            catch (IOException iOException) {
                return false;
            }
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        return true;
    }

    public static UpdateData createNewData() {
        return new UpdateData(new Properties());
    }

    public static UpdateData loadData() {
        File file = UpdateData.getUpdateDataFile();
        return UpdateData.loadDataFromFile(file);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static UpdateData loadDataFromFile(File file) {
        if (!file.exists()) return null;
        if (!file.canRead()) return null;
        try {
            UpdateData updateData;
            BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file), 1024);
            try {
                Properties properties = new Properties();
                properties.load(stream);
                updateData = new UpdateData(properties);
            }
            catch (Throwable throwable) {
                try {
                    ((InputStream)stream).close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                ((InputStream)stream).close();
                return updateData;
            }
            catch (IOException iOException) {}
            return updateData;
        }
        catch (IOException iOException) {}
        return null;
    }

    public static void clear() {
        File installerFile;
        File file = UpdateData.getUpdateDataFile();
        UpdateData data = UpdateData.loadDataFromFile(file);
        if (data != null && (installerFile = data.getInstallerFile()) != null) {
            installerFile.delete();
        }
        file.delete();
    }

    private static File getUpdateDataFile() {
        File dir = UpdateData.getUpdateFolder();
        return new File(dir, "update.properties");
    }

    public static File getUpdateFolder() {
        String instancePath = UpdateData.getInstancePath();
        if (instancePath == null) {
            return new File(System.getProperty("java.io.tmpdir"), "XMindUpdate");
        }
        return new File(instancePath, "SoftwareUpdate");
    }

    private static String getInstancePath() {
        Location instanceLoc = Platform.getInstanceLocation();
        if (instanceLoc != null) {
            URL url = instanceLoc.getURL();
            try {
                url = FileLocator.toFileURL((URL)url);
            }
            catch (IOException iOException) {}
            String file = url.getFile();
            if (file != null && !"".equals(file)) {
                return file;
            }
            return url.toExternalForm();
        }
        return null;
    }
}

