/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl;

import com.intellij.lang.ASTFactory;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.TokenType;
import com.intellij.psi.impl.GeneratedMarkerVisitor;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class PsiParserFacadeImpl
implements PsiParserFacade {
    private final PsiManagerEx myManager;

    public PsiParserFacadeImpl(@NotNull Project project) {
        if (project == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(0);
        }
        this.myManager = PsiManagerEx.getInstanceEx(project);
    }

    @Override
    @NotNull
    public PsiElement createWhiteSpaceFromText(@NotNull @NonNls String text) throws IncorrectOperationException {
        if (text == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(1);
        }
        FileElement holderElement = DummyHolderFactory.createHolder(this.myManager, null).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(TokenType.WHITE_SPACE, holderElement.getCharTable().intern(text));
        holderElement.rawAddChildren(newElement);
        GeneratedMarkerVisitor.markGenerated(newElement.getPsi());
        PsiElement psiElement = newElement.getPsi();
        if (psiElement == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(2);
        }
        return psiElement;
    }

    @Override
    @NotNull
    public PsiComment createLineCommentFromText(@NotNull LanguageFileType fileType, @NotNull String text) throws IncorrectOperationException {
        if (fileType == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(3);
        }
        if (text == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(4);
        }
        PsiComment psiComment = this.createLineCommentFromText(fileType.getLanguage(), text);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(5);
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createLineCommentFromText(@NotNull Language language2, @NotNull String text) throws IncorrectOperationException {
        if (language2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(6);
        }
        if (text == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(7);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language2);
        assert (commenter != null);
        String prefix = commenter.getLineCommentPrefix();
        if (prefix == null) {
            throw new IncorrectOperationException("No line comment prefix defined for language " + language2.getID());
        }
        PsiFile aFile = this.createDummyFile(language2, prefix + text);
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(8);
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createBlockCommentFromText(@NotNull Language language2, @NotNull String text) throws IncorrectOperationException {
        if (language2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(9);
        }
        if (text == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(10);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language2);
        assert (commenter != null) : language2;
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = this.createDummyFile(language2, blockCommentPrefix + text + blockCommentSuffix);
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(11);
        }
        return psiComment;
    }

    @Override
    @NotNull
    public PsiComment createLineOrBlockCommentFromText(@NotNull Language language2, @NotNull String text) throws IncorrectOperationException {
        if (language2 == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(12);
        }
        if (text == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(13);
        }
        Commenter commenter = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language2);
        assert (commenter != null) : language2;
        String prefix = commenter.getLineCommentPrefix();
        String blockCommentPrefix = commenter.getBlockCommentPrefix();
        String blockCommentSuffix = commenter.getBlockCommentSuffix();
        assert (prefix != null || blockCommentPrefix != null && blockCommentSuffix != null);
        PsiFile aFile = this.createDummyFile(language2, prefix != null ? prefix + text : blockCommentPrefix + text + blockCommentSuffix);
        PsiComment psiComment = this.findPsiCommentChild(aFile);
        if (psiComment == null) {
            PsiParserFacadeImpl.$$$reportNull$$$0(14);
        }
        return psiComment;
    }

    private PsiComment findPsiCommentChild(PsiFile aFile) {
        PsiComment comment = PsiTreeUtil.findChildOfType(aFile, PsiComment.class);
        if (comment == null) {
            throw new IncorrectOperationException("Incorrect comment \"" + aFile.getText() + "\".");
        }
        DummyHolderFactory.createHolder((PsiManager)this.myManager, (TreeElement)SourceTreeToPsiMap.psiElementToTree(comment), null);
        return comment;
    }

    private PsiFile createDummyFile(Language language2, String text) {
        return PsiFileFactory.getInstance(this.myManager.getProject()).createFileFromText("_Dummy_", language2, (CharSequence)text);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/PsiParserFacadeImpl";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 6: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/PsiParserFacadeImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createWhiteSpaceFromText";
                break;
            }
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineCommentFromText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createBlockCommentFromText";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "createLineOrBlockCommentFromText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createWhiteSpaceFromText";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLineCommentFromText";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createBlockCommentFromText";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createLineOrBlockCommentFromText";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 11: 
            case 14: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

