/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.dfa;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorProperty;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.declarations.impl.FirDefaultPropertyAccessor;
import org.jetbrains.kotlin.fir.resolve.dfa.DataFlowVariable;
import org.jetbrains.kotlin.fir.resolve.dfa.DfaVariablesKt;
import org.jetbrains.kotlin.fir.resolve.dfa.Flow;
import org.jetbrains.kotlin.fir.resolve.dfa.Identifier;
import org.jetbrains.kotlin.fir.resolve.dfa.PropertyStability;
import org.jetbrains.kotlin.fir.resolve.dfa.TypeStatement;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.types.SmartcastStability;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u0018\u001a\u00020\u00072\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0096\u0002J\b\u0010 \u001a\u00020\nH\u0016J\u0016\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&J\u0018\u0010'\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0011R\u0013\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00000\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001b\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001c\u0010\u001dR\u001b\u0010(\u001a\u00020)8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b,\u0010\u001f\u001a\u0004\b*\u0010+\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/dfa/RealVariable;", "Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "identifier", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Identifier;", "originalType", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "isThisReference", "", "explicitReceiverVariable", "variableIndexForDebug", "", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/dfa/Identifier;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;ZLorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;I)V", "getIdentifier", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/Identifier;", "getOriginalType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "()Z", "getExplicitReceiverVariable", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/DataFlowVariable;", "dependentVariables", "", "getDependentVariables", "()Ljava/util/Set;", "equals", "other", "", "_hashCode", "get_hashCode", "()I", "_hashCode$delegate", "Lkotlin/Lazy;", "hashCode", "getStability", "Lorg/jetbrains/kotlin/types/SmartcastStability;", "flow", "Lorg/jetbrains/kotlin/fir/resolve/dfa/Flow;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "hasFinalType", "propertyStability", "Lorg/jetbrains/kotlin/fir/resolve/dfa/PropertyStability;", "getPropertyStability", "()Lorg/jetbrains/kotlin/fir/resolve/dfa/PropertyStability;", "propertyStability$delegate", "semantics"})
@SourceDebugExtension(value={"SMAP\nDfaVariables.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DfaVariables.kt\norg/jetbrains/kotlin/fir/resolve/dfa/RealVariable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 FirStatusUtils.kt\norg/jetbrains/kotlin/fir/declarations/utils/FirStatusUtilsKt\n*L\n1#1,193:1\n1#2:194\n1755#3,3:195\n17#4,2:198\n37#4:200\n21#4:201\n17#4,2:202\n*S KotlinDebug\n*F\n+ 1 DfaVariables.kt\norg/jetbrains/kotlin/fir/resolve/dfa/RealVariable\n*L\n117#1:195,3\n130#1:198,2\n134#1:200\n143#1:201\n144#1:202,2\n*E\n"})
public final class RealVariable
extends DataFlowVariable {
    @NotNull
    private final Identifier identifier;
    @Nullable
    private final ConeKotlinType originalType;
    private final boolean isThisReference;
    @Nullable
    private final DataFlowVariable explicitReceiverVariable;
    @NotNull
    private final Set<RealVariable> dependentVariables;
    @NotNull
    private final Lazy _hashCode$delegate;
    @NotNull
    private final Lazy propertyStability$delegate;

    public RealVariable(@NotNull Identifier identifier, @Nullable ConeKotlinType originalType, boolean isThisReference, @Nullable DataFlowVariable explicitReceiverVariable, int variableIndexForDebug) {
        Intrinsics.checkNotNullParameter(identifier, "identifier");
        super(variableIndexForDebug, null);
        this.identifier = identifier;
        this.originalType = originalType;
        this.isThisReference = isThisReference;
        this.explicitReceiverVariable = explicitReceiverVariable;
        this.dependentVariables = new LinkedHashSet();
        this._hashCode$delegate = LazyKt.lazy(() -> RealVariable._hashCode_delegate$lambda$0(this));
        if (this.explicitReceiverVariable instanceof RealVariable) {
            ((RealVariable)this.explicitReceiverVariable).dependentVariables.add(this);
        }
        this.propertyStability$delegate = LazyKt.lazy(() -> RealVariable.propertyStability_delegate$lambda$5(this));
    }

    @NotNull
    public final Identifier getIdentifier() {
        return this.identifier;
    }

    @Nullable
    public final ConeKotlinType getOriginalType() {
        return this.originalType;
    }

    public final boolean isThisReference() {
        return this.isThisReference;
    }

    @Nullable
    public final DataFlowVariable getExplicitReceiverVariable() {
        return this.explicitReceiverVariable;
    }

    @NotNull
    public final Set<RealVariable> getDependentVariables() {
        return this.dependentVariables;
    }

    public boolean equals(@Nullable Object other) {
        return this == other;
    }

    private final int get_hashCode() {
        Lazy lazy = this._hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    public int hashCode() {
        return this.get_hashCode();
    }

    @NotNull
    public final SmartcastStability getStability(@NotNull Flow flow, @NotNull FirSession session2) {
        Intrinsics.checkNotNullParameter(flow, "flow");
        Intrinsics.checkNotNullParameter(session2, "session");
        if (!this.isThisReference) {
            RealVariable dispatchReceiver;
            SmartcastStability smartcastStability;
            Object object;
            PropertyStability stability = this.getPropertyStability();
            boolean isUnstableSmartcastOnDelegatedProperties = FirLanguageSettingsComponentKt.getLanguageVersionSettings(session2).supportsFeature(LanguageFeature.UnstableSmartcastOnDelegatedProperties);
            if (isUnstableSmartcastOnDelegatedProperties) {
                object = this.identifier.getSymbol().getFir();
                FirProperty firProperty = object instanceof FirProperty ? (FirProperty)object : null;
                boolean bl = firProperty != null ? ClassMembersKt.isDelegated(firProperty) : false;
                if (bl) {
                    return SmartcastStability.DELEGATED_PROPERTY;
                }
            }
            if ((smartcastStability = stability.getInherentInstability()) != null) {
                SmartcastStability it = smartcastStability;
                boolean bl = false;
                return it;
            }
            object = this.identifier.getDispatchReceiver();
            RealVariable realVariable = dispatchReceiver = object instanceof RealVariable ? (RealVariable)object : null;
            if (stability.getCheckReceiver()) {
                RealVariable realVariable2 = dispatchReceiver;
                boolean bl = realVariable2 != null ? !realVariable2.hasFinalType(flow, session2) : false;
                if (bl) {
                    return SmartcastStability.PROPERTY_WITH_GETTER;
                }
            }
            if (stability.getCheckModule()) {
                Object obj = this.identifier.getSymbol().getFir();
                Intrinsics.checkNotNull(obj, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirVariable");
                if (!DfaVariablesKt.access$isInCurrentOrFriendModule((FirVariable)obj, session2)) {
                    return SmartcastStability.ALIEN_PUBLIC_PROPERTY;
                }
            }
            if (dispatchReceiver != null && (object = dispatchReceiver.getStability(flow, session2)) != null) {
                Object object2;
                Object object3;
                Object it = object3 = object;
                boolean bl = false;
                Object object4 = object2 = it != SmartcastStability.STABLE_VALUE ? object3 : null;
                if (object2 != null) {
                    it = object2;
                    boolean bl2 = false;
                    return it;
                }
            }
        }
        return SmartcastStability.STABLE_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasFinalType(Flow flow, FirSession session2) {
        ConeKotlinType it;
        boolean bl;
        ConeKotlinType coneKotlinType = this.originalType;
        if (coneKotlinType != null) {
            if (DfaVariablesKt.access$isFinal(coneKotlinType, session2)) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        TypeStatement typeStatement = flow.getTypeStatement(this);
        Object object = typeStatement;
        if (typeStatement == null) return false;
        Set<ConeKotlinType> set = ((TypeStatement)object).getExactType();
        object = set;
        if (set == null) return false;
        Iterable $this$any$iv = (Iterable)object;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            it = (ConeKotlinType)element$iv;
            boolean bl2 = false;
        } while (!DfaVariablesKt.access$isFinal(it, session2));
        return true;
    }

    private final PropertyStability getPropertyStability() {
        Lazy lazy = this.propertyStability$delegate;
        return (PropertyStability)((Object)lazy.getValue());
    }

    private static final int _hashCode_delegate$lambda$0(RealVariable this$0) {
        DataFlowVariable dataFlowVariable = this$0.explicitReceiverVariable;
        return 31 * this$0.identifier.hashCode() + (dataFlowVariable != null ? dataFlowVariable.hashCode() : 0);
    }

    private static final PropertyStability propertyStability_delegate$lambda$5(RealVariable this$0) {
        PropertyStability propertyStability;
        Object fir = this$0.identifier.getSymbol().getFir();
        if (!(fir instanceof FirVariable)) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirEnumEntry) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirErrorProperty) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirValueParameter) {
            propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
        } else if (fir instanceof FirBackingField) {
            propertyStability = ((FirBackingField)fir).isVal() ? PropertyStability.PRIVATE_OR_CONST_VAL : PropertyStability.MUTABLE_PROPERTY;
        } else if (fir instanceof FirField) {
            Modality modality$iv;
            FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)fir;
            boolean $i$f$isFinal = false;
            Modality modality = $this$isFinal$iv.getStatus().getModality();
            propertyStability = (modality == null ? true : (modality$iv = modality) == Modality.FINAL) ? PropertyStability.PUBLIC_FINAL_VAL : PropertyStability.MUTABLE_PROPERTY;
        } else if (fir instanceof FirProperty) {
            FirMemberDeclaration $this$isExpect$iv = (FirMemberDeclaration)fir;
            boolean $i$f$isExpect = false;
            if ($this$isExpect$iv.getStatus().isExpect()) {
                propertyStability = PropertyStability.EXPECT_PROPERTY;
            } else if (((FirProperty)fir).getDelegate() != null) {
                propertyStability = PropertyStability.DELEGATED_PROPERTY;
            } else if (((FirProperty)fir).isLocal() && ((FirProperty)fir).isVar()) {
                propertyStability = PropertyStability.CAPTURED_VARIABLE;
            } else if (((FirProperty)fir).isLocal()) {
                propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
            } else if (((FirProperty)fir).isVar()) {
                propertyStability = PropertyStability.MUTABLE_PROPERTY;
            } else if (((FirProperty)fir).getReceiverParameter() != null) {
                propertyStability = PropertyStability.PROPERTY_WITH_GETTER;
            } else {
                FirPropertyAccessor firPropertyAccessor = ((FirProperty)fir).getGetter();
                if (!(firPropertyAccessor == null ? true : firPropertyAccessor instanceof FirDefaultPropertyAccessor)) {
                    propertyStability = PropertyStability.PROPERTY_WITH_GETTER;
                } else {
                    FirMemberDeclaration $this$visibility$iv = (FirMemberDeclaration)fir;
                    boolean $i$f$getVisibility = false;
                    if (Intrinsics.areEqual($this$visibility$iv.getStatus().getVisibility(), Visibilities.Private.INSTANCE)) {
                        propertyStability = PropertyStability.PRIVATE_OR_CONST_VAL;
                    } else {
                        Modality modality$iv;
                        FirMemberDeclaration $this$isFinal$iv = (FirMemberDeclaration)fir;
                        boolean $i$f$isFinal = false;
                        Modality modality = $this$isFinal$iv.getStatus().getModality();
                        propertyStability = (modality == null ? true : (modality$iv = modality) == Modality.FINAL) ? PropertyStability.PUBLIC_FINAL_VAL : PropertyStability.PUBLIC_OPEN_VAL;
                    }
                }
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return propertyStability;
    }
}

