/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.js.translate.callTranslator;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.PropertySetterDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeAliasConstructorDescriptor;
import org.jetbrains.kotlin.js.backend.ast.JsBinaryOperation;
import org.jetbrains.kotlin.js.backend.ast.JsExpression;
import org.jetbrains.kotlin.js.backend.ast.JsName;
import org.jetbrains.kotlin.js.backend.ast.metadata.MetadataProperties;
import org.jetbrains.kotlin.js.backend.ast.metadata.SideEffectKind;
import org.jetbrains.kotlin.js.translate.callTranslator.CallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.FunctionCallInfo;
import org.jetbrains.kotlin.js.translate.callTranslator.VariableAccessInfo;
import org.jetbrains.kotlin.js.translate.reference.ReferenceTranslator;
import org.jetbrains.kotlin.js.translate.utils.AnnotationsUtils;
import org.jetbrains.kotlin.js.translate.utils.JsAstUtils;
import org.jetbrains.kotlin.js.translate.utils.TranslationUtils;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\n\u0010\u0005\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0007\u001a\u00020\u0006*\u00020\u0002\u001a\n\u0010\u0015\u001a\u00020\u0006*\u00020\u000e\u001a\n\u0010\u0016\u001a\u00020\u0017*\u00020\u000e\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u000e\u001a\u0012\u0010\u0019\u001a\u00020\t*\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\t\u001a\n\u0010\u001f\u001a\u00020\u0006*\u00020\u001c\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\b\u001a\u00020\t*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\"\u0015\u0010\f\u001a\u00020\r*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\"\u0015\u0010\u0011\u001a\u00020\u0012*\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0015\u0010\u001b\u001a\u00020\u0012*\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006 "}, d2={"callableDescriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;", "getCallableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "isNative", "", "isSuperInvocation", "calleeOwner", "Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "getCalleeOwner", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/CallInfo;)Lorg/jetbrains/kotlin/js/backend/ast/JsExpression;", "variableDescriptor", "Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;", "getVariableDescriptor", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lorg/jetbrains/kotlin/descriptors/VariableDescriptor;", "variableName", "Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "getVariableName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/VariableAccessInfo;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "isGetAccess", "getAccessDescriptor", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "getAccessDescriptorIfNeeded", "constructAccessExpression", "ref", "functionName", "Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;", "getFunctionName", "(Lorg/jetbrains/kotlin/js/translate/callTranslator/FunctionCallInfo;)Lorg/jetbrains/kotlin/js/backend/ast/JsName;", "hasSpreadOperator", "js.translator"})
public final class CallInfoExtensionsKt {
    @NotNull
    public static final CallableDescriptor getCallableDescriptor(@NotNull CallInfo $this$callableDescriptor) {
        Intrinsics.checkNotNullParameter($this$callableDescriptor, "<this>");
        CallableDescriptor callableDescriptor = $this$callableDescriptor.getResolvedCall().getResultingDescriptor().getOriginal();
        Intrinsics.checkNotNullExpressionValue(callableDescriptor, "getOriginal(...)");
        CallableDescriptor result2 = callableDescriptor;
        return result2 instanceof TypeAliasConstructorDescriptor ? (CallableDescriptor)((TypeAliasConstructorDescriptor)result2).getUnderlyingConstructorDescriptor() : result2;
    }

    public static final boolean isNative(@NotNull CallInfo $this$isNative) {
        Intrinsics.checkNotNullParameter($this$isNative, "<this>");
        return AnnotationsUtils.isNativeObject(CallInfoExtensionsKt.getCallableDescriptor($this$isNative));
    }

    public static final boolean isSuperInvocation(@NotNull CallInfo $this$isSuperInvocation) {
        Intrinsics.checkNotNullParameter($this$isSuperInvocation, "<this>");
        ReceiverValue dispatchReceiver = $this$isSuperInvocation.getResolvedCall().getDispatchReceiver();
        return dispatchReceiver instanceof ExpressionReceiver && ((ExpressionReceiver)dispatchReceiver).getExpression() instanceof KtSuperExpression;
    }

    @NotNull
    public static final JsExpression getCalleeOwner(@NotNull CallInfo $this$calleeOwner) {
        Intrinsics.checkNotNullParameter($this$calleeOwner, "<this>");
        DeclarationDescriptor declarationDescriptor = $this$calleeOwner.getResolvedCall().getResultingDescriptor().getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue(declarationDescriptor, "getContainingDeclaration(...)");
        DeclarationDescriptor calleeOwner = declarationDescriptor;
        JsExpression jsExpression = ReferenceTranslator.translateAsValueReference(calleeOwner, $this$calleeOwner.getContext());
        Intrinsics.checkNotNullExpressionValue(jsExpression, "translateAsValueReference(...)");
        return jsExpression;
    }

    @NotNull
    public static final VariableDescriptor getVariableDescriptor(@NotNull VariableAccessInfo $this$variableDescriptor) {
        Intrinsics.checkNotNullParameter($this$variableDescriptor, "<this>");
        CallableDescriptor callableDescriptor = CallInfoExtensionsKt.getCallableDescriptor($this$variableDescriptor);
        Intrinsics.checkNotNull(callableDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.VariableDescriptor");
        return (VariableDescriptor)callableDescriptor;
    }

    @NotNull
    public static final JsName getVariableName(@NotNull VariableAccessInfo $this$variableName) {
        Intrinsics.checkNotNullParameter($this$variableName, "<this>");
        JsName jsName = $this$variableName.getContext().getNameForDescriptor(CallInfoExtensionsKt.getVariableDescriptor($this$variableName));
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(...)");
        return jsName;
    }

    public static final boolean isGetAccess(@NotNull VariableAccessInfo $this$isGetAccess) {
        Intrinsics.checkNotNullParameter($this$isGetAccess, "<this>");
        return $this$isGetAccess.getValue() == null;
    }

    @NotNull
    public static final PropertyAccessorDescriptor getAccessDescriptor(@NotNull VariableAccessInfo $this$getAccessDescriptor) {
        PropertyAccessorDescriptor propertyAccessorDescriptor;
        Intrinsics.checkNotNullParameter($this$getAccessDescriptor, "<this>");
        VariableDescriptor variableDescriptor = CallInfoExtensionsKt.getVariableDescriptor($this$getAccessDescriptor);
        Intrinsics.checkNotNull(variableDescriptor, "null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.PropertyDescriptor");
        PropertyDescriptor property = (PropertyDescriptor)variableDescriptor;
        if (CallInfoExtensionsKt.isGetAccess($this$getAccessDescriptor)) {
            PropertyGetterDescriptor propertyGetterDescriptor = property.getGetter();
            Intrinsics.checkNotNull(propertyGetterDescriptor);
            propertyAccessorDescriptor = propertyGetterDescriptor;
        } else {
            PropertySetterDescriptor propertySetterDescriptor = property.getSetter();
            Intrinsics.checkNotNull(propertySetterDescriptor);
            propertyAccessorDescriptor = propertySetterDescriptor;
        }
        return propertyAccessorDescriptor;
    }

    @NotNull
    public static final CallableDescriptor getAccessDescriptorIfNeeded(@NotNull VariableAccessInfo $this$getAccessDescriptorIfNeeded) {
        Intrinsics.checkNotNullParameter($this$getAccessDescriptorIfNeeded, "<this>");
        return CallInfoExtensionsKt.getVariableDescriptor($this$getAccessDescriptorIfNeeded) instanceof PropertyDescriptor && (DescriptorUtilsKt.isExtension(CallInfoExtensionsKt.getVariableDescriptor($this$getAccessDescriptorIfNeeded)) || TranslationUtils.shouldAccessViaFunctions(CallInfoExtensionsKt.getVariableDescriptor($this$getAccessDescriptorIfNeeded))) ? (CallableDescriptor)CallInfoExtensionsKt.getAccessDescriptor($this$getAccessDescriptorIfNeeded) : (CallableDescriptor)CallInfoExtensionsKt.getVariableDescriptor($this$getAccessDescriptorIfNeeded);
    }

    @NotNull
    public static final JsExpression constructAccessExpression(@NotNull VariableAccessInfo $this$constructAccessExpression, @NotNull JsExpression ref) {
        JsExpression jsExpression;
        Intrinsics.checkNotNullParameter($this$constructAccessExpression, "<this>");
        Intrinsics.checkNotNullParameter(ref, "ref");
        if (CallInfoExtensionsKt.isGetAccess($this$constructAccessExpression)) {
            jsExpression = ref;
        } else {
            MetadataProperties.setSideEffects(ref, SideEffectKind.PURE);
            JsExpression jsExpression2 = $this$constructAccessExpression.getValue();
            Intrinsics.checkNotNull(jsExpression2);
            JsBinaryOperation jsBinaryOperation = JsAstUtils.assignment(ref, jsExpression2);
            Intrinsics.checkNotNull(jsBinaryOperation);
            jsExpression = jsBinaryOperation;
        }
        return jsExpression;
    }

    @NotNull
    public static final JsName getFunctionName(@NotNull FunctionCallInfo $this$functionName) {
        Intrinsics.checkNotNullParameter($this$functionName, "<this>");
        JsName jsName = $this$functionName.getContext().getNameForDescriptor(CallInfoExtensionsKt.getCallableDescriptor($this$functionName));
        Intrinsics.checkNotNullExpressionValue(jsName, "getNameForDescriptor(...)");
        return jsName;
    }

    public static final boolean hasSpreadOperator(@NotNull FunctionCallInfo $this$hasSpreadOperator) {
        Intrinsics.checkNotNullParameter($this$hasSpreadOperator, "<this>");
        return $this$hasSpreadOperator.getArgumentsInfo().getHasSpreadOperator();
    }
}

