
/* Do not modify this file it was automatically generated by the
 * TokenList2DsnLexer CMake script.
 */

#ifndef PCB_LEXER_H_
#define PCB_LEXER_H_

#include <dsnlexer.h>

/**
 * C++ does not put enum _values_ in separate namespaces unless the enum itself
 * is in a separate namespace.  All the token enums must be in separate namespaces
 * otherwise the C++ compiler will eventually complain if it sees more than one
 * DSNLEXER in the same compilation unit, say by mutliple header file inclusion.
 * Plus this also enables re-use of the same enum name T.  A typedef can always be used
 * to clarify which enum T is in play should that ever be a problem.  This is
 * unlikely since Parse() functions will usually only be exposed to one header
 * file like this one.  But if there is a problem, then use:
 *   typedef PCB_KEYS_T::T T;
 * within that problem area.
 */
namespace PCB_KEYS_T
{
    /// enum T contains all this lexer's tokens.
    enum T
    {
        // these first few are negative special ones for syntax, and are
        // inherited from DSNLEXER.
        T_NONE          = DSN_NONE,
        T_COMMENT       = DSN_COMMENT,
        T_STRING_QUOTE  = DSN_STRING_QUOTE,
        T_QUOTE_DEF     = DSN_QUOTE_DEF,
        T_DASH          = DSN_DASH,
        T_SYMBOL        = DSN_SYMBOL,
        T_NUMBER        = DSN_NUMBER,
        T_RIGHT         = DSN_RIGHT,        // right bracket: ')'
        T_LEFT          = DSN_LEFT,         // left bracket:  '('
        T_STRING        = DSN_STRING,       // a quoted string, stripped of the quotes
        T_EOF           = DSN_EOF,          // special case for end of file

        T_add_net = 0,
        T_allowed,
        T_angle,
        T_arc,
        T_arc_segments,
        T_area,
        T_arrow1a,
        T_arrow1b,
        T_arrow2a,
        T_arrow2b,
        T_at,
        T_attr,
        T_autoplace_cost180,
        T_autoplace_cost90,
        T_aux_axis_origin,
        T_blind,
        T_bold,
        T_bottom,
        T_center,
        T_chamfer,
        T_circle,
        T_clearance,
        T_comment,
        T_company,
        T_connect,
        T_connect_pads,
        T_copperpour,
        T_crossbar,
        T_date,
        T_descr,
        T_die_length,
        T_dimension,
        T_drawings,
        T_drill,
        T_edge,
        T_edge_width,
        T_effects,
        T_end,
        T_feature1,
        T_feature2,
        T_fill,
        T_fill_segments,
        T_filled_polygon,
        T_fillet,
        T_font,
        T_fp_arc,
        T_fp_circle,
        T_fp_curve,
        T_fp_line,
        T_fp_poly,
        T_fp_text,
        T_full,
        T_general,
        T_gr_arc,
        T_gr_circle,
        T_gr_curve,
        T_gr_line,
        T_gr_poly,
        T_gr_text,
        T_hatch,
        T_hide,
        T_italic,
        T_justify,
        T_keepout,
        T_kicad_pcb,
        T_last_trace_width,
        T_layer,
        T_layers,
        T_left,
        T_links,
        T_locked,
        T_micro,
        T_min_thickness,
        T_mirror,
        T_mod_edge_width,
        T_mod_text_size,
        T_mod_text_width,
        T_mode,
        T_model,
        T_module,
        T_net,
        T_net_class,
        T_net_name,
        T_nets,
        T_no,
        T_no_connects,
        T_none,
        T_not_allowed,
        T_np_thru_hole,
        T_offset,
        T_oval,
        T_pad,
        T_pad_drill,
        T_pad_size,
        T_pad_to_mask_clearance,
        T_pad_to_paste_clearance,
        T_pad_to_paste_clearance_ratio,
        T_pads,
        T_page,
        T_path,
        T_pcb_text_size,
        T_pcb_text_width,
        T_pcbplotparams,
        T_placed,
        T_plus,
        T_polygon,
        T_portrait,
        T_priority,
        T_pts,
        T_radius,
        T_rect,
        T_rect_delta,
        T_reference,
        T_rev,
        T_right,
        T_rotate,
        T_scale,
        T_segment,
        T_segment_width,
        T_setup,
        T_size,
        T_smd,
        T_smoothing,
        T_solder_mask_margin,
        T_solder_mask_min_width,
        T_solder_paste_margin,
        T_solder_paste_margin_ratio,
        T_solder_paste_ratio,
        T_start,
        T_status,
        T_tags,
        T_target,
        T_tedit,
        T_thermal_bridge_width,
        T_thermal_gap,
        T_thermal_width,
        T_thickness,
        T_thru,
        T_thru_hole,
        T_thru_hole_only,
        T_title,
        T_title_block,
        T_top,
        T_trace_clearance,
        T_trace_min,
        T_trace_width,
        T_tracks,
        T_trapezoid,
        T_tstamp,
        T_user,
        T_user_trace_width,
        T_user_via,
        T_uvia_dia,
        T_uvia_drill,
        T_uvia_min_drill,
        T_uvia_min_size,
        T_uvia_size,
        T_uvias_allowed,
        T_value,
        T_version,
        T_via,
        T_via_dia,
        T_via_drill,
        T_via_min_drill,
        T_via_min_size,
        T_via_size,
        T_vias,
        T_virtual,
        T_visible_elements,
        T_width,
        T_x,
        T_xy,
        T_xyz,
        T_yes,
        T_zone,
        T_zone_45_only,
        T_zone_clearance,
        T_zone_connect,
        T_zone_type,
        T_zones
    };
}   // namespace PCB_KEYS_T


/**
 * Class PCB_LEXER
 * is an automatically generated class using the TokenList2DnsLexer.cmake
 * technology, based on keywords provided by file:
 *    F:/kicad-launchpad/stable/stable_2013-05-18_BZR4017/common/pcb.keywords
 */
class PCB_LEXER : public DSNLEXER
{
    /// Auto generated lexer keywords table and length:
    static const KEYWORD  keywords[];
    static const unsigned keyword_count;

public:
    /**
     * Constructor ( const std::string&, const wxString& )
     * @param aSExpression is (utf8) text possibly from the clipboard that you want to parse.
     * @param aSource is a description of the origin of @a aSExpression, such as a filename.
     *   If left empty, then _(clipboard) is used.
     */
    PCB_LEXER( const std::string& aSExpression, const wxString& aSource = wxEmptyString ) :
        DSNLEXER( keywords, keyword_count, aSExpression, aSource )
    {
    }

    /**
     * Constructor ( FILE* )
     * takes @a aFile already opened for reading and @a aFilename as parameters.
     * The opened file is assumed to be positioned at the beginning of the file
     * for purposes of accurate line number reporting in error messages.  The
     * FILE is closed by this instance when its destructor is called.
     * @param aFile is a FILE already opened for reading.
     * @param aFilename is the name of the opened file, needed for error reporting.
     */
    PCB_LEXER( FILE* aFile, const wxString& aFilename ) :
        DSNLEXER( keywords, keyword_count, aFile, aFilename )
    {
    }

    /**
     * Constructor ( LINE_READER* )
     * intializes a lexer and prepares to read from @a aLineReader which
     * is assumed ready, and may be in use by other DSNLEXERs also.  No ownership
     * is taken of @a aLineReader. This enables it to be used by other lexers also.
     * The transition between grammars in such a case, must happen on a text
     * line boundary, not within the same line of text.
     *
     * @param aLineReader is any subclassed instance of LINE_READER, such as
     *  STRING_LINE_READER or FILE_LINE_READER.  No ownership is taken of aLineReader.
     */
    PCB_LEXER( LINE_READER* aLineReader ) :
        DSNLEXER( keywords, keyword_count, aLineReader )
    {
    }

    /**
     * Function TokenName
     * returns the name of the token in ASCII form.
     */
    static const char* TokenName( PCB_KEYS_T::T aTok );

    /**
     * Function NextTok
     * returns the next token found in the input file or T_EOF when reaching
     * the end of file.  Users should wrap this function to return an enum
     * to aid in grammar debugging while running under a debugger, but leave
     * this lower level function returning an int (so the enum does not collide
     * with another usage).
     * @return PCB_KEYS_T::T - the type of token found next.
     * @throw IO_ERROR - only if the LINE_READER throws it.
     */
    PCB_KEYS_T::T NextTok() throw( IO_ERROR )
    {
        return (PCB_KEYS_T::T) DSNLEXER::NextTok();
    }

    /**
     * Function NeedSYMBOL
     * calls NextTok() and then verifies that the token read in
     * satisfies bool IsSymbol().
     * If not, an IO_ERROR is thrown.
     * @return int - the actual token read in.
     * @throw IO_ERROR, if the next token does not satisfy IsSymbol()
     */
    PCB_KEYS_T::T NeedSYMBOL() throw( IO_ERROR )
    {
        return (PCB_KEYS_T::T) DSNLEXER::NeedSYMBOL();
    }

    /**
     * Function NeedSYMBOLorNUMBER
     * calls NextTok() and then verifies that the token read in
     * satisfies bool IsSymbol() or tok==T_NUMBER.
     * If not, an IO_ERROR is thrown.
     * @return int - the actual token read in.
     * @throw IO_ERROR, if the next token does not satisfy the above test
     */
    PCB_KEYS_T::T NeedSYMBOLorNUMBER() throw( IO_ERROR )
    {
        return (PCB_KEYS_T::T) DSNLEXER::NeedSYMBOLorNUMBER();
    }

    /**
     * Function CurTok
     * returns whatever NextTok() returned the last time it was called.
     */
    PCB_KEYS_T::T CurTok()
    {
        return (PCB_KEYS_T::T) DSNLEXER::CurTok();
    }

    /**
     * Function PrevTok
     * returns whatever NextTok() returned the 2nd to last time it was called.
     */
    PCB_KEYS_T::T PrevTok()
    {
        return (PCB_KEYS_T::T) DSNLEXER::PrevTok();
    }
};

// example usage

/**
 * Class _PARSER
 * holds data and functions pertinent to parsing a S-expression file .
 *
class PCB_PARSER : public PCB_LEXER
{

};
*/

#endif   // PCB_LEXER_H_
