	/****************************************************/
	/* sch2eed: convertisseur de scheme sdt -> EESchema */
	/****************************************************/

#include "fctsys.h"
#include "eelibsl.h"

#define DELIMITER '\''

#define FIND_ALIAS 1
#define FIND_ROOT 0

#define TEXT_SIZE 60
#define UNIT 1000
#define CVUNIT(f) (int)(( f * UNIT) + 0.5)

/* Fonctions */
static void ReadSdtModPort(FILE *FileOut, char *Line);
static void ReadSdtSheet(FILE *FileIn, FILE *FileOut, char *Line, int * LineNum);
static void ReadSdtPower(FILE *FileOut, char *Line);
static int ReadSdtData( FILE * FileIn, FILE * FileOut, char * Line, int * LineNum);
static void ReadSdtPart(FILE * FileIn, FILE *FileOut, char *Line, int *LineNum);
char * GetLine(FILE *File, char *Line, int *LineNum, int MaxLen);
char * DateAndTime(char * Line);
static void ChangeSpaces(char * Text, int NewChar);
int ReadDelimitedText(char * dest, char * source, int NbMaxChar );
void * MyMalloc (int nb_octets);
void * MyZMalloc (int nb_octets);
void MyFree (void * pt_mem);
char * StrPurge(char * text);
int ReturnDimCmp(int * cx, int * cy, char * Name );

/* Variables */
char FileNameSdt[1024],FileNameSdtLib[1024], FileNameEESchema[1024];
FILE * FileSdt, * FileEESchema, * FileSdtLib;
PriorQue *PQ = NULL;
char AliasList[1024];
int CurrentConvert;
int IsVector;
int PartPerPack;
int GridArray;

	/*************************************/
	/* int main(int nbarg, char **ptarg) */
	/*************************************/

int main(int nbarg, char **ptarg)
{
int LineNum = 1;
char Line[1024];


	printf("\n**** Sch->EESchema version 1.2 ****\n\n");

	if( nbarg != 4 )
		{
		printf( " usage sch2eed source destination librairie (sans extension)\n") ; return(1);
		}

	sprintf(FileNameSdt,"%s.aex",ptarg[1]);
	sprintf(FileNameEESchema,"%s.sch",ptarg[2]);
	sprintf(FileNameSdtLib,"%s.src",ptarg[3]);

	FileSdt = fopen( FileNameSdt, "rt" );
	if( FileSdt == NULL )
		{
		printf( " %s non trouve\n", FileNameSdt);
		return(-1);
		}

	FileSdtLib = fopen( FileNameSdtLib, "rt" );
	if( FileSdtLib == NULL )
		{
		printf( " %s non trouve\n", FileNameSdtLib);
		fclose(FileSdt);
		return(-1);
		}

	FileEESchema = fopen( FileNameEESchema, "wt" );
	if( FileEESchema == NULL )
		{
		printf( " %s impossible a creer\n", FileNameEESchema);
		fclose(FileSdt);
		fclose(FileSdtLib);
		return(-1);
		}

	
	/* Write entete */

	fprintf(FileEESchema,"EESchema Schematic File Version 1\n");
	fprintf(FileEESchema,"LIBS:none\n");
	fprintf(FileEESchema,"EELAYER 0 0\nEELAYER END\n");

	ReadSdtData( FileSdt, FileEESchema, Line, &LineNum);

	fclose(FileEESchema);
	fclose(FileSdt);
	if( FileSdtLib ) fclose(FileSdtLib);
	return(0);
}

	/***********************************/
	/* void * MyMalloc (int nb_octets) */
	/***********************************/
/* Routine d'allocation memoire */
void * MyMalloc (int nb_octets)
{
void * pt_mem;
char txt[60];
	pt_mem = malloc(nb_octets);
	if (pt_mem == NULL)
		{
		printf(txt,"Memoire Insuffisante pou alloc %d octets", nb_octets);
		}
	return(pt_mem);
}

	/************************************/
	/* void * MyZMalloc (int nb_octets) */
	/************************************/
/* Routine d'allocation memoire, avec remise a zero de la zone allouee */
void * MyZMalloc (int nb_octets)
{
void * pt_mem;
char txt[60];
	pt_mem = malloc(nb_octets);
	if (pt_mem == NULL)
		{
		printf(txt,"Memoire Insuffisante pou alloc %d octets", nb_octets);
		return(pt_mem);
		}
	memset(pt_mem, 0, nb_octets);
	return(pt_mem);
}

	/*******************************/
	/* void MyFree (void * pt_mem) */
	/*******************************/

void MyFree (void * pt_mem)
{
	free(pt_mem);
}



	/*********************************************************************/
	/* int ReadDelimitedText(char * dest, char * source, int NbMaxChar ) */
	/*********************************************************************/

/* lit et place dans dest la chaine de caractere trouvee dans source,
	delimitee par ' .
	transfere NbMaxChar max 
	retourne le nombre de codes lus dans source
	dest est termine par NULL
*/
int ReadDelimitedText(char * dest, char * source, int NbMaxChar )
{
int ii, jj, flag = 0;

	 for ( ii = 1, jj = 0; ii < NbMaxChar ; jj++, source++)
		{
		if ( * source == 0 ) break;	/* fin de ligne */
		if ( * source == DELIMITER )	  /* delimiteur trouve */
			{
			if ( flag )					/* Fin de texte delimite */
				{
				if( *(source+1) != DELIMITER ) break;
				* dest = * source; dest += 2; ii++;
				}
			flag = 1;					/* Marque 1er delimiteur trouve */
			}
		else if ( flag )
			{
			* dest = * source; dest++; ii++;
			}
		}
	*dest = 0;  /* Null terminaison */
	return (jj);
}
 
	/********************************/
	/* char * StrPurge(char * text) */
	/********************************/

/* Supprime les caracteres Space en debut de la ligne text
	retourne un pointeur sur le 1er caractere non Space de text
*/
char * StrPurge(char * text)
{
char * ptspace;
	while( (*text <= ' ') && *text ) text++;
	ptspace = text + strlen(text) -1;
	while( (*ptspace <= ' ') && *ptspace && (ptspace >= text) )
		{
		*ptspace = 0; ptspace--;
		}
	return(text);
}


	/*******************************************************************/
	/* char *GetLine(FILE *File, char *Line, int *LineNum, int MaxLen) */
	/*******************************************************************/

/* Routine de lecture de 1 ligne utile
	retourne la 1ere ligne utile lue.
	elimine lignes vides et commentaires
	incremente *LineNum a chaque ligne lue
*/
char * GetLine(FILE *File, char *Line, int *LineNum, int MaxLen)
{
	do  {
		if (fgets(Line, MaxLen, File) == NULL) return NULL;
		if( LineNum ) *LineNum += 1;
		} while (Line[0] == '#' || Line[0] == '\n' ||  Line[0] == '\r' ||
				 Line[0] == 0);

	return Line;
}

	/***********************************/
	/* char * DateAndTime(char * Line) */
	/***********************************/

/* Retourne la chaine de caractere donnant date+heure */
char * DateAndTime(char * Line)
{
#ifdef TO_DOS
struct date Date;
struct time heure;

	getdate(&Date);
	gettime(&heure);
	sprintf(Line,"%d/%d/%d-%d:%d:%d", Date.da_day, Date.da_mon, Date.da_year,
			heure.ti_hour, heure.ti_min, heure.ti_sec );
#else
	*Line = 0;
#endif
	return(Line);
}


/************************************************************/
/* ReadSdtData( FILE * FileIn, LibraryEntryStruct * LibEntry,*/
/*								char * Line, int * LineNum) */
/************************************************************/

int ReadSdtData( FILE * FileIn, FILE * FileOut, char * Line, int * LineNum)
{
int end = 0, ox, oy, fx, fy, orient;
float ofx, ofy, ffx, ffy;
char Buff[256], Str1[256], Str2[256];



	for( ; end == 0; )
		{
		orient = 0;
		if( GetLine( FileIn,Line, LineNum, 1024) == NULL )
			{
			Line[0] = DELIMITER;
			end = 1; continue;
			}

		if( strnicmp(Line,"END()", 5) == 0 )
			{
			end = 1; continue;
			}
		if( strnicmp(Line,"TEXT", 4) == 0 )
			{
			/*sequence: "TEXT(9.30, 9.20, 1, 0, 'Barette pour dil 300mils')" */
			printf("T");
			sscanf(Line+5,"%f, %f, %d, %d", &ofx, &ofy, &fx, &fy);
			ReadDelimitedText(Buff, Line+5, 250);
			ox = CVUNIT(ofx);
			oy = CVUNIT(ofy);
			if( fy ) orient = 3;
			if ( fx == 0 ) fx = 1;	/* Size */
			fprintf(FileOut,"Text Notes %d %d %d %d\n", ox, oy ,orient,
				TEXT_SIZE * fx);
			fprintf(FileOut,"%s\n", Buff);
			continue;
			}

		if( strnicmp(Line,"NOCONN", 6) == 0 )
			{
			printf("N");
			sscanf(Line+7,"%f, %f", &ofx, &ofy);
			ox = CVUNIT(ofx); oy = CVUNIT(ofy);
			fprintf(FileOut,"NoConn ~ %d %d\n", ox, oy);
			continue;
			}

		if( strnicmp(Line,"LABEL", 5) == 0 )
			{
			printf("L");
			sscanf(Line+6,"%f, %f, %d, %d", &ofx, &ofy, &fx, &fy);
			ReadDelimitedText(Buff, Line+6,250);
			ox = CVUNIT(ofx); oy = CVUNIT(ofy);
			if ( fy ) orient = 3;
			if ( fx == 0 ) fx = 1;	/* Size */
			fprintf(FileOut,"Text Label %d %d %d %d\n", ox, oy ,orient,
							TEXT_SIZE * fx);
			fprintf(FileOut,"%s\n", Buff);
			continue;
			}

		if( strnicmp(Line,"MODPORT", 7) == 0 )
			{
			ReadSdtModPort(FileOut, Line);
			continue;
			}

		if( strnicmp(Line,"POWER", 5) == 0 )
			{
			printf("Pw");
			ReadSdtPower(FileOut, Line);
			continue;
			}

		if( strnicmp(Line,"SHEET", 5) == 0 )
			{
			printf("Sh");
			ReadSdtSheet(FileIn,FileOut, Line, LineNum);
			continue;
			}

		if( strnicmp(Line,"JUNCTION", 8) == 0 )
			{
			printf("J");
			sscanf(Line+9,"%f, %f", &ofx, &ofy);
			ox = CVUNIT(ofx); oy = CVUNIT(ofy);
			fprintf(FileOut,"Connection ~ %d %d\n", ox, oy);
			continue;
			}

		if( strnicmp(Line,"ENTRY", 5) == 0 )
			{
			printf("Y");
			sscanf(Line+6,"%f, %f, %s %s", &ofx, &ofy, Str1, Str2);
			fx = CVUNIT(ofx); fy = CVUNIT(ofy);
			ox = fx - 100;
			oy = fy + 100;
			if( Str1[0] == '\\' ) oy = fy - 100;
			fprintf(FileOut,"Entry ");
			if( Str2[0] == 'B' ) fprintf(FileOut,"Bus B\n");
			else fprintf(FileOut,"Wire L\n");

			fprintf(FileOut,"\t%d %d %d %d\n", ox, oy, fx, fy);
			continue;
			}

		if( strnicmp(Line,"WIRE", 4) == 0 )
			{
			printf("W");
			sscanf(Line+5,"%f, %f, %f, %f", &ofx, &ofy, &ffx, &ffy);
			ox = CVUNIT(ofx); oy = CVUNIT(ofy);
			fx = CVUNIT(ffx); fy = CVUNIT(ffy);
			fprintf(FileOut,"Wire Wire L\n    %d %d %d %d\n", ox, oy, fx, fy);
			continue;
			}

		if( strnicmp(Line,"DLINE", 5) == 0 )
			{
			printf("W");
			sscanf(Line+6,"%f, %f, %f, %f", &ofx, &ofy, &ffx, &ffy);
			ox = CVUNIT(ofx); oy = CVUNIT(ofy);
			fx = CVUNIT(ffx); fy = CVUNIT(ffy);
			fprintf(FileOut,"Wire Notes L\n    %d %d %d %d\n", ox, oy, fx, fy);
			continue;
			}

		if( strnicmp(Line,"BUS", 3) == 0 )
			{
			printf("W");
			sscanf(Line+4,"%f, %f, %f, %f", &ofx, &ofy, &ffx, &ffy);
			ox = CVUNIT(ofx); oy = CVUNIT(ofy);
			fx = CVUNIT(ffx); fy = CVUNIT(ffy);
			fprintf(FileOut,"Wire Bus B\n    %d %d %d %d\n", ox, oy, fx, fy);
			continue;
			}

		if( strnicmp(Line,"PART", 4) == 0 )
			{
			printf("P");
			ReadSdtPart(FileIn, FileOut, Line, LineNum);
			continue;
			}
		}

	return(1);
}


	/************************************************/
	/* void ReadSdtSheet(FILE *FileOut, char *Line) */
	/************************************************/
/* lit la sequence
SHEET(6.50, 5.10, 2.30, 2.40, 'FILTRE.SCH', 'FILTRE', '00000000', 
	NET(0.11, 0.30, 'VD', 'INPUT'), 
	..
)
*/

static void ReadSdtSheet(FILE *FileIn, FILE *FileOut, char *Line, int * LineNum)
{
float ofx, ofy, ffx, ffy;
int ii, jj, ox, oy, fx, fy, nx, ny;
char Name1[256], Name2[256], *Text;

	Text = Line+6;
	sscanf(Text,"%f, %f, %f, %f", &ofx, &ofy, &ffx, &ffy);
	ox = CVUNIT(ofx); oy = CVUNIT(ofy);
	fx = CVUNIT(ffx); fy = CVUNIT(ffy);
	
	fprintf(FileOut, "$Sheet\n");
	fprintf(FileOut, "S %-4d %-4d %-4d %-4d\n", ox, oy, fx, fy);

	ReadDelimitedText(Name1, Text,250);
	for ( jj = 0; jj < 2 ; Text++)
		{
		if(*Text == 0) break;
		if(*Text == DELIMITER) jj++;
		}
	ReadDelimitedText(Name2, Text,250);

	fprintf(FileOut,"F0 \"%s\" %d\n", Name1, TEXT_SIZE); /* SheetName */
	fprintf(FileOut,"F1 \"%s\" %d\n", Name1, TEXT_SIZE);	/* FileName */
	/* Recherche des NetSheetLabels : */

	for( ii = 2; ; )
		{
		if( GetLine( FileIn,Line, LineNum, 1024) == NULL ) break;

		Text = StrPurge(Line);		

		if( strnicmp(Text,")", 1) == 0 ) break;

		if( strnicmp(Text,"NET", 3) == 0 )
			{
			int type, side;
			ofx = ofy = 0.0;
			Text += 4;
			sscanf(Text,"%f, %f", &ofx, &ofy);
			nx = CVUNIT(ofx); ny = CVUNIT(ofy);

			ReadDelimitedText(Name1, Text, 256);

			/* Recherche du texte suivant */
			for ( jj = 0; jj < 2 ; Text++)
				{
				if(*Text == 0) break;
				if(*Text == DELIMITER) jj++;
				}

			ReadDelimitedText(Name2, Text, 256);

			side = 'L'; if ( nx < 0 ) side = 'R';
			nx = ox; if ( side == 'R' ) nx = fx + ox;
			ny += oy;

			type = 'U';
			if( stricmp( Name2,"INPUT") == 0 )  type = 'I';
			if( stricmp( Name2,"OUTPUT") == 0 ) type = 'O';
			if( stricmp( Name2,"BIDIRECTIONAL") == 0 ) type = 'B';
			if( stricmp( Name2,"UNSPECIFIED") == 0 ) type = 'U';

			fprintf(FileOut,"F%d \"%s\" %c %c %-3d %-3d %-3d\n", ii,
				 Name1, type, side, nx, ny, TEXT_SIZE);
			ii++;
			continue;
			}
		}

	fprintf(FileOut,"$EndSheet\n");
}

	/************************************************/
	/* void ReadSdtModPort(FILE *FileOut, char *Line) */
	/************************************************/

static void ReadSdtModPort(FILE *FileOut, char *Line)
{
float ofx, ofy;
int ii, ox, oy, len, orient, electric;
char * Shape;
char Buff[256], *Text, *Text2;

	Text = Line+8;
	sscanf(Text,"%f, %f", &ofx, &ofy);
	ox = CVUNIT(ofx); oy = CVUNIT(ofy);

	ReadDelimitedText(Buff, Text,250);
	ChangeSpaces(Buff, '_');

	/* Recherche autres parametres (orientation, forme..) : */

	for ( ii = 0; *Text != 0; Text++ )
		{
		if ( *Text == DELIMITER) ii++;
		if (ii >= 2 ) break;
		}

	Text = strtok(Text," ,')\n\r");
	sscanf(Text,"%f", &ofx); len = CVUNIT(ofx);
	Text = strtok(NULL," ,')\n\r");		/* pointe Orientation */

	Text2 = strtok(NULL," ,')\n\r");	/* Pointe type electrique */
	Shape = "Input"; electric = 0;

	if( strcmp(Text2, "INPUT" ) == 0 )
		{
		}

	if( strcmp(Text2, "OUTPUT" ) == 0)
		{
		Shape = "Output"; electric = 1;
		}
 
	if( strcmp(Text2, "BIDIRECTIONAL" ) == 0)
		{
		Shape = "BiDI"; electric = 2;
		}

	if( strcmp(Text2, "UNSPECIFIED" ) == 0)
		{
		Shape = "UnSpc"; electric = 3;
		}


	orient = 0;
	if( strcmp(Text, "RIGHT" ) == 0 ) /* |> */
		{
		if( electric == 0 ) ox += len;
		}

	if( strcmp(Text, "BOTH" ) == 0) /* bidi <>*/
		{
		ox += len;
		}
 
	if( strcmp(Text, "LEFT" ) == 0) /* <| */
		{
		orient = 2;
		}

	if( strcmp(Text, "PLAIN" ) == 0) /* | | */
		{
		ox += len;
		}

	fprintf(FileOut,"T G %d %d %d %d %s\n",
			ox, oy ,orient, TEXT_SIZE, Shape);
	fprintf(FileOut,"%s\n", Buff);
}

	/************************************************/
	/* void ReadSdtPower(FILE *FileOut, char *Line) */
	/************************************************/

static void ReadSdtPower(FILE *FileOut, char *Line)
{
float ofx, ofy;
int ii, ox, oy;
char Buff[256], *Text;
int Rot[2][2];

	Text = Line+6;
	sscanf(Text,"%f, %f", &ofx, &ofy);
	ox = CVUNIT(ofx);
	oy = CVUNIT(ofy);

	ReadDelimitedText(Buff, Line+6,250);

	/* Recherche autres parametres (orientation, forme..) : */
	Rot[0][0] = 1;
	Rot[0][1] = Rot[1][0] = 0;
	Rot[1][1] = -1; /* Orient TOP */

	for ( ii = 0; *Text != 0; Text++ )
		{
		if ( *Text == DELIMITER) ii++;
		if (ii >= 2 ) break;
		}

	Text = strtok(Text," ,')\n\r");
	for( ; Text != NULL; Text = strtok(NULL," ,')\n\r") )
		{
		if( strcmp(Text, "RIGHT" ) == 0 ) /* Rot 90 degre */
			{
			Rot[0][0] = 0;
			Rot[0][1] = Rot[1][0] = 1;
			Rot[1][1] = 0;
			continue;
			}

		if( strcmp(Text, "BOTTOM" ) == 0) /* Rot 180 degre */
			{
			Rot[0][0] = -1;
			Rot[0][1] = Rot[1][0] = 0;
			Rot[1][1] = 1;
			continue;
			}
 
		if( strcmp(Text, "LEFT" ) == 0) /* Rot 270 degre */
			{
			Rot[0][0] = 0;
			Rot[0][1] = Rot[1][0] = -1;
			Rot[1][1] = 0;
			continue;
			}
		}


	fprintf(FileOut,"$Comp\n");
	fprintf(FileOut,"L %s #%s?\n", Buff, Buff);

	fprintf(FileOut,"U %d %d %8.8lX\n", 1, 1, 0l);
	fprintf(FileOut,"P %d %d\n", ox, oy);

	fprintf(FileOut,"F 0 \"#%s?\" H %d %d %d 0000\n",
						Buff, ox, oy, TEXT_SIZE);

	fprintf(FileOut,"F 1 \"%s\" H %d %d %d 0000\n",
						Buff, ox, oy+50, TEXT_SIZE);

	fprintf(FileOut,"  1 %d %d\n", ox, oy);
	fprintf(FileOut,"    %d %d %d %d\n",
					Rot[0][0], Rot[0][1], Rot[1][0], Rot[1][1]);
	fprintf(FileOut,"$EndComp\n");
}


/****************************************************************************/
/* void ReadSdtPart(File * FileIn, FILE *FileOut, char *Line, int *LineNum) */
/****************************************************************************/
/* Lit la sequence :
PART(3.60, 4.50, '0000000000000000A926B6F1', '74LS688', NORMAL, 
	REF(VISIBLE, 0.00, 0.00, 'U2'), 
	VALUE(VISIBLE, 0.00, 0.00, '74LS688'), 
	DEVICE(1, 0)
*/
static void ReadSdtPart(FILE * FileIn, FILE *FileOut, char *Line, int *LineNum)
{
int ii, end = 0, ox, oy, Rot90 = 0;
int PosX, PosY;
int Rot[2][2];

int NameX, NameY, ValX, ValY, Unit, IsMulti, Convert;
float ofx, ofy;
char Buff[256], LibName[256], Name[256], Val[256], *Text, * PLine;
long TimeStamp;

	Text = Line+5;	/* Pointe 1ere coord */
	sscanf(Text,"%f, %f", &ofx, &ofy);

	PosX = CVUNIT(ofx);
	PosY = CVUNIT(ofy);

	ReadDelimitedText( Buff, Text, 256 );	/* Pointe texte TimeStamp*/
	sscanf(Buff,"%lX", &TimeStamp);

	/* Recherche nom lib */
	*LibName = 0;
	for (ii = 0; *Text != 0; Text++ )
		{
		if ( *Text == DELIMITER) ii++;
		if (ii >= 3 ) break;
		}
	ReadDelimitedText( LibName, Text , 256);/* Pointe Nom lib*/

	/* Recherche autres parametres (orientation, convert..) : */
	Rot[0][0] = 1;
	Rot[0][1] = Rot[1][0] = 0;
	Rot[1][1] = -1; /* Orient NORMAL */
	Convert = 1;

	for ( ii = 0; *Text != 0; Text++ )
		{
		if ( *Text == DELIMITER) ii++;
		if (ii >= 1 ) break;
		}

	Text = strtok(Text," ,'\n\r");
	for( ; Text != NULL; Text = strtok(NULL," ,'\n\r") )
		{
		if( strcmp(Text, "DOWN" ) == 0 ) /* Rot 90 degre */
			{
			Rot[0][0] = 0;
			Rot[0][1] = Rot[1][0] = 1;
			Rot[1][1] = 0;
			Rot90 = 1;
			continue;
			}

		if( strcmp(Text, "OVER" ) == 0) /* Rot 180 degre */
			{
			Rot[0][0] = -1;
			Rot[0][1] = Rot[1][0] = 0;
			Rot[1][1] = 1;
			continue;
			}
 
		if( strcmp(Text, "UP" ) == 0) /* Rot 270 degre */
			{
			Rot[0][0] = 0;
			Rot[0][1] = Rot[1][0] = -1;
			Rot[1][1] = 0;
			Rot90 = 1;
			continue;
			}

		if( Text && (strcmp(Text, "MIRROR") == 0) ) /* Mirroir / axe Y */
			{
			int TempR, TempMat[2][2];
			TempMat[0][0] = -1;
			TempMat[1][1] = 1;
			TempMat[0][1] = TempMat[1][0] = 0;

			 TempR = Rot[0][0] * TempMat[0][0] +
							Rot[0][1] * TempMat[1][0];
			 Rot[0][1] = Rot[0][0] * TempMat[0][1] +
								Rot[0][1] * TempMat[1][1];
			 Rot[0][0] = TempR;
			 TempR = Rot[1][0] * TempMat[0][0] +
						Rot[1][1] * TempMat[1][0];
			 Rot[1][1] = Rot[1][0] * TempMat[0][1] +
								Rot[1][1] * TempMat[1][1];
			 Rot[1][0] = TempR;
			continue;
			}
		if( strcmp(Text, "CONVERT" ) == 0)
			{
			Convert = 2;
			continue;
			}
		}

	/* Init des parametres par defaut */
	strcpy(Val,LibName);
	sprintf(Name,"#%s",LibName);
	NameX = NameY = ValX = ValY = 0;

	for( ; end == 0; )
		{
		if( GetLine( FileIn,Line, LineNum, 1024) == NULL )
			{
			Line[0] = DELIMITER;
			end = 1; continue;
			}

		PLine = StrPurge(Line);		

		if( strnicmp(PLine,")", 1) == 0 )
			{
			end = 1; continue;
			}

		if( strnicmp(PLine,"REF", 3) == 0 )
			{
			ofx = ofy = 0.0;
			Text = PLine+4;
			sscanf(Text,"%f, %f", &ofx, &ofy);
			NameX = CVUNIT(ofx);
			NameY = CVUNIT(ofy);

			ReadDelimitedText(Name, Text, 256);
			continue;
			}

		if( strnicmp(PLine,"VALUE", 5) == 0 )
			{
			ofx = ofy = 0.0;
			Text = PLine+6;
			sscanf(Text,"%f, %f", &ofx, &ofy);
			ValX = CVUNIT(ofx);
			ValY = CVUNIT(ofy);

			ReadDelimitedText(Val, Text, 256);
			}

		if( strnicmp(PLine,"DEVICE", 6) == 0 )
			{
			sscanf(PLine+7,"%d, %d", &Unit, &IsMulti);
			continue;
			}
		}

	if ( IsMulti )
		{
		ii = strlen(Name) - 1; Name[ii] = 0;
		}

	/* Rectification de la position */
	if( ReturnDimCmp(&ox, &oy, LibName ) )
		{
		if( Rot90 == 0 )
			{
			PosX += ox/2; PosY += oy/2;
			}
		else
			{
			PosX += oy/2; PosY += ox/2;
			}
		}

	
	ChangeSpaces(LibName, '_');
	ChangeSpaces(Name, '_');
	ChangeSpaces(Val, '_');

	fprintf(FileOut,"$Comp\n");
	fprintf(FileOut,"L %s %s\n", LibName, Name);
	fprintf(FileOut,"U %d %d %8.8lX\n", Unit, Convert, TimeStamp);
	fprintf(FileOut,"P %d %d\n", PosX, PosY);

	NameX += PosX;
	NameY += PosY + 100;
	fprintf(FileOut,"F 0 \"%s\" %c %d %d %d 0000\n",
						Name, 'H', NameX, NameY, TEXT_SIZE);

	ValX += PosX;
	ValY += PosY - 100;
	fprintf(FileOut,"F 1 \"%s\" %c %d %d %d 0000\n",
						Val, 'H', ValX, ValY, TEXT_SIZE);
   
	fprintf(FileOut,"    %d %d %d\n", Unit, PosX, PosY);
	fprintf(FileOut,"    %d %d %d %d\n",
					Rot[0][0], Rot[0][1], Rot[1][0], Rot[1][1]);
   
	fprintf(FileOut,"$EndComp\n");
}


	/*********************************************************/
	/* void * ReturnDimCmp(int * cx, int * cy, char * Name ) */
	/*********************************************************/

/* Lit le fichier librairie et retourne les dims du composant de nom Name
*/
int ReturnDimCmp(int * cx, int * cy, char * Name )
{
char FullName[256];
char Line[1024], Buff[1024], *Text, *Dest;

	if( FileSdtLib == NULL ) return(0);

	*cx = *cy = 0;
	sprintf(FullName,"'%s'",Name);

	fseek(FileSdtLib, 0l, 0);
	while ( GetLine(FileSdtLib,Line,NULL, 1024) )
		{
		StrPurge(Line);
		if ( stricmp(Line,FullName) != 0 ) continue;
		/* Nom trouve */
		while ( GetLine(FileSdtLib,Line,NULL, 1024) )
			{
			if ( Line[0] == '\'' ) continue;
			if ( strnicmp(Line,"REFERENCE",5) == 0 ) continue;
			if ( strnicmp(Line," SheetPath",5) == 0 ) continue;
			Text = StrPurge(Line);
			/* Suppression des commentaires */
			for ( Dest = Buff; *Text != 0; Text ++, Dest++ )
				{
				if ( *Text == '{' )	while ( *(Text++) != '}' );
				*Dest = *Text;
				}
			*Dest = 0;
			sscanf(Buff,"%d %d", cx, cy );
			*cx *= 100; *cy *= 100;
			return(1);
			}
		}
	printf( "\ncomp %s non trouve\n", Name );
	return (0);
}

	/***********************************************/
	/* void ChangeSpaces(char * Text, int NewChar) */
	/***********************************************/

/* Change dans un texte les espaces en NewChar */
static void ChangeSpaces(char * Text, int NewChar)
{
	while( *Text )
		{
		if( *Text == ' ') *Text = (char) NewChar;
		Text++;
		}
}

