/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.peer.ActiveEvent;

public class EventDispatchThread
extends Thread {
    private EventQueue theQueue;
    private EventPump pump = new EventPump();

    public EventDispatchThread(ThreadGroup threadGroup, String string) {
        super(threadGroup, string);
    }

    public void setEventQueue(EventQueue eventQueue) {
        this.theQueue = eventQueue;
    }

    public EventDispatchThread(String string, EventQueue eventQueue) {
        super(string);
        this.theQueue = eventQueue;
    }

    public void stopDispatching() {
        this.pump.stopDispatching();
    }

    public void run() {
        this.pump.dispatchEvents();
    }

    public class EventPump {
        private boolean doDispatch = true;

        public void dispatchEvents() {
            while (this.doDispatch) {
                try {
                    AWTEvent aWTEvent = EventDispatchThread.this.theQueue.getNextEvent();
                    Object object = aWTEvent.getSource();
                    if (aWTEvent instanceof ActiveEvent) {
                        ((ActiveEvent)((Object)aWTEvent)).dispatch();
                        continue;
                    }
                    if (object instanceof Component) {
                        ((Component)object).dispatchEvent(aWTEvent);
                        continue;
                    }
                    if (!(object instanceof MenuComponent)) continue;
                    ((MenuComponent)object).dispatchEvent(aWTEvent);
                }
                catch (ThreadDeath threadDeath) {
                    throw (ThreadDeath)threadDeath.fillInStackTrace();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        public void stopDispatching() {
            this.doDispatch = false;
        }

        public EventPump() {
            EventDispatchThread.this = EventDispatchThread.this;
        }
    }
}

