/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTError;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPaneAdjustable;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ScrollPanePeer;
import java.io.Serializable;

public class ScrollPane
extends Container {
    public static final int SCROLLBARS_AS_NEEDED = 0;
    public static final int SCROLLBARS_ALWAYS = 1;
    public static final int SCROLLBARS_NEVER = 2;
    private int scrollbarDisplayPolicy;
    private ScrollPaneAdjustable vAdjustable;
    private ScrollPaneAdjustable hAdjustable;
    private static final String base = "scrollpane";
    private static int nameCounter;
    private static final long serialVersionUID = 7956609840827222915L;

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(int n) {
        this.name = base + nameCounter++;
        this.layoutMgr = null;
        this.width = 100;
        this.height = 100;
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.scrollbarDisplayPolicy = n;
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal scrollbar display policy");
            }
        }
        this.vAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this), 1);
        this.hAdjustable = new ScrollPaneAdjustable(this, new PeerFixer(this), 0);
    }

    protected final void addImpl(Component component, Object object, int n) {
        Object object2 = Component.LOCK;
        synchronized (object2) {
            if (this.getComponentCount() > 0) {
                this.remove(0);
            }
            if (n > 0) {
                throw new IllegalArgumentException("position greater than 0");
            }
            super.addImpl(component, object, n);
            return;
        }
    }

    public int getScrollbarDisplayPolicy() {
        return this.scrollbarDisplayPolicy;
    }

    public Dimension getViewportSize() {
        Insets insets = this.getInsets();
        return new Dimension(this.width - insets.right - insets.left, this.height - insets.top - insets.bottom);
    }

    public int getHScrollbarHeight() {
        ScrollPanePeer scrollPanePeer;
        int n = 0;
        if (this.scrollbarDisplayPolicy != 2 && (scrollPanePeer = (ScrollPanePeer)this.peer) != null) {
            n = scrollPanePeer.getHScrollbarHeight();
        }
        return n;
    }

    public int getVScrollbarWidth() {
        ScrollPanePeer scrollPanePeer;
        int n = 0;
        if (this.scrollbarDisplayPolicy != 2 && (scrollPanePeer = (ScrollPanePeer)this.peer) != null) {
            n = scrollPanePeer.getVScrollbarWidth();
        }
        return n;
    }

    public Adjustable getVAdjustable() {
        return this.vAdjustable;
    }

    public Adjustable getHAdjustable() {
        return this.hAdjustable;
    }

    public void setScrollPosition(int n, int n2) {
        Object object = Component.LOCK;
        synchronized (object) {
            if (this.ncomponents <= 0) {
                throw new NullPointerException("child is null");
            }
            this.hAdjustable.setValue(n);
            this.vAdjustable.setValue(n2);
            return;
        }
    }

    public void setScrollPosition(Point point) {
        this.setScrollPosition(point.x, point.y);
    }

    public Point getScrollPosition() {
        if (this.ncomponents <= 0) {
            throw new NullPointerException("child is null");
        }
        return new Point(this.hAdjustable.getValue(), this.vAdjustable.getValue());
    }

    public final void setLayout(LayoutManager layoutManager) {
        throw new AWTError("ScrollPane controls layout");
    }

    public void doLayout() {
        this.layout();
    }

    Dimension calculateChildSize() {
        boolean bl;
        Component component = this.getComponent(0);
        Dimension dimension = new Dimension(component.getPreferredSize());
        Dimension dimension2 = this.getSize();
        int n = this.getVScrollbarWidth();
        int n2 = this.getHScrollbarHeight();
        Insets insets = this.getInsets();
        boolean bl2 = insets.left + insets.right >= n;
        boolean bl3 = insets.top + insets.bottom >= n2;
        int n3 = dimension2.width - (insets.left + insets.right) - (bl2 ? 0 : n);
        int n4 = dimension2.height - (insets.top + insets.bottom) - (bl3 ? 0 : n2);
        boolean bl4 = dimension.width > n3;
        boolean bl5 = bl = dimension.height > n4;
        if (dimension.width < n3) {
            dimension.width = n3 + (bl ? 0 : n);
        }
        if (dimension.height < n4) {
            dimension.height = n4 + (bl4 ? 0 : n2);
        }
        return dimension;
    }

    public void layout() {
        if (this.ncomponents > 0) {
            Component component = this.getComponent(0);
            Point point = component.getLocation();
            Dimension dimension = this.calculateChildSize();
            Dimension dimension2 = this.getViewportSize();
            int n = dimension.width > dimension2.width ? Math.min(-point.x, dimension.width - dimension2.width) : -point.x;
            int n2 = dimension.height > dimension2.height ? Math.min(-point.y, dimension.height - dimension2.height) : -point.y;
            component.reshape(-n, -n2, dimension.width, dimension.height);
            ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.peer;
            if (scrollPanePeer != null) {
                scrollPanePeer.childResized(dimension.width, dimension.height);
            }
            dimension2 = this.getViewportSize();
            this.hAdjustable.setSpan(0, dimension.width, dimension2.width);
            this.vAdjustable.setSpan(0, dimension.height, dimension2.height);
        }
    }

    public void printComponents(Graphics graphics) {
        if (this.ncomponents > 0) {
            Component component = this.component[0];
            Point point = component.getLocation();
            Dimension dimension = this.getViewportSize();
            Graphics graphics2 = graphics.create();
            try {
                graphics2.translate(point.x, point.y);
                graphics2.clipRect(-point.x, -point.y, dimension.width, dimension.height);
                component.printAll(graphics2);
                return;
            }
            finally {
                Object var7_6 = null;
                graphics2.dispose();
            }
        }
    }

    public void addNotify() {
        this.peer = this.getToolkit().createScrollPane(this);
        super.addNotify();
        if (this.getComponentCount() > 0) {
            Component component = this.getComponent(0);
            if (component.peer instanceof LightweightPeer) {
                Object object = Component.LOCK;
                synchronized (object) {
                    this.remove(0);
                    Panel panel = new Panel();
                    panel.setLayout(new BorderLayout());
                    panel.add(component);
                    this.add(panel);
                    return;
                }
            }
        }
    }

    public String paramString() {
        String string;
        switch (this.scrollbarDisplayPolicy) {
            case 0: {
                string = "as-needed";
                break;
            }
            case 1: {
                string = "always";
                break;
            }
            case 2: {
                string = "never";
                break;
            }
            default: {
                string = "invalid display policy";
            }
        }
        Point point = this.ncomponents > 0 ? this.getScrollPosition() : new Point(0, 0);
        Insets insets = this.getInsets();
        return String.valueOf(super.paramString()) + ",ScrollPosition=(" + point.x + "," + point.y + ")" + ",Insets=(" + insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right + ")" + ",ScrollbarDisplayPolicy=" + string;
    }

    class PeerFixer
    implements AdjustmentListener,
    Serializable {
        private ScrollPane scroller;

        PeerFixer(ScrollPane scrollPane2) {
            ScrollPane.this = ScrollPane.this;
            this.scroller = scrollPane2;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Adjustable adjustable = adjustmentEvent.getAdjustable();
            int n = adjustmentEvent.getValue();
            ScrollPanePeer scrollPanePeer = (ScrollPanePeer)this.scroller.peer;
            if (scrollPanePeer != null) {
                scrollPanePeer.setValue(adjustable, n);
            }
            Component component = this.scroller.getComponent(0);
            switch (adjustable.getOrientation()) {
                case 1: {
                    component.move(component.getLocation().x, -n);
                    return;
                }
                case 0: {
                    component.move(-n, component.getLocation().y);
                    return;
                }
            }
            throw new IllegalArgumentException("Illegal adjustable orientation");
        }
    }
}

