/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.resources.LocaleData;
import java.util.Locale;
import java.util.ResourceBundle;

public abstract class NumberFormat
extends Format
implements Cloneable {
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static final int NUMBERSTYLE = 0;
    private static final int CURRENCYSTYLE = 1;
    private static final int PERCENTSTYLE = 2;
    private boolean groupingUsed = true;
    private byte maxIntegerDigits = (byte)40;
    private byte minIntegerDigits = 1;
    private byte maxFractionDigits = (byte)3;
    private byte minFractionDigits;
    private boolean parseIntegerOnly = false;

    public final StringBuffer format(Object object, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        if (object instanceof Double || object instanceof Float) {
            return this.format(((Number)object).doubleValue(), stringBuffer, fieldPosition);
        }
        if (object instanceof Number) {
            return this.format(((Number)object).longValue(), stringBuffer, fieldPosition);
        }
        throw new IllegalArgumentException("Cannot format given Object as a Number");
    }

    public final Object parseObject(String string, ParsePosition parsePosition) {
        return this.parse(string, parsePosition);
    }

    public final String format(double d) {
        return this.format(d, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public final String format(long l) {
        return this.format(l, new StringBuffer(), new FieldPosition(0)).toString();
    }

    public abstract StringBuffer format(double var1, StringBuffer var3, FieldPosition var4);

    public abstract StringBuffer format(long var1, StringBuffer var3, FieldPosition var4);

    public abstract Number parse(String var1, ParsePosition var2);

    public Number parse(String string) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Number number = this.parse(string, parsePosition);
        if (parsePosition.index == 0) {
            throw new ParseException("Unparseable number: \"" + string + "\"", 0);
        }
        return number;
    }

    public boolean isParseIntegerOnly() {
        return this.parseIntegerOnly;
    }

    public void setParseIntegerOnly(boolean bl) {
        this.parseIntegerOnly = bl;
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 0);
    }

    public static NumberFormat getInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 0);
    }

    public static NumberFormat getNumberInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 0);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 1);
    }

    public static NumberFormat getCurrencyInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 1);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getInstance(Locale.getDefault(), 2);
    }

    public static NumberFormat getPercentInstance(Locale locale) {
        return NumberFormat.getInstance(locale, 2);
    }

    public static Locale[] getAvailableLocales() {
        return LocaleData.getAvailableLocales("NumberPatterns");
    }

    public int hashCode() {
        return this.maxIntegerDigits * 37 + this.maxFractionDigits;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NumberFormat numberFormat = (NumberFormat)object;
        return this.maxIntegerDigits == numberFormat.maxIntegerDigits && this.minIntegerDigits == numberFormat.minIntegerDigits && this.maxFractionDigits == numberFormat.maxFractionDigits && this.minFractionDigits == numberFormat.minFractionDigits && this.parseIntegerOnly == numberFormat.parseIntegerOnly;
    }

    public Object clone() {
        NumberFormat numberFormat = (NumberFormat)super.clone();
        return numberFormat;
    }

    public boolean isGroupingUsed() {
        return this.groupingUsed;
    }

    public void setGroupingUsed(boolean bl) {
        this.groupingUsed = bl;
    }

    public int getMaximumIntegerDigits() {
        return this.maxIntegerDigits;
    }

    public void setMaximumIntegerDigits(int n) {
        this.maxIntegerDigits = (byte)Math.max(0, Math.min(n, 127));
        if (this.minIntegerDigits > this.maxIntegerDigits) {
            this.minIntegerDigits = this.maxIntegerDigits;
        }
    }

    public int getMinimumIntegerDigits() {
        return this.minIntegerDigits;
    }

    public void setMinimumIntegerDigits(int n) {
        this.minIntegerDigits = (byte)Math.max(0, Math.min(n, 127));
        if (this.minIntegerDigits > this.maxIntegerDigits) {
            this.maxIntegerDigits = this.minIntegerDigits;
        }
    }

    public int getMaximumFractionDigits() {
        return this.maxFractionDigits;
    }

    public void setMaximumFractionDigits(int n) {
        this.maxFractionDigits = (byte)Math.max(0, Math.min(n, 127));
        if (this.maxFractionDigits < this.minFractionDigits) {
            this.minFractionDigits = this.maxFractionDigits;
        }
    }

    public int getMinimumFractionDigits() {
        return this.minFractionDigits;
    }

    public void setMinimumFractionDigits(int n) {
        this.minFractionDigits = (byte)Math.max(0, Math.min(n, 127));
        if (this.maxFractionDigits < this.minFractionDigits) {
            this.maxFractionDigits = this.minFractionDigits;
        }
    }

    private static NumberFormat getInstance(Locale locale, int n) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("java.text.resources.LocaleElements", locale);
        String[] stringArray = resourceBundle.getStringArray("NumberPatterns");
        return new DecimalFormat(stringArray[n], new DecimalFormatSymbols(locale));
    }
}

