/*
 * Decompiled with CFR 0.152.
 */
package netscape.applet;

import java.awt.Button;
import java.awt.Event;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.TextArea;
import java.io.File;
import java.io.IOException;
import netscape.applet.AppletClassLoader;
import netscape.applet.Console;
import netscape.applet.HorizontalRule;
import netscape.applet.MozillaAppletContext;
import netscape.debug.Debugger;

class ConsoleFrame
extends Frame {
    Console console;
    TextArea text;
    Button reset;
    Button hide;

    ConsoleFrame(Console console) {
        this.console = console;
        this.setTitle("Java Console");
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        this.text = new TextArea(20, 60);
        this.text.setEditable(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.text, gridBagConstraints);
        this.add(this.text);
        HorizontalRule horizontalRule = new HorizontalRule();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.insets = new Insets(1, 1, 0, 0);
        gridBagConstraints2.gridwidth = 0;
        gridBagLayout.setConstraints(horizontalRule, gridBagConstraints2);
        this.add(horizontalRule);
        this.reset = new Button("Clear");
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.insets = new Insets(4, 0, 2, 4);
        gridBagConstraints3.anchor = 13;
        gridBagLayout.setConstraints(this.reset, gridBagConstraints3);
        this.add(this.reset);
        this.hide = new Button("Close");
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(4, 0, 2, 4);
        gridBagConstraints4.anchor = 13;
        gridBagLayout.setConstraints(this.hide, gridBagConstraints4);
        this.add(this.hide);
        this.pack();
    }

    public boolean handleEvent(Event event) {
        if (event.id == 201 || event.target == this.hide && event.id == 1001) {
            this.console.hide();
            return true;
        }
        if (event.target == this.reset && event.id == 1001) {
            this.console.reset();
            return true;
        }
        return super.handleEvent(event);
    }

    String getFileFullPath(String string) {
        try {
            File file = new File(".", string);
            SecurityManager.enablePrivilege("UniversalFileRead");
            SecurityManager.enablePrivilege("UniversalPropertyRead");
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return string;
        }
    }

    public boolean keyDown(Event event, int n) {
        if (n >= 48 && n <= 57) {
            MozillaAppletContext.debug = n - 48;
            System.err.println("# Applet debug level set to " + MozillaAppletContext.debug);
            return true;
        }
        if (n == 98 || n == 66) {
            System.err.println("# Breaking into debugger.");
            Debugger.debugBreak();
            return true;
        }
        if (n == 100 || n == 68) {
            MozillaAppletContext.dumpState(System.err);
            return true;
        }
        if (n == 119 || n == 87) {
            System.err.print("# Dumping application heaps...");
            Console.dumpApplicationHeaps();
            System.err.println("done.");
            return true;
        }
        if (n == 103 || n == 71) {
            System.err.println("# Performing a garbage collection...");
            System.gc();
            this.printMemoryStats("GC complete: memory");
            return true;
        }
        if (n == 102 || n == 70) {
            System.err.println("# Performing finalization...");
            System.runFinalization();
            this.printMemoryStats("Finalization complete: memory");
            return true;
        }
        if (n == 109 || n == 77) {
            this.printMemoryStats("Memory");
            return true;
        }
        if (n == 120) {
            String string = this.getFileFullPath("memory.out");
            System.err.print("# Dumping memory to '" + string + "'...");
            Console.dumpMemory(false);
            System.err.println("done.");
            return true;
        }
        if (n == 88) {
            String string = this.getFileFullPath("memory.out");
            System.err.print("# Dumping memory to '" + string + "'...");
            Console.dumpMemory(true);
            System.err.println("done.");
            return true;
        }
        if (n == 115 || n == 83) {
            String string = this.getFileFullPath("memory.out");
            System.err.print("# Dumping memory summary to '" + string + "'...");
            Console.dumpMemorySummary();
            System.err.println("done.");
            return true;
        }
        if (n == 116 || n == 84) {
            String string = this.getFileFullPath("memory.out");
            System.err.print("# Dumping thread info to '" + string + "'...");
            Console.dumpNSPRInfo();
            System.err.println("done.");
            return true;
        }
        if (n == 107 || n == 75) {
            System.err.print("# Checkpointing memory...");
            Console.checkpointMemory();
            System.err.println("done.");
            return true;
        }
        if (n == 99 || n == 67) {
            this.reset();
            return true;
        }
        if (n == 113 || n == 81) {
            this.console.hide();
            return true;
        }
        if (n == 104 || n == 72 || n == 63 || n == 32) {
            this.printConsoleHelp();
            return true;
        }
        if (n == 119 || n == 87) {
            System.err.print("# Dumping application heaps...");
            Console.dumpApplicationHeaps();
            System.err.println("done.");
            return true;
        }
        if (n == 108 || n == 76) {
            boolean bl = !AppletClassLoader.getCaptureClassFiles();
            AppletClassLoader.setCaptureClassFiles(bl);
            System.err.println("# Class file capture " + (bl ? "enabled" : "disabled"));
            return true;
        }
        return super.keyDown(event, n);
    }

    void printMemoryStats(String string) {
        Runtime runtime = Runtime.getRuntime();
        System.err.println("# " + string + ": " + runtime.totalMemory() + " free: " + runtime.freeMemory() + " (" + runtime.freeMemory() * 100L / runtime.totalMemory() + "%)");
    }

    void printConsoleHelp() {
        System.out.println("Netscape Java Console Commands:");
        System.out.println("  b:   break into the debugger (Windows only)");
        System.out.println("  c:   clear console window");
        System.out.println("  d:   dump applet context state to console");
        System.out.println("  f:   finalize objects on finalization queue");
        System.out.println("  g:   garbage collect");
        System.out.println("  h:   print this help message");
        System.out.println("  l:   capture all classes loaded by an applet to a directory");
        System.out.println("  m:   print current memory use to console");
        System.out.println("  q:   hide console");
        System.out.println("  s:   dump memory summary to \"memory.out\"");
        System.out.println("  t:   dump thread info to \"memory.out\"");
        System.out.println("  x:   dump memory to \"memory.out\"");
        System.out.println("  X:   dump memory (detailed) to \"memory.out\"");
        System.out.println("  0-9: set applet debug level to <n>");
        System.out.println();
    }

    void reset() {
        this.text.setText("");
    }
}

