/*
 * Decompiled with CFR 0.152.
 */
package netscape.plugin.composer;

import java.io.File;
import java.io.IOException;
import java.io.StringBufferInputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.plugin.composer.Composer;
import netscape.plugin.composer.ComposerDocument;
import netscape.plugin.composer.Factory;
import netscape.plugin.composer.GroupPlugin;
import netscape.plugin.composer.ImageEncoder;
import netscape.plugin.composer.ImageEncoderFactory;
import netscape.plugin.composer.ImageEncoderPlugin;
import netscape.plugin.composer.Plugin;
import netscape.plugin.composer.PluginKiller;
import netscape.plugin.composer.PluginRunner;
import netscape.plugin.composer.SortedStringTable;

class PluginManager {
    private SortedStringTable categories = new SortedStringTable();
    private SortedStringTable encoders = new SortedStringTable();
    private SortedStringTable events = new SortedStringTable();
    private Hashtable pluginThreads = new Hashtable();
    private PluginKiller pluginKiller = new PluginKiller();

    public void registerPlugin(String string, String string2) {
        Properties properties = new Properties();
        File file = new File(string);
        try {
            StringBufferInputStream stringBufferInputStream = new StringBufferInputStream(string2);
            properties.load(stringBufferInputStream);
            stringBufferInputStream.close();
        }
        catch (IOException iOException) {
            System.err.println("Caught exception while parsing .ini contents:\n" + string2);
            iOException.printStackTrace();
        }
        this.registerPlugins(file, properties);
        this.registerEncoders(file, properties);
        this.registerEvents(properties);
    }

    public void registerPlugins(File file, Properties properties) {
        Enumeration enumeration = null;
        String string = null;
        try {
            string = PluginManager.trimWhitespace(properties.getProperty("netscape.plugin.composer.Factory", "netscape.plugin.composer.Factory"));
            Factory factory = (Factory)Class.forName(string).newInstance();
            enumeration = factory.getPlugins(file, properties);
        }
        catch (Throwable throwable) {
            System.err.println("Caught exception while instantiating " + string);
            throwable.printStackTrace();
        }
        PluginManager.registerPlugins(this.categories, enumeration);
    }

    public static Enumeration instantiateClassList(String string) {
        Vector vector = new Vector();
        if (string != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = PluginManager.trimWhitespace(stringTokenizer.nextToken());
                try {
                    Object object = Class.forName(string2).newInstance();
                    vector.addElement(object);
                }
                catch (Throwable throwable) {
                    System.err.println("Caught exception while instantiating " + string2);
                    throwable.printStackTrace();
                }
            }
        }
        return vector.elements();
    }

    protected void registerEvents(Properties properties) {
        String string = properties.getProperty("netscape.plugin.composer.eventHandlers", "");
        PluginManager.registerPlugins(this.events, string);
    }

    protected static void registerPlugins(SortedStringTable sortedStringTable, String string) {
        PluginManager.registerPlugins(sortedStringTable, PluginManager.instantiateClassList(string));
    }

    protected static void registerPlugins(SortedStringTable sortedStringTable, Enumeration enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Plugin plugin = (Plugin)enumeration.nextElement();
                if (plugin == null) continue;
                try {
                    sortedStringTable.getOrCreateTable(plugin.getCategory()).put(plugin.getName(), plugin);
                }
                catch (Throwable throwable) {
                    System.err.println("Trouble registering plugin:" + plugin);
                    throwable.printStackTrace();
                }
            }
        }
    }

    public static String trimWhitespace(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (!Character.isSpace(c)) {
                stringBuffer.append(c);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public void registerEncoders(File file, Properties properties) {
        Object object;
        Enumeration enumeration = null;
        String string = null;
        try {
            string = PluginManager.trimWhitespace(properties.getProperty("netscape.plugin.composer.ImageEncoderFactory", "netscape.plugin.composer.ImageEncoderFactory"));
            object = (ImageEncoderFactory)Class.forName(string).newInstance();
            enumeration = ((ImageEncoderFactory)object).getImageEncoders(file, properties);
        }
        catch (Throwable throwable) {
            System.err.println("Caught exception while instantiating " + string);
            throwable.printStackTrace();
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = null;
                try {
                    object = enumeration.nextElement();
                    ImageEncoder imageEncoder = (ImageEncoder)object;
                    this.registerEncoderInstance(imageEncoder);
                }
                catch (Throwable throwable) {
                    System.err.println("Caught exception while processing " + object);
                    throwable.printStackTrace();
                }
            }
        }
    }

    private void registerEncoderInstance(ImageEncoder imageEncoder) {
        ImageEncoder.register(imageEncoder);
        String string = imageEncoder.getName();
        this.encoders.put(string, imageEncoder);
    }

    public int getNumberOfCategories() {
        return this.categories.length();
    }

    public int getNumberOfPlugins(int n) {
        SortedStringTable sortedStringTable = (SortedStringTable)this.categories.get(n);
        if (sortedStringTable == null) {
            return 0;
        }
        return sortedStringTable.length();
    }

    public String getCategoryName(int n) {
        return this.categories.getKey(n);
    }

    public String getPluginName(int n, int n2) {
        return this.getPlugin(n, n2).getName();
    }

    public String getPluginHint(int n, int n2) {
        return this.getPlugin(n, n2).getHint();
    }

    public boolean performPlugin(Composer composer, int n, int n2, String string, String string2, String string3, String string4) {
        return this.performPlugin2(composer, this.getPlugin(n, n2), string, string2, string3, string4, null, null);
    }

    public boolean performPluginByName(Composer composer, String string, String string2, String string3, String string4, String string5) {
        Plugin plugin = null;
        String string6 = null;
        String string7 = null;
        try {
            int n = string.indexOf(58);
            if (n >= 0) {
                SortedStringTable sortedStringTable;
                string7 = string.substring(0, n);
                string6 = string.substring(n + 1);
                if (string6.length() == 0) {
                    string6 = null;
                }
                if ((sortedStringTable = this.events) != null) {
                    plugin = new GroupPlugin(sortedStringTable);
                }
            } else {
                plugin = (Plugin)Class.forName(string).newInstance();
            }
            if (plugin != null) {
                return this.performPlugin2(composer, plugin, string2, string3, string4, string5, string7, string6);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return false;
    }

    public boolean performPlugin2(Composer composer, Plugin plugin, String string, String string2, String string3, String string4, String string5, String string6) {
        if (plugin != null) {
            try {
                Object object;
                Object object2;
                URL uRL = string2 != null ? new URL(string2) : null;
                URL uRL2 = null;
                URL uRL3 = null;
                if (string4 != null) {
                    object2 = "/";
                    if (!string4.endsWith((String)object2)) {
                        string4 = String.valueOf(string4) + (String)object2;
                    }
                    uRL2 = string4.indexOf((String)(object = "file:")) == 0 ? new URL("file", "", string4.substring(((String)object).length())) : new URL(string4);
                }
                if (string6 != null) {
                    object2 = "file:";
                    uRL3 = string6.indexOf((String)object2) == 0 ? new URL("file", "", string6.substring(((String)object2).length())) : new URL(string6);
                }
                object2 = new ComposerDocument(composer, string, uRL, string3, uRL2, string5, uRL3);
                SecurityManager.enablePrivilege("SuperUser");
                object = new ThreadGroup(Thread.currentThread().getThreadGroup(), plugin.getName());
                Thread thread = new Thread((ThreadGroup)object, new PluginRunner(plugin, (ComposerDocument)object2, this), plugin.getName());
                thread.start();
                this.pluginThreads.put(composer, object);
            }
            catch (IOException iOException) {
                System.err.println("Composer plugin runner threw this exception:");
                iOException.printStackTrace();
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    public void stopPlugin(Composer composer) {
        this.killGroup(composer);
    }

    public int getNumberOfEncoders() {
        return this.encoders.length();
    }

    public String getEncoderName(int n) {
        return this.getEncoder(n).getName();
    }

    public String getEncoderFileType(int n) {
        byte[] byArray = new byte[4];
        this.getEncoder(n).getFileType(byArray);
        return new String(byArray, 0);
    }

    public boolean getEncoderNeedsQuantizedSource(int n) {
        return this.getEncoder(n).needsQuantizedSource();
    }

    public String getEncoderFileExtension(int n) {
        return this.getEncoder(n).getFileExtension();
    }

    public String getEncoderHint(int n) {
        return this.getEncoder(n).getHint();
    }

    protected ImageEncoder getEncoder(int n) {
        return (ImageEncoder)this.encoders.get(n);
    }

    public boolean startEncoder(Composer composer, int n, int n2, int n3, byte[][] byArray, String string) {
        ImageEncoderPlugin imageEncoderPlugin = new ImageEncoderPlugin(this.getEncoder(n), n2, n3, byArray, string);
        return this.performPlugin2(composer, imageEncoderPlugin, null, null, null, null, null, null);
    }

    protected Plugin getPlugin(int n, int n2) {
        Plugin plugin = null;
        SortedStringTable sortedStringTable = (SortedStringTable)this.categories.get(n);
        if (sortedStringTable != null) {
            plugin = (Plugin)sortedStringTable.get(n2);
        }
        return plugin;
    }

    void pluginFinished(Composer composer, int n, Object object) {
        composer.pluginFinished(n, object);
        this.killGroup(composer);
    }

    void killGroup(Composer composer) {
        ThreadGroup threadGroup = (ThreadGroup)this.pluginThreads.remove(composer);
        if (threadGroup != null) {
            this.pluginKiller.kill(threadGroup);
        }
    }
}

