/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.util.Hashtable;
import sun.awt.AWTFinalizeable;
import sun.awt.AWTFinalizer;
import sun.awt.image.Image;
import sun.awt.image.ImageWatched;
import sun.awt.image.InputStreamImageSource;

public class ImageRepresentation
extends ImageWatched
implements ImageConsumer,
AWTFinalizeable {
    int pData;
    InputStreamImageSource src;
    Image image;
    int tag;
    int srcW;
    int srcH;
    public int width;
    public int height;
    int hints;
    int availinfo;
    boolean offscreen;
    Rectangle newbits;
    private boolean consuming = false;
    private int numWaiters;
    AWTFinalizeable finalnext;

    public ImageRepresentation(Image image, int n, int n2, int n3) {
        this.image = image;
        this.tag = n3;
        if (n == 0 || n2 == 0) {
            throw new IllegalArgumentException();
        }
        if (n > 0) {
            this.width = n;
            this.availinfo |= 1;
        }
        if (n2 > 0) {
            this.height = n2;
            this.availinfo |= 2;
        }
        if (this.image.getSource() instanceof InputStreamImageSource) {
            this.src = (InputStreamImageSource)this.image.getSource();
        }
    }

    protected native void offscreenInit(Color var1);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void reconstruct(int n) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        int n2 = n & ~this.availinfo;
        if ((this.availinfo & 0x40) == 0 && n2 != 0) {
            ++this.numWaiters;
            try {
                this.startProduction();
                n2 = n & ~this.availinfo;
                while ((this.availinfo & 0x40) == 0 && n2 != 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        SecurityManager.enablePrivilege("UniversalThreadAccess");
                        Thread.currentThread().interrupt();
                        SecurityManager.revertPrivilege();
                        Object var4_3 = null;
                        this.decrementWaiters();
                        return;
                    }
                    n2 = n & ~this.availinfo;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.decrementWaiters();
                throw throwable;
            }
            Object var4_4 = null;
            this.decrementWaiters();
            return;
        }
    }

    public void setDimensions(int n, int n2) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setDimensions(n, n2);
        this.newInfo(this.image, 3, 0, 0, n, n2);
        this.srcW = n;
        this.srcH = n2;
        if ((this.availinfo & 1) == 0 && (this.availinfo & 2) == 0) {
            this.width = n;
            this.height = n2;
        } else if ((this.availinfo & 1) == 0) {
            this.width = n * this.height / n2;
        } else if ((this.availinfo & 2) == 0) {
            this.height = n2 * this.width / n;
        } else {
            return;
        }
        if (this.srcW <= 0 || this.srcH <= 0 || this.width <= 0 || this.height <= 0) {
            this.imageComplete(1);
            return;
        }
        this.availinfo |= 3;
    }

    public void setProperties(Hashtable hashtable) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.image.setProperties(hashtable);
        this.newInfo(this.image, 4, 0, 0, 0, 0);
    }

    public void setColorModel(ColorModel colorModel) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
    }

    public void setHints(int n) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        this.hints = n;
    }

    private native boolean setBytePixels(int var1, int var2, int var3, int var4, ColorModel var5, byte[] var6, int var7, int var8);

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, byte[] byArray, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        boolean bl = false;
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (this.newbits == null) {
                this.newbits = new Rectangle(0, 0, this.width, this.height);
            }
            if (this.setBytePixels(n, n2, n3, n4, colorModel, byArray, n5, n6)) {
                this.availinfo |= 8;
                bl = true;
            }
            n10 = this.newbits.x;
            n9 = this.newbits.y;
            n8 = this.newbits.width;
            n7 = this.newbits.height;
        }
        if (bl && !this.offscreen && (this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n10, n9, n8, n7);
        }
    }

    private native boolean setIntPixels(int var1, int var2, int var3, int var4, ColorModel var5, int[] var6, int var7, int var8);

    public void setPixels(int n, int n2, int n3, int n4, ColorModel colorModel, int[] nArray, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int n10;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        boolean bl = false;
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (this.newbits == null) {
                this.newbits = new Rectangle(0, 0, this.width, this.height);
            }
            if (this.setIntPixels(n, n2, n3, n4, colorModel, nArray, n5, n6)) {
                this.availinfo |= 8;
                bl = true;
            }
            n10 = this.newbits.x;
            n9 = this.newbits.y;
            n8 = this.newbits.width;
            n7 = this.newbits.height;
        }
        if (bl && !this.offscreen && (this.availinfo & 0x10) == 0) {
            this.newInfo(this.image, 8, n10, n9, n8, n7);
        }
    }

    private native boolean finish(boolean var1);

    public void imageComplete(int n) {
        int n2;
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        switch (n) {
            default: {
                bl = true;
                n2 = 128;
                break;
            }
            case 1: {
                this.image.addInfo(64);
                bl = true;
                n2 = 64;
                this.dispose();
                break;
            }
            case 3: {
                bl = true;
                n2 = 32;
                if (!this.finish(false)) break;
                this.image.getSource().requestTopDownLeftRightResend(this);
                this.finish(true);
                break;
            }
            case 2: {
                bl = false;
                n2 = 16;
            }
        }
        ImageRepresentation imageRepresentation = this;
        synchronized (imageRepresentation) {
            if (bl) {
                this.image.getSource().removeConsumer(this);
                this.consuming = false;
                this.newbits = null;
            }
            this.availinfo |= n2;
            this.notifyAll();
        }
        if (!this.offscreen) {
            this.newInfo(this.image, n2, 0, 0, this.width, this.height);
        }
        this.image.infoDone(n);
    }

    void startProduction() {
        if (!this.consuming) {
            this.consuming = true;
            this.image.getSource().startProduction(this);
        }
    }

    private synchronized void checkConsumption() {
        if (this.watchers == null && this.numWaiters == 0 && (this.availinfo & 0x20) == 0) {
            this.dispose();
        }
    }

    public synchronized void removeWatcher(ImageObserver imageObserver) {
        super.removeWatcher(imageObserver);
        this.checkConsumption();
    }

    private synchronized void decrementWaiters() {
        --this.numWaiters;
        this.checkConsumption();
    }

    public boolean prepare(ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = bl = (this.availinfo & 0x20) != 0;
        if (!bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            bl = (this.availinfo & 0x20) != 0;
        }
        return bl;
    }

    public int check(ImageObserver imageObserver) {
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x60) == 0) {
            this.addWatcher(imageObserver);
        }
        return this.availinfo;
    }

    synchronized native void imageDraw(Graphics var1, int var2, int var3, Color var4);

    synchronized native void imageStretch(Graphics var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10);

    public boolean drawImage(Graphics graphics, int n, int n2, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = bl = (this.availinfo & 0x20) != 0;
        if (!bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            bl = (this.availinfo & 0x20) != 0;
        }
        this.imageDraw(graphics, n, n2, color);
        return bl;
    }

    public boolean drawStretchImage(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = bl = (this.availinfo & 0x20) != 0;
        if (!bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            bl = (this.availinfo & 0x20) != 0;
        }
        this.imageStretch(graphics, n, n2, n3, n4, n5, n6, n7, n8, color);
        return bl;
    }

    public boolean drawScaledImage(Graphics graphics, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        boolean bl;
        if (this.src != null) {
            this.src.checkSecurity(null, false);
        }
        if ((this.availinfo & 0x40) != 0) {
            if (imageObserver != null) {
                imageObserver.imageUpdate(this.image, 192, -1, -1, -1, -1);
            }
            return false;
        }
        boolean bl2 = bl = (this.availinfo & 0x20) != 0;
        if (!bl) {
            this.addWatcher(imageObserver);
            this.startProduction();
            boolean bl3 = bl = (this.availinfo & 0x20) != 0;
        }
        if ((~this.availinfo & 3) != 0) {
            return false;
        }
        if (n3 < 0) {
            if (n4 < 0) {
                n3 = this.width;
                n4 = this.height;
            } else {
                n3 = n4 * this.width / this.height;
            }
        } else if (n4 < 0) {
            n4 = n3 * this.height / this.width;
        }
        if (n3 == this.width && n4 == this.height) {
            this.imageDraw(graphics, n, n2, color);
        } else {
            this.imageStretch(graphics, n, n2, n + n3, n2 + n4, 0, 0, this.width, this.height, color);
        }
        return bl;
    }

    private native void disposeImage();

    synchronized void abort() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.disposeImage();
        this.newInfo(this.image, 128, -1, -1, -1, -1);
        this.availinfo &= 0xFFFFFF87;
    }

    synchronized void dispose() {
        this.image.getSource().removeConsumer(this);
        this.consuming = false;
        this.newbits = null;
        this.disposeImage();
        this.availinfo &= 0xFFFFFFC7;
    }

    public void finalize() {
        AWTFinalizer.addFinalizeable(this);
    }

    public void doFinalization() {
        this.disposeImage();
    }

    public void setNextFinalizeable(AWTFinalizeable aWTFinalizeable) {
        this.finalnext = aWTFinalizeable;
    }

    public AWTFinalizeable getNextFinalizeable() {
        return this.finalnext;
    }
}

