/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.macos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.peer.ComponentPeer;
import java.awt.peer.MenuComponentPeer;
import sun.awt.macos.ActionComponent;
import sun.awt.macos.InterfaceEvent;
import sun.awt.macos.MacintoshEvent;

public class InterfaceThread
implements Runnable {
    static Object mInterfaceQueueWaitObject = new Object();
    static Object mInterfaceQueueSyncObject = new Object();
    static Thread mInterfaceThread = null;

    public native void run();

    public void dispatchInterfaceEvent() {
        InterfaceEvent interfaceEvent;
        Object object;
        try {
            object = mInterfaceQueueWaitObject;
            synchronized (object) {
                if (InterfaceEvent.firstEvent() == null) {
                    mInterfaceQueueWaitObject.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {}
        object = mInterfaceQueueSyncObject;
        synchronized (object) {
            interfaceEvent = InterfaceEvent.firstEvent();
            if (interfaceEvent != null) {
                interfaceEvent.dequeue();
            }
        }
        if (interfaceEvent != null) {
            Component component = interfaceEvent.getComponent();
            switch (interfaceEvent.getType()) {
                case 1: {
                    object = component.size();
                    Graphics graphics = component.getGraphics();
                    graphics.setColor(component.getBackground());
                    graphics.fillRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
                    graphics.setColor(component.getForeground());
                    graphics.setFont(component.getFont());
                    component.paint(graphics);
                    return;
                }
                case 2: {
                    Graphics graphics = component.getGraphics();
                    graphics.clipRect(interfaceEvent.getX(), interfaceEvent.getY(), interfaceEvent.getWidth(), interfaceEvent.getHeight());
                    component.update(graphics);
                    return;
                }
                case 11: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 504, interfaceEvent.getX(), interfaceEvent.getY(), 0, interfaceEvent.getFlags(), null, 0));
                    return;
                }
                case 12: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 505, interfaceEvent.getX(), interfaceEvent.getY(), 0, interfaceEvent.getFlags(), null, 0));
                    return;
                }
                case 3: {
                    MacintoshEvent macintoshEvent = new MacintoshEvent(component, interfaceEvent.getWhen(), 501, interfaceEvent.getX(), interfaceEvent.getY(), 0, interfaceEvent.getFlags(), null, interfaceEvent.getEventNumber());
                    macintoshEvent.clickCount = interfaceEvent.getClickCount();
                    component.postEvent(macintoshEvent);
                    return;
                }
                case 4: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 502, interfaceEvent.getX(), interfaceEvent.getY(), 0, interfaceEvent.getFlags(), null, interfaceEvent.getEventNumber()));
                    return;
                }
                case 6: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 506, interfaceEvent.getX(), interfaceEvent.getY(), 0, interfaceEvent.getFlags(), null, 0));
                    return;
                }
                case 5: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 503, interfaceEvent.getX(), interfaceEvent.getY(), 0, interfaceEvent.getFlags(), null, 0));
                    return;
                }
                case 7: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 401, interfaceEvent.getX(), interfaceEvent.getY(), interfaceEvent.getKey(), interfaceEvent.getFlags(), null, interfaceEvent.getEventNumber()));
                    return;
                }
                case 8: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 402, interfaceEvent.getX(), interfaceEvent.getY(), interfaceEvent.getKey(), interfaceEvent.getFlags(), null, interfaceEvent.getEventNumber()));
                    return;
                }
                case 9: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 403, interfaceEvent.getX(), interfaceEvent.getY(), interfaceEvent.getKey(), interfaceEvent.getFlags(), null, interfaceEvent.getEventNumber()));
                    return;
                }
                case 10: {
                    component.postEvent(new MacintoshEvent(component, interfaceEvent.getWhen(), 404, interfaceEvent.getX(), interfaceEvent.getY(), interfaceEvent.getKey(), interfaceEvent.getFlags(), null, interfaceEvent.getEventNumber()));
                    return;
                }
                case 13: {
                    ComponentPeer componentPeer = component.getPeer();
                    ((ActionComponent)((Object)componentPeer)).action();
                    return;
                }
                case 14: {
                    ComponentPeer componentPeer = component.getPeer();
                    ((ActionComponent)((Object)componentPeer)).action(interfaceEvent.getActionState());
                    return;
                }
                case 15: {
                    ComponentPeer componentPeer = component.getPeer();
                    ((ActionComponent)((Object)componentPeer)).action(interfaceEvent.getFlags());
                    return;
                }
                case 16: {
                    MenuComponentPeer menuComponentPeer = interfaceEvent.getMenuComponent().getPeer();
                    ((ActionComponent)((Object)menuComponentPeer)).action(interfaceEvent.getFlags());
                    return;
                }
                case 17: {
                    component.postEvent(new Event(component, 701, new Integer(interfaceEvent.getFlags())));
                    return;
                }
                case 18: {
                    component.postEvent(new Event(component, 702, new Integer(interfaceEvent.getFlags())));
                    return;
                }
            }
        }
    }

    static void postInterfaceEvent(int n, Component component, MenuComponent menuComponent, int n2, int n3, int n4, int n5, long l, int n6, int n7, int n8, boolean bl, int n9) {
        if (mInterfaceThread == null) {
            mInterfaceThread = new Thread(new InterfaceThread(), "AWT Interface Thread");
            mInterfaceThread.start();
        }
        InterfaceEvent interfaceEvent = new InterfaceEvent(n, component, menuComponent, n2, n3, n4, n5, l, n6, n7, n8, bl, n9);
        Object object = mInterfaceQueueSyncObject;
        synchronized (object) {
            if (interfaceEvent.enqueue()) {
                Object object2 = mInterfaceQueueWaitObject;
                synchronized (object2) {
                    mInterfaceQueueWaitObject.notify();
                }
            }
            return;
        }
    }

    static void postInterfaceEvent(int n, Component component, int n2, int n3, int n4, int n5, long l, int n6, int n7, int n8, int n9) {
        InterfaceThread.postInterfaceEvent(n, component, null, n2, n3, n4, n5, l, n6, n7, n8, false, n9);
    }

    static void postInterfaceEvent(int n, Component component, int n2, int n3, int n4, int n5, long l, int n6, int n7) {
        InterfaceThread.postInterfaceEvent(n, component, null, n2, n3, n4, n5, l, n6, n7, 0, false, 0);
    }

    static void postInterfaceEvent(int n, Component component, int n2) {
        InterfaceThread.postInterfaceEvent(n, component, null, 0, 0, 0, 0, 0L, n2, 0, 0, false, 0);
    }

    static void postInterfaceEvent(Component component) {
        InterfaceThread.postInterfaceEvent(13, component, null, 0, 0, 0, 0, 0L, 0, 0, 0, false, 0);
    }

    static void postInterfaceEvent(Component component, int n) {
        InterfaceThread.postInterfaceEvent(15, component, null, 0, 0, 0, 0, 0L, n, 0, 0, false, 0);
    }

    static void postInterfaceEvent(Component component, boolean bl) {
        InterfaceThread.postInterfaceEvent(14, component, null, 0, 0, 0, 0, 0L, 0, 0, 0, bl, 0);
    }

    static void postInterfaceEvent(MenuComponent menuComponent, int n) {
        InterfaceThread.postInterfaceEvent(16, null, menuComponent, 0, 0, 0, 0, 0L, 0, n, 0, false, 0);
    }
}

