/*
 * Decompiled with CFR 0.152.
 */
package netscape.application;

import netscape.application.Color;
import netscape.application.Font;
import netscape.application.FontMetrics;
import netscape.application.Graphics;
import netscape.application.Rect;
import netscape.application.Size;
import netscape.application.Target;
import netscape.application.TextField;
import netscape.application.View;
import netscape.util.ClassInfo;
import netscape.util.Codable;
import netscape.util.CodingException;
import netscape.util.Decoder;
import netscape.util.Encoder;

public class Label
extends View
implements Target {
    TextField label = new TextField(0, 0, 0, 0);
    Target target;
    String command;
    Rect underlineRect;
    int key;
    static final String LABEL_KEY = "label";
    static final String TARGET_KEY = "target";
    static final String COMMAND_KEY = "command";
    static final String KEY_KEY = "labelKey";
    final int UNDERLINE_SIZE = 0;
    final String SEND_COMMAND = "sendCommand";

    public Label() {
        this("", null);
    }

    public Label(String string, Font font) {
        this.label.setBorder(null);
        this.label.setStringValue(string);
        this.label.setFont(font);
        this.label.setTransparent(true);
        this.label.setEditable(false);
        this.label.setSelectable(false);
        this.label.setJustification(2);
        this.addSubview(this.label);
        this.sizeToMinSize();
    }

    public void setJustification(int n) {
        this.label.setJustification(n);
    }

    public int justification() {
        return this.label.justification();
    }

    public void setTitle(String string) {
        this.label.setStringValue(string);
        this.invalidateUnderlineRect();
    }

    public String title() {
        return this.label.stringValue();
    }

    public void setFont(Font font) {
        this.label.setFont(font);
        this.invalidateUnderlineRect();
    }

    public Font font() {
        return this.label.font();
    }

    public Size minSize() {
        Font font = this.label.font();
        FontMetrics fontMetrics = font.fontMetrics();
        int n = fontMetrics.stringWidth(this.label.stringValue());
        int n2 = fontMetrics.stringHeight();
        return new Size(n, n2);
    }

    public void didSizeBy(int n, int n2) {
        super.didSizeBy(n, n2);
        this.invalidateUnderlineRect();
        this.label.setBounds(0, 0, this.width(), this.height());
    }

    public void setColor(Color color) {
        this.label.setTextColor(color);
    }

    public Color color() {
        return this.label.textColor();
    }

    public void setTarget(Target target) {
        this.target = target;
    }

    public Target target() {
        return this.target;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String command() {
        return this.command;
    }

    public void setCommandKey(int n) {
        this.key = n;
        this.invalidateUnderlineRect();
        this.removeAllCommandsForKeys();
        this.setCommandForKey("sendCommand", null, n, 0, 1);
        this.setCommandForKey("sendCommand", null, n, 2, 1);
        this.setDirty(true);
    }

    public int commandKey() {
        return this.key;
    }

    public boolean isTransparent() {
        return true;
    }

    public void performCommand(String string, Object object) {
        if ("sendCommand".equals(string)) {
            this.sendCommand();
        }
    }

    void invalidateUnderlineRect() {
        this.underlineRect = null;
    }

    public Rect underlineRect() {
        if (this.underlineRect == null) {
            if (this.key != 0) {
                String string = this.label.stringValue();
                int n = string.indexOf(this.key);
                if (n == -1 && (n = string.toUpperCase().indexOf(this.key)) == -1) {
                    n = string.toLowerCase().indexOf(this.key);
                }
                if (n != -1) {
                    Rect rect = this.label.rectForRange(n, n + 1);
                    this.underlineRect = new Rect();
                    this.label.convertRectToView(this, rect, this.underlineRect);
                    this.underlineRect.y = this.underlineRect.y + this.underlineRect.height - 1;
                    this.underlineRect.height = 1;
                }
            }
            if (this.underlineRect == null) {
                this.underlineRect = new Rect(0, 0, 0, 0);
            }
        }
        return this.underlineRect;
    }

    public void drawView(Graphics graphics) {
        Rect rect = this.underlineRect();
        if (rect != null && rect.intersects(graphics.clipRect())) {
            graphics.setColor(this.label.textColor());
            graphics.fillRect(this.underlineRect());
        }
    }

    void sendCommand() {
        if (this.target != null && this.command != null) {
            this.target.performCommand(this.command, this);
        }
    }

    public void describeClassInfo(ClassInfo classInfo) {
        super.describeClassInfo(classInfo);
        classInfo.addClass("netscape.application.Label", 1);
        classInfo.addField(LABEL_KEY, (byte)18);
        classInfo.addField(TARGET_KEY, (byte)18);
        classInfo.addField(COMMAND_KEY, (byte)16);
        classInfo.addField(KEY_KEY, (byte)8);
    }

    public void encode(Encoder encoder) throws CodingException {
        super.encode(encoder);
        encoder.encodeObject(LABEL_KEY, this.label);
        encoder.encodeObject(TARGET_KEY, (Codable)this.target);
        encoder.encodeString(COMMAND_KEY, this.command);
        encoder.encodeInt(KEY_KEY, this.key);
    }

    public void decode(Decoder decoder) throws CodingException {
        super.decode(decoder);
        this.label = (TextField)decoder.decodeObject(LABEL_KEY);
        this.target = (Target)decoder.decodeObject(TARGET_KEY);
        this.command = decoder.decodeString(COMMAND_KEY);
        this.key = decoder.decodeInt(KEY_KEY);
    }
}

