/*
 * Decompiled with CFR 0.152.
 */
package netscape.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import netscape.util.Archive;
import netscape.util.ClassInfo;
import netscape.util.ClassTable;
import netscape.util.CodingException;
import netscape.util.DeserializationException;
import netscape.util.Deserializer;
import netscape.util.Enumeration;
import netscape.util.FormattingSerializer;
import netscape.util.Hashtable;
import netscape.util.IdHashtable;
import netscape.util.InconsistencyException;
import netscape.util.Serializer;

class ASCIIArchiveLoader {
    static final String classTablesKey = "classTables";
    static final String fieldNamesKey = "fieldNames";
    static final String fieldTypesKey = "fieldTypes";
    static final String classNamesKey = "classNames";
    static final String classVersionsKey = "classVersions";
    static final String instancesKey = "instances";
    static final String rootInstancesKey = "rootInstances";
    static final String archiveVersionKey = "archiveVersion";
    Archive archive;
    Hashtable archiveDict;
    IdHashtable idForName;
    String[] nameForId;
    Hashtable baseNameForTable;
    static byte[] hexChar = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    ASCIIArchiveLoader(Archive archive) {
        this.archive = archive;
    }

    void readASCII(InputStream inputStream) throws CodingException, DeserializationException, IOException {
        Deserializer deserializer = null;
        if (inputStream instanceof Deserializer) {
            deserializer = (Deserializer)inputStream;
        }
        this.idForName = new IdHashtable(true);
        if (deserializer == null) {
            deserializer = new Deserializer(inputStream);
        }
        this.archiveDict = (Hashtable)deserializer.readObject();
        String string = (String)this.archiveDict.get((Object)archiveVersionKey);
        if (string == null) {
            throw new IOException("Missing archiveVersion");
        }
        this.archive.version = Integer.parseInt(string);
        if (this.archive.version != 1) {
            throw new IOException("Unknown archiveVersion " + this.archive.version);
        }
        this.loadClassInfo();
        this.loadInstanceData();
        this.loadRoots();
    }

    void loadClassInfo() throws CodingException {
        Hashtable hashtable = (Hashtable)this.archiveDict.get((Object)classTablesKey);
        if (hashtable == null) {
            return;
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Hashtable hashtable2 = (Hashtable)hashtable.get((Object)string);
            ClassInfo classInfo = new ClassInfo(string);
            Object[] objectArray = (Object[])hashtable2.get((Object)classNamesKey);
            Object[] objectArray2 = (Object[])hashtable2.get((Object)classVersionsKey);
            int n = 0;
            while (n < objectArray.length) {
                int n2 = Integer.parseInt((String)objectArray2[n]);
                classInfo.addClass((String)objectArray[n], n2);
                ++n;
            }
            Object[] objectArray3 = (Object[])hashtable2.get((Object)fieldNamesKey);
            Object[] objectArray4 = (Object[])hashtable2.get((Object)fieldTypesKey);
            n = 0;
            while (n < objectArray3.length) {
                classInfo.addField((String)objectArray3[n], ASCIIArchiveLoader.typeForName((String)objectArray4[n]));
                ++n;
            }
            ClassTable classTable = new ClassTable(this.archive, classInfo);
            this.archive.addClassTable(classTable);
        }
    }

    static byte typeForName(String string) throws CodingException {
        int n = string.length();
        if (n <= 0) {
            throw new CodingException("unknown type name: " + string);
        }
        switch (string.charAt(0)) {
            case 'b': {
                if (string.equals("boolean")) {
                    return 0;
                }
                if (string.equals("boolean[]")) {
                    return 1;
                }
                if (string.equals("byte")) {
                    return 4;
                }
                if (!string.equals("byte[]")) break;
                return 5;
            }
            case 'c': {
                if (string.equals("char")) {
                    return 2;
                }
                if (!string.equals("char[]")) break;
                return 3;
            }
            case 's': {
                if (string.equals("short")) {
                    return 6;
                }
                if (!string.equals("short[]")) break;
                return 7;
            }
            case 'i': {
                if (string.equals("int")) {
                    return 8;
                }
                if (!string.equals("int[]")) break;
                return 9;
            }
            case 'l': {
                if (string.equals("long")) {
                    return 10;
                }
                if (!string.equals("long[]")) break;
                return 11;
            }
            case 'f': {
                if (string.equals("float")) {
                    return 12;
                }
                if (!string.equals("float[]")) break;
                return 13;
            }
            case 'd': {
                if (string.equals("double")) {
                    return 14;
                }
                if (!string.equals("double[]")) break;
                return 15;
            }
            case 'j': {
                if (n == 16) {
                    if (string.equals("java.lang.String")) {
                        return 16;
                    }
                    if (!string.equals("java.lang.Object")) break;
                    return 18;
                }
                if (n != 18) break;
                if (string.equals("java.lang.String[]")) {
                    return 17;
                }
                if (!string.equals("java.lang.Object[]")) break;
                return 19;
            }
        }
        throw new CodingException("unknown type name: " + string);
    }

    void loadInstanceData() throws CodingException {
        Hashtable hashtable;
        String string;
        Hashtable hashtable2 = (Hashtable)this.archiveDict.get((Object)classTablesKey);
        if (hashtable2 == null) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable = (Hashtable)hashtable2.get((Object)string);
            this.loadRowMapping(string, hashtable);
        }
        enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            hashtable = (Hashtable)hashtable2.get((Object)string);
            this.loadRowData(string, hashtable);
        }
    }

    void loadRowMapping(String string, Hashtable hashtable) throws CodingException {
        Hashtable hashtable2 = (Hashtable)hashtable.get((Object)instancesKey);
        if (hashtable2 == null) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            Hashtable hashtable3 = (Hashtable)hashtable2.get((Object)string2);
            if (this.idForName.get(string2) != 0) {
                throw new CodingException("duplicate instance name: " + string2);
            }
            ClassTable classTable = this.archive.classTableForName(string);
            if (classTable == null) {
                throw new CodingException("bad class name for instance: " + string2);
            }
            int n = classTable.newIdentifier();
            this.idForName.putKnownAbsent(string2, n);
        }
    }

    void loadRowData(String string, Hashtable hashtable) throws CodingException {
        Hashtable hashtable2 = (Hashtable)hashtable.get((Object)instancesKey);
        if (hashtable2 == null) {
            return;
        }
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n = this.idForName.get(string2);
            ClassTable classTable = this.archive.tableForId[n];
            int n2 = this.archive.rowForId[n];
            Hashtable hashtable3 = (Hashtable)hashtable2.get((Object)string2);
            this.loadRow(classTable, n2, hashtable3);
        }
    }

    void loadRow(ClassTable classTable, int n, Hashtable hashtable) throws CodingException {
        int n2 = 0;
        while (n2 < classTable.fieldCount) {
            Object object = hashtable.get((Object)classTable.fieldNames[n2]);
            if (object != null) {
                this.setColumnFromValue(classTable, n, n2, object);
            }
            ++n2;
        }
    }

    void setColumnFromValue(ClassTable classTable, int n, int n2, Object object) throws CodingException {
        String string = null;
        Object[] objectArray = null;
        if (object instanceof String) {
            string = (String)object;
            switch (classTable.fieldTypes[n2]) {
                case 0: {
                    if (string.equalsIgnoreCase("true")) {
                        classTable.setBooleanAt(n, n2, true);
                        return;
                    }
                    if (string.equalsIgnoreCase("false")) {
                        classTable.setBooleanAt(n, n2, false);
                        return;
                    }
                    throw new CodingException("Invalid boolean value");
                }
                case 2: {
                    classTable.setCharAt(n, n2, string.charAt(0));
                    return;
                }
                case 4: {
                    classTable.setByteAt(n, n2, (byte)Integer.parseInt(string));
                    return;
                }
                case 5: {
                    classTable.setByteArrayAt(n, n2, this.bytesFromString(string));
                    return;
                }
                case 6: {
                    classTable.setShortAt(n, n2, (short)Integer.parseInt(string));
                    return;
                }
                case 8: {
                    classTable.setIntAt(n, n2, Integer.parseInt(string));
                    return;
                }
                case 10: {
                    classTable.setLongAt(n, n2, Long.parseLong(string));
                    return;
                }
                case 12: {
                    classTable.setFloatAt(n, n2, Float.valueOf(string).floatValue());
                    return;
                }
                case 14: {
                    classTable.setDoubleAt(n, n2, Double.valueOf(string).doubleValue());
                    return;
                }
                case 16: {
                    classTable.setStringAt(n, n2, string);
                    return;
                }
                case 18: {
                    classTable.setIdentifierAt(n, n2, this.idForName.get(string));
                    return;
                }
            }
            throw new CodingException("Invalid value " + string);
        }
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
            switch (classTable.fieldTypes[n2]) {
                case 1: {
                    int n3 = objectArray.length;
                    boolean[] blArray = new boolean[n3];
                    int n4 = 0;
                    while (n4 < n3) {
                        string = (String)objectArray[n4];
                        if (string.equalsIgnoreCase("true")) {
                            blArray[n4] = true;
                        } else if (string.equalsIgnoreCase("false")) {
                            blArray[n4] = false;
                        } else {
                            throw new CodingException("Invalid boolean value");
                        }
                        ++n4;
                    }
                    classTable.setBooleanArrayAt(n, n2, blArray);
                    return;
                }
                case 3: {
                    int n5 = objectArray.length;
                    char[] cArray = new char[n5];
                    int n6 = 0;
                    while (n6 < n5) {
                        string = (String)objectArray[n6];
                        cArray[n6] = string.charAt(0);
                        ++n6;
                    }
                    classTable.setCharArrayAt(n, n2, cArray);
                    return;
                }
                case 7: {
                    int n7 = objectArray.length;
                    short[] sArray = new short[n7];
                    int n8 = 0;
                    while (n8 < n7) {
                        string = (String)objectArray[n8];
                        sArray[n8] = (short)Integer.parseInt(string);
                        ++n8;
                    }
                    classTable.setShortArrayAt(n, n2, sArray);
                    return;
                }
                case 9: {
                    int n9 = objectArray.length;
                    int[] nArray = new int[n9];
                    int n10 = 0;
                    while (n10 < n9) {
                        string = (String)objectArray[n10];
                        nArray[n10] = Integer.parseInt(string);
                        ++n10;
                    }
                    classTable.setIntArrayAt(n, n2, nArray);
                    return;
                }
                case 11: {
                    int n11 = objectArray.length;
                    long[] lArray = new long[n11];
                    int n12 = 0;
                    while (n12 < n11) {
                        string = (String)objectArray[n12];
                        lArray[n12] = Long.parseLong(string);
                        ++n12;
                    }
                    classTable.setLongArrayAt(n, n2, lArray);
                    return;
                }
                case 13: {
                    int n13 = objectArray.length;
                    float[] fArray = new float[n13];
                    int n14 = 0;
                    while (n14 < n13) {
                        string = (String)objectArray[n14];
                        fArray[n14] = Float.valueOf(string).floatValue();
                        ++n14;
                    }
                    classTable.setFloatArrayAt(n, n2, fArray);
                    return;
                }
                case 15: {
                    int n15 = objectArray.length;
                    double[] dArray = new double[n15];
                    int n16 = 0;
                    while (n16 < n15) {
                        string = (String)objectArray[n16];
                        dArray[n16] = Double.valueOf(string);
                        ++n16;
                    }
                    classTable.setDoubleArrayAt(n, n2, dArray);
                    return;
                }
                case 17: {
                    int n17 = objectArray.length;
                    String[] stringArray = new String[n17];
                    int n18 = 0;
                    while (n18 < n17) {
                        stringArray[n18] = (String)objectArray[n18];
                        ++n18;
                    }
                    classTable.setStringArrayAt(n, n2, stringArray);
                    return;
                }
                case 19: {
                    int n19 = objectArray.length;
                    int[] nArray = new int[n19];
                    int n20 = 0;
                    while (n20 < n19) {
                        string = (String)objectArray[n20];
                        if (string != null) {
                            nArray[n20] = this.idForName.get(string);
                        }
                        ++n20;
                    }
                    classTable.setIdentifierArrayAt(n, n2, nArray);
                    return;
                }
            }
            throw new CodingException("Invalid value" + string);
        }
    }

    /*
     * Unable to fully structure code
     */
    byte[] bytesFromString(String var1_1) {
        if (var1_1 == null) {
            return null;
        }
        if (var1_1.equals("")) {
            return new byte[0];
        }
        var3_2 = var1_1.length();
        var7_3 = new byte[var3_2 / 2 + 1];
        var2_4 = 0;
        var5_5 = 0;
        ** GOTO lbl18
        {
            if (!Character.isSpace(var6_7 = var1_1.charAt(var2_4++))) {
                if (var2_4 >= var3_2) {
                    throw new NumberFormatException("bad byte string");
                }
                var4_6 = this.nibbleForHexChar(var6_7);
                var6_7 = var1_1.charAt(var2_4++);
                var7_3[var5_5++] = (byte)((var4_6 << 4) + this.nibbleForHexChar(var6_7));
            }
            do {
                if (var2_4 < var3_2) continue block0;
lbl18:
                // 2 sources

            } while (var2_4 < var3_2);
        }
        var8_8 = new byte[var5_5];
        System.arraycopy(var7_3, 0, var8_8, 0, var5_5);
        return var8_8;
    }

    int nibbleForHexChar(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        throw new NumberFormatException("bad byte string");
    }

    void loadRoots() throws CodingException {
        Object[] objectArray = (Object[])this.archiveDict.get((Object)rootInstancesKey);
        if (objectArray == null || objectArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            String string = (String)objectArray[n];
            int n2 = string == null || string.equals("") ? 0 : this.idForName.get(string);
            if (n2 == 0) {
                throw new CodingException("unknown root instance " + string);
            }
            this.archive.addRootIdentifier(n2);
            ++n;
        }
    }

    void writeASCII(OutputStream outputStream, boolean bl) throws IOException {
        this.nameForId = new String[this.archive.idCount];
        this.baseNameForTable = new Hashtable();
        this.archiveDict = new Hashtable();
        String string = String.valueOf(1);
        this.archiveDict.put((Object)archiveVersionKey, (Object)string);
        this.saveClassInfo();
        this.saveInstanceData();
        this.saveRoots();
        Serializer serializer = bl ? new FormattingSerializer(outputStream) : new Serializer(outputStream);
        serializer.writeObject(this.archiveDict);
        serializer.flush();
    }

    String nameForId(int n) {
        int n2;
        String string = this.nameForId[n];
        if (string != null) {
            return string;
        }
        ClassTable classTable = this.archive.tableForId[n];
        if (classTable == null) {
            return null;
        }
        String string2 = (String)this.baseNameForTable.get((Object)classTable);
        if (string2 == null) {
            string2 = classTable.className();
            int n3 = string2.lastIndexOf(46);
            if (n3 > 0 && n3 < string2.length() - 1 && string2.charAt(0) != '[') {
                string2 = string2.substring(n3 + 1, string2.length());
            }
            if (this.baseNameForTable.get((Object)(string2 = String.valueOf(string2) + "-")) != null) {
                string2 = String.valueOf(classTable.className()) + "-";
                n2 = 0;
                while (this.baseNameForTable.get((Object)string2) != null) {
                    string2 = String.valueOf(classTable.className()) + "-" + n2 + "-";
                    ++n2;
                }
            }
            this.baseNameForTable.put((Object)classTable, (Object)string2);
        }
        n2 = this.decimalDigitCount(classTable.rowCount());
        String string3 = this.decimalString(this.archive.rowForId[n], n2);
        this.nameForId[n] = string = String.valueOf(string2) + string3;
        return string;
    }

    int decimalDigitCount(int n) {
        int n2 = 0;
        while (n > 0) {
            ++n2;
            n /= 10;
        }
        return n2;
    }

    String decimalString(int n, int n2) {
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = 48;
            ++n3;
        }
        n3 = n2;
        while (n > 0 && n3 > 0) {
            cArray[--n3] = (char)(n % 10 + 48);
            n /= 10;
        }
        return new String(cArray);
    }

    void saveClassInfo() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.archive.classTables.elements();
        while (enumeration.hasMoreElements()) {
            ClassTable classTable = (ClassTable)enumeration.nextElement();
            Hashtable hashtable2 = this.dictionaryForTable(classTable);
            hashtable.put((Object)classTable.className(), (Object)hashtable2);
        }
        this.archiveDict.put((Object)classTablesKey, (Object)hashtable);
    }

    Hashtable dictionaryForTable(ClassTable classTable) {
        Hashtable hashtable = new Hashtable(5);
        String[] stringArray = new String[classTable.fieldCount];
        int n = 0;
        while (n < classTable.fieldCount) {
            stringArray[n] = this.nameForType(classTable.fieldTypes[n]);
            ++n;
        }
        hashtable.put((Object)fieldNamesKey, (Object)classTable.fieldNames);
        hashtable.put((Object)fieldTypesKey, (Object)stringArray);
        String[] stringArray2 = new String[classTable.classCount];
        n = 0;
        while (n < classTable.classCount) {
            stringArray2[n] = String.valueOf(classTable.classVersions[n]);
            ++n;
        }
        hashtable.put((Object)classNamesKey, (Object)classTable.classNames);
        hashtable.put((Object)classVersionsKey, (Object)stringArray2);
        return hashtable;
    }

    String nameForType(int n) {
        switch (n) {
            case 0: {
                return "boolean";
            }
            case 1: {
                return "boolean[]";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "char[]";
            }
            case 4: {
                return "byte";
            }
            case 5: {
                return "byte[]";
            }
            case 6: {
                return "short";
            }
            case 7: {
                return "short[]";
            }
            case 8: {
                return "int";
            }
            case 9: {
                return "int[]";
            }
            case 10: {
                return "long";
            }
            case 11: {
                return "long[]";
            }
            case 12: {
                return "float";
            }
            case 13: {
                return "float[]";
            }
            case 14: {
                return "double";
            }
            case 15: {
                return "double[]";
            }
            case 16: {
                return "java.lang.String";
            }
            case 17: {
                return "java.lang.String[]";
            }
            case 18: {
                return "java.lang.Object";
            }
            case 19: {
                return "java.lang.Object[]";
            }
        }
        throw new IllegalArgumentException("Unknown field type: " + n);
    }

    void saveInstanceData() {
        Hashtable hashtable = (Hashtable)this.archiveDict.get((Object)classTablesKey);
        int n = 1;
        while (n < this.archive.idCount) {
            ClassTable classTable = this.archive.tableForId[n];
            int n2 = this.archive.rowForId[n];
            Hashtable hashtable2 = this.dictionaryForInstance(classTable, n2);
            Hashtable hashtable3 = (Hashtable)hashtable.get((Object)classTable.className);
            Hashtable hashtable4 = (Hashtable)hashtable3.get((Object)instancesKey);
            if (hashtable4 == null) {
                hashtable4 = new Hashtable();
                hashtable3.put((Object)instancesKey, (Object)hashtable4);
            }
            hashtable4.put((Object)this.nameForId(n), (Object)hashtable2);
            ++n;
        }
    }

    Hashtable dictionaryForInstance(ClassTable classTable, int n) {
        Hashtable hashtable = new Hashtable(2 * classTable.fieldCount);
        int n2 = 0;
        while (n2 < classTable.fieldCount) {
            Object object = this.valueForField(classTable, n, n2);
            if (object != null) {
                hashtable.put((Object)classTable.fieldNames[n2], object);
            }
            ++n2;
        }
        return hashtable;
    }

    Object valueForField(ClassTable classTable, int n, int n2) {
        switch (classTable.fieldTypes[n2]) {
            case 0: {
                return String.valueOf(classTable.booleanAt(n, n2));
            }
            case 1: {
                boolean[] blArray = classTable.booleanArrayAt(n, n2);
                if (blArray == null) {
                    return null;
                }
                int n3 = blArray.length;
                String[] stringArray = new String[n3];
                int n4 = 0;
                while (n4 < n3) {
                    stringArray[n4] = String.valueOf(blArray[n4]);
                    ++n4;
                }
                return stringArray;
            }
            case 2: {
                return String.valueOf(classTable.charAt(n, n2));
            }
            case 3: {
                char[] cArray = classTable.charArrayAt(n, n2);
                if (cArray == null) {
                    return null;
                }
                int n5 = cArray.length;
                String[] stringArray = new String[n5];
                int n6 = 0;
                while (n6 < n5) {
                    stringArray[n6] = String.valueOf(cArray[n6]);
                    ++n6;
                }
                return stringArray;
            }
            case 4: {
                return String.valueOf(classTable.byteAt(n, n2) & 0xFF);
            }
            case 5: {
                return ASCIIArchiveLoader.bytesString(classTable.byteArrayAt(n, n2));
            }
            case 6: {
                return String.valueOf(classTable.shortAt(n, n2));
            }
            case 7: {
                short[] sArray = classTable.shortArrayAt(n, n2);
                if (sArray == null) {
                    return null;
                }
                int n7 = sArray.length;
                String[] stringArray = new String[n7];
                int n8 = 0;
                while (n8 < n7) {
                    stringArray[n8] = String.valueOf(sArray[n8]);
                    ++n8;
                }
                return stringArray;
            }
            case 8: {
                return String.valueOf(classTable.intAt(n, n2));
            }
            case 9: {
                int[] nArray = classTable.intArrayAt(n, n2);
                if (nArray == null) {
                    return null;
                }
                int n9 = nArray.length;
                String[] stringArray = new String[n9];
                int n10 = 0;
                while (n10 < n9) {
                    stringArray[n10] = String.valueOf(nArray[n10]);
                    ++n10;
                }
                return stringArray;
            }
            case 10: {
                return String.valueOf(classTable.longAt(n, n2));
            }
            case 11: {
                long[] lArray = classTable.longArrayAt(n, n2);
                if (lArray == null) {
                    return null;
                }
                int n11 = lArray.length;
                String[] stringArray = new String[n11];
                int n12 = 0;
                while (n12 < n11) {
                    stringArray[n12] = String.valueOf(lArray[n12]);
                    ++n12;
                }
                return stringArray;
            }
            case 12: {
                return String.valueOf(classTable.floatAt(n, n2));
            }
            case 13: {
                float[] fArray = classTable.floatArrayAt(n, n2);
                if (fArray == null) {
                    return null;
                }
                int n13 = fArray.length;
                String[] stringArray = new String[n13];
                int n14 = 0;
                while (n14 < n13) {
                    stringArray[n14] = String.valueOf(fArray[n14]);
                    ++n14;
                }
                return stringArray;
            }
            case 14: {
                return String.valueOf(classTable.doubleAt(n, n2));
            }
            case 15: {
                double[] dArray = classTable.doubleArrayAt(n, n2);
                if (dArray == null) {
                    return null;
                }
                int n15 = dArray.length;
                String[] stringArray = new String[n15];
                int n16 = 0;
                while (n16 < n15) {
                    stringArray[n16] = String.valueOf(dArray[n16]);
                    ++n16;
                }
                return stringArray;
            }
            case 16: {
                return classTable.stringAt(n, n2);
            }
            case 17: {
                return classTable.stringArrayAt(n, n2);
            }
            case 18: {
                return this.nameForId(classTable.identifierAt(n, n2));
            }
            case 19: {
                int[] nArray = classTable.identifierArrayAt(n, n2);
                if (nArray == null) {
                    return null;
                }
                int n17 = nArray.length;
                String[] stringArray = new String[n17];
                int n18 = 0;
                while (n18 < n17) {
                    stringArray[n18] = this.nameForId(nArray[n18]);
                    ++n18;
                }
                return stringArray;
            }
        }
        throw new InconsistencyException("Unknown field type: " + classTable.fieldTypes[n2]);
    }

    static String bytesString(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        int n = byArray.length;
        byte[] byArray2 = new byte[2 * n + n / 4 + 1];
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            byte by = byArray[n3];
            byArray2[n2++] = hexChar[by >>> 4 & 0xF];
            byArray2[n2++] = hexChar[by & 0xF];
            if ((n3 + 1) % 4 == 0) {
                byArray2[n2++] = 32;
            }
            ++n3;
        }
        if (byArray2[n2 - 1] == 32) {
            --n2;
        }
        return new String(byArray2, 0, 0, n2);
    }

    void saveRoots() {
        String[] stringArray = new String[this.archive.rootCount];
        int n = 0;
        while (n < this.archive.rootCount) {
            stringArray[n] = this.nameForId(this.archive.roots[n]);
            ++n;
        }
        this.archiveDict.put((Object)rootInstancesKey, (Object)stringArray);
    }
}

