/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import netscape.ldap.util.ByteBuf;
import netscape.ldap.util.MimeEncoder;

public final class MimeBase64Decoder
extends MimeEncoder {
    static final long serialVersionUID = 797397585345375903L;
    private byte[] token = new byte[4];
    private byte[] bytes = new byte[3];
    private int token_length;
    private static final byte NUL = 127;
    private static final byte EOF = 126;
    private static final byte[] map = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

    private final void decode_token(ByteBuf byteBuf) {
        int n = map[this.token[0]] << 18 | map[this.token[1]] << 12 | map[this.token[2]] << 6 | map[this.token[3]];
        this.bytes[0] = (byte)(0xFF & n >> 16);
        this.bytes[1] = (byte)(0xFF & n >> 8);
        this.bytes[2] = (byte)(0xFF & n);
        byteBuf.append(this.bytes);
    }

    private final void decode_final_token(ByteBuf byteBuf) {
        byte by = map[this.token[0]];
        byte by2 = map[this.token[1]];
        byte by3 = map[this.token[2]];
        byte by4 = map[this.token[3]];
        int n = 0;
        if (by == 126) {
            by = 0;
            ++n;
        }
        if (by2 == 126) {
            by2 = 0;
            ++n;
        }
        if (by3 == 126) {
            by3 = 0;
            ++n;
        }
        if (by4 == 126) {
            by4 = 0;
            ++n;
        }
        int n2 = by << 18 | by2 << 12 | by3 << 6 | by4;
        byteBuf.append((byte)(n2 >> 16));
        if (n <= 1) {
            byteBuf.append((byte)(n2 >> 8 & 0xFF));
            if (n == 0) {
                byteBuf.append((byte)(n2 & 0xFF));
            }
        }
    }

    public final void translate(ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.token == null) {
            return;
        }
        byte[] byArray = byteBuf.toBytes();
        int n = byteBuf.length();
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            int n3 = by & 0xFF;
            byte by2 = map[n3];
            if (by2 != 127) {
                this.token[this.token_length++] = by;
            }
            if (by2 == 126) {
                this.eof(byteBuf2);
                return;
            }
            if (this.token_length == 4) {
                this.decode_token(byteBuf2);
                this.token_length = 0;
            }
            ++n2;
        }
    }

    public final void eof(ByteBuf byteBuf) {
        if (this.token != null && this.token_length != 0) {
            while (this.token_length < 4) {
                this.token[this.token_length++] = 61;
            }
            this.decode_final_token(byteBuf);
        }
        this.token_length = 0;
        this.token = new byte[4];
        this.bytes = new byte[3];
    }
}

