/*
 * Decompiled with CFR 0.152.
 */
import edu.xtec.jclic.PlayerSettings;
import edu.xtec.jclic.SingleInstanceJFrame;
import edu.xtec.jclic.project.ProjectInstallerDlg;
import edu.xtec.util.BasicResourceBridge;
import edu.xtec.util.Messages;
import edu.xtec.util.Options;
import edu.xtec.util.PersistentSettings;
import java.awt.Component;

public abstract class JClicInstaller {
    public static void main(String[] stringArray) {
        boolean bl = true;
        try {
            Options options = new Options((Component)null);
            Messages messages = PersistentSettings.getMessages(options, "messages.JClicMessages");
            messages.addBundle("commonSettings");
            messages.addBundle("messages.PlayerMessages");
            String string = SingleInstanceJFrame.loadArgs(stringArray, options);
            if (string == null) {
                System.err.println("Error: no installer file specified!");
            } else if (!string.endsWith(".jclic.inst")) {
                System.err.println("Error: " + string + " isn't a JClic package install script.\nJClic package install scripts end always with .jclic.inst");
            } else {
                BasicResourceBridge basicResourceBridge = new BasicResourceBridge(options);
                PlayerSettings playerSettings = PlayerSettings.loadPlayerSettings(basicResourceBridge);
                if (playerSettings.promptPassword(null, null)) {
                    playerSettings.checkLibrary();
                    ProjectInstallerDlg projectInstallerDlg = ProjectInstallerDlg.getProjectInstallerDlg(null, playerSettings.libraryManager, string);
                    if (projectInstallerDlg != null) {
                        projectInstallerDlg.setVisible(true);
                        if (!projectInstallerDlg.cancel && projectInstallerDlg.launchNow && projectInstallerDlg.pathToMainProject != null) {
                            JClicPlayer.main(new String[]{projectInstallerDlg.pathToMainProject});
                            bl = false;
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.err.println("Error installing:\n" + exception);
        }
        if (bl) {
            System.exit(0);
        }
    }
}

