/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.activities.panels.Menu;
import edu.xtec.jclic.activities.panels.MenuEditorPanel;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.activities.panels.MenuElementEditor;
import edu.xtec.jclic.bags.ActivitySequenceElement;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.boxes.BoxBase;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorAction;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.jclic.project.ProjectLibrary;
import edu.xtec.jclic.project.ProjectLibraryEditor;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.StrUtils;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class MenuEditor
extends Editor {
    protected static ImageIcon icon;
    public static EditorAction newMenuElementAction;
    public static EditorAction newMenuAction;
    public static boolean actionsCreated;
    protected ProjectLibrary projectLibrary;

    public MenuEditor(Menu menu) {
        super(menu);
    }

    protected void createChildren() {
        Menu menu = this.getMenu();
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null && !menu.menuElements.isEmpty()) {
            for (int i = 0; i < menu.getMenuElementCount(); ++i) {
                MenuElement menuElement = menu.getMenuElement(i);
                if (menuElement.projectPath == null && menuElement.sequence != null && !"@RETURN".equals(menuElement.sequence)) {
                    try {
                        Activity activity = Activity.getActivity(projectLibrary.activityBag.getElement(menuElement.sequence).getData(), projectLibrary);
                        if (!(activity instanceof Menu)) continue;
                        ((Menu)activity).getEditor(this);
                    }
                    catch (Exception exception) {
                        System.err.println("Error reading activity:\n" + exception);
                    }
                    continue;
                }
                menuElement.getEditor(this);
            }
        }
    }

    public Class getEditorPanelClass() {
        return MenuEditorPanel.class;
    }

    public EditorPanel createEditorPanel(Options options) {
        return new MenuEditorPanel(options);
    }

    public Menu getMenu() {
        return (Menu)this.getUserObject();
    }

    public Options getOptions() {
        return this.getMenu().getProject().getBridge().getOptions();
    }

    protected void saveData() {
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null) {
            projectLibrary.activityBag.addActivity(this.getMenu());
        }
    }

    public ProjectLibrary getProjectLibrary() {
        Editor editor;
        if (this.projectLibrary == null && (editor = this.getEditorParent()) != null) {
            if (editor instanceof ProjectLibraryEditor) {
                this.projectLibrary = ((ProjectLibraryEditor)editor).getProjectLibrary();
            } else if (editor instanceof MenuEditor) {
                this.projectLibrary = ((MenuEditor)editor).getProjectLibrary();
            }
        }
        return this.projectLibrary;
    }

    public String toString() {
        return this.getMenu().description;
    }

    protected boolean canClone() {
        return true;
    }

    protected Editor getClone() throws Exception {
        Menu menu = (Menu)this.getMenu().duplicate();
        menu.name = Long.toString(System.currentTimeMillis());
        MenuEditor menuEditor = (MenuEditor)menu.getEditor(null);
        menuEditor.projectLibrary = this.getProjectLibrary();
        menuEditor.createChildren();
        return menuEditor;
    }

    public void setActionsOwner() {
        Editor editor = this.getEditorParent();
        this.allowCut = editor != null && !(editor instanceof ProjectLibraryEditor);
        this.allowDelete = this.allowCut;
        this.allowDelete = this.allowCut && this.getChildCount() == 0;
        this.allowPaste = true;
        this.allowCopy = true;
        super.setActionsOwner();
        newMenuElementAction.setActionOwner(this);
        newMenuAction.setActionOwner(editor != null ? this : null);
    }

    public void clearActionsOwner() {
        super.clearActionsOwner();
        newMenuAction.setActionOwner(null);
        newMenuElementAction.setActionOwner(null);
    }

    public static Icon getIcon() {
        if (icon == null) {
            icon = ResourceManager.getImageIcon("icons/file_open.gif");
        }
        return icon;
    }

    public void setDescription(String string) {
        Menu menu = this.getMenu();
        menu.description = StrUtils.secureString(string, this.getOptions().getMsg("UNNAMED"));
        ActiveBoxContent[] activeBoxContentArray = menu.getMessages();
        if (activeBoxContentArray[1] == null) {
            activeBoxContentArray[1] = new ActiveBoxContent();
            activeBoxContentArray[1].setBoxBase(new BoxBase());
        }
        activeBoxContentArray[1].setTextContent(menu.description);
        MenuElement menuElement = this.checkParentMenuElementRef(false, false, false, 0);
        if (menuElement != null) {
            menuElement.caption = menu.description;
        }
    }

    protected MenuElement checkParentMenuElementRef(boolean bl, boolean bl2, boolean bl3, int n) {
        MenuElement menuElement = null;
        Menu menu = this.getMenu();
        if (this.getEditorParent() instanceof MenuEditor) {
            Menu menu2 = ((MenuEditor)this.getEditorParent()).getMenu();
            for (int i = 0; i < menu2.getMenuElementCount(); ++i) {
                MenuElement menuElement2 = menu2.getMenuElement(i);
                if (menuElement2.projectPath != null || menuElement2.sequence == null || !menuElement2.sequence.equals(menu.name)) continue;
                menuElement = menuElement2;
                break;
            }
            if (menuElement != null && (bl || bl3)) {
                menu2.menuElements.remove(menuElement);
                if (bl3) {
                    menu2.menuElements.add(n, menuElement);
                }
            } else if (menuElement == null && bl2) {
                n = Math.max(0, Math.min(n, menu.getMenuElementCount()));
                menuElement = new MenuElement();
                menuElement.sequence = menu.name;
                menuElement.caption = menu.description;
                menu2.menuElements.add(n, menuElement);
            }
        }
        return menuElement;
    }

    public boolean moveUp(boolean bl) {
        boolean bl2 = super.moveUp(bl);
        if (bl2) {
            this.checkParentMenuElementRef(false, false, true, this.getParent().getIndex(this));
        }
        return bl2;
    }

    public boolean moveDown(boolean bl) {
        boolean bl2 = super.moveDown(bl);
        if (bl2) {
            this.checkParentMenuElementRef(false, false, true, this.getParent().getIndex(this));
        }
        return bl2;
    }

    public boolean insertEditor(Editor editor, boolean bl, int n, boolean bl2) {
        boolean bl3 = false;
        if (!bl) {
            bl3 = super.insertEditor(editor, bl, n, bl2);
        } else if (editor instanceof MenuEditor) {
            ProjectLibrary projectLibrary = this.getProjectLibrary();
            if (projectLibrary != null) {
                int n2;
                Menu menu = ((MenuEditor)editor).getMenu();
                for (n2 = 0; n2 < this.getChildCount() && this.getChildAt(n2) instanceof MenuEditor; ++n2) {
                }
                n = n < 0 ? n2 : Math.min(n, n2);
                projectLibrary.activityBag.addActivity(menu);
                projectLibrary.activitySequence.add(new ActivitySequenceElement(menu.name, true));
                MenuEditor menuEditor = (MenuEditor)menu.getEditor(this);
                menuEditor.checkParentMenuElementRef(false, true, false, n);
                bl3 = super.insertEditor(menuEditor, true, n, bl2);
            }
        } else if (editor instanceof MenuElementEditor) {
            MenuElement menuElement = ((MenuElementEditor)editor).getMenuElement();
            n = n < 0 ? this.getChildCount() : Math.min(n, this.getChildCount());
            this.getMenu().menuElements.add(n, menuElement);
            bl3 = super.insertEditor(menuElement.getEditor(this), true, n, bl2);
        }
        return bl3;
    }

    public boolean createNewMenu(int n, boolean bl, Component component) {
        boolean bl2 = false;
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        if (projectLibrary != null) {
            JTree jTree = this.getCurrentTree();
            TreePath treePath = null;
            if (jTree != null) {
                treePath = jTree.getSelectionPath();
            }
            Menu menu = new Menu(projectLibrary);
            menu.name = Long.toString(System.currentTimeMillis());
            MenuEditor menuEditor = (MenuEditor)menu.getEditor(null);
            menuEditor.setDescription(this.getOptions().getMsg("menu_newMenuName"));
            bl2 = bl ? menuEditor.createEditorPanel(this.getOptions()).showDialog(menuEditor, "menu_newMenuElement_caption", component, true) : true;
            if (bl2) {
                bl2 = this.insertEditor(menuEditor, true, n, true);
            } else if (treePath != null) {
                jTree.clearSelection();
                jTree.setSelectionPath(treePath);
            }
        }
        return bl2;
    }

    public boolean createNewMenuElement(int n, boolean bl, Component component) {
        MenuElement menuElement = new MenuElement();
        boolean bl2 = false;
        TreePath treePath = null;
        JTree jTree = this.getCurrentTree();
        MenuElementEditor menuElementEditor = null;
        menuElement.caption = this.getOptions().getMsg("menu_newMenuElementName");
        if (jTree != null) {
            treePath = jTree.getSelectionPath();
        }
        menuElementEditor = (MenuElementEditor)menuElement.getEditor(null);
        menuElementEditor.projectLibrary = this.getProjectLibrary();
        menuElementEditor.createChildren();
        bl2 = bl ? menuElementEditor.createEditorPanel(this.getOptions()).showDialog(menuElementEditor, "menu_newMenuElement_caption", component, true) : true;
        n = n < 0 ? this.getChildCount() : Math.min(n, this.getChildCount());
        if (bl2) {
            bl2 = this.insertEditor(menuElementEditor, true, n, true);
        } else if (treePath != null) {
            jTree.clearSelection();
            jTree.setSelectionPath(treePath);
        }
        return bl2;
    }

    public boolean delete(boolean bl) {
        boolean bl2 = false;
        ProjectLibrary projectLibrary = this.getProjectLibrary();
        String string = this.getMenu().name;
        Editor editor = this.getEditorParent();
        if (string != null && (bl2 = super.delete(bl))) {
            this.parent = editor;
            if (projectLibrary != null) {
                ActivitySequenceElement activitySequenceElement = projectLibrary.activitySequence.getElementByTag(string, false);
                if (activitySequenceElement != null) {
                    projectLibrary.activitySequence.remove(activitySequenceElement);
                }
                projectLibrary.activityBag.removeElementByName(string);
            }
            this.checkParentMenuElementRef(true, false, false, 0);
            this.parent = null;
        }
        return bl2;
    }

    public boolean canBeParentOf(Editor editor) {
        return editor instanceof MenuElementEditor || editor instanceof MenuEditor;
    }

    public boolean canBeSiblingOf(Editor editor) {
        if (this.getEditorParent() instanceof MenuEditor) {
            return this.canBeParentOf(editor);
        }
        return editor instanceof MenuElementEditor;
    }

    public static void createActions(Options options) {
        MenuEditor.createBasicActions(options);
        if (!actionsCreated) {
            newMenuElementAction = new EditorAction("menu_newMenuElement_caption", "icons/new_miniclic.png", "menu_newMenuElement_tooltip", options){

                protected void doAction(Editor editor) {
                    Editor editor2 = null;
                    if (editor instanceof MenuElementEditor) {
                        editor2 = editor;
                        editor = editor.getEditorParent();
                    }
                    if (editor instanceof MenuEditor) {
                        ((MenuEditor)editor).createNewMenuElement(editor.getNearestIndex(editor2, true), true, this.getComponentSrc());
                    }
                }
            };
            newMenuAction = new EditorAction("menu_newMenu_caption", "icons/new_folder.gif", "menu_newMenu_tooltip", options){

                protected void doAction(Editor editor) {
                    if (editor instanceof MenuElementEditor) {
                        editor = editor.getEditorParent();
                    }
                    if (editor instanceof MenuEditor) {
                        ((MenuEditor)editor).createNewMenu(-1, true, this.getComponentSrc());
                    }
                }
            };
            actionsCreated = true;
        }
    }

    static {
        actionsCreated = false;
    }
}

