/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.panels;

import edu.xtec.jclic.activities.panels.MenuEditor;
import edu.xtec.jclic.activities.panels.MenuElement;
import edu.xtec.jclic.activities.panels.MenuElementEditor;
import edu.xtec.jclic.edit.Editor;
import edu.xtec.jclic.edit.EditorPanel;
import edu.xtec.util.CustomListCellRenderer;
import edu.xtec.util.Options;
import edu.xtec.util.ResourceManager;
import edu.xtec.util.SmallButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class MenuElementEditorPanel
extends EditorPanel {
    private static Vector standardIcons;
    private Vector icons;
    private JButton btFindIcon;
    private JButton btFindProject;
    private JTextField captionText;
    private JTextField descText;
    private JComboBox iconCombo;
    private JPanel mainPanel;
    private JTextField projectText;

    public MenuElementEditorPanel(Options options) {
        super(options);
        MenuEditor.createActions(options);
        MenuElementEditor.createActions(options);
        this.buildIconList();
        this.initComponents();
        this.postInit(250, true, true);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        JLabel jLabel = new JLabel();
        this.projectText = new JTextField();
        this.projectText.getDocument().addDocumentListener(this);
        this.btFindProject = new SmallButton(MenuElementEditor.findProjectAction);
        JLabel jLabel2 = new JLabel();
        this.iconCombo = new JComboBox(new DefaultComboBoxModel(this.icons));
        this.iconCombo.addActionListener(this);
        this.btFindIcon = new SmallButton(MenuElementEditor.findIconAction);
        JLabel jLabel3 = new JLabel();
        this.captionText = new JTextField();
        this.captionText.getDocument().addDocumentListener(this);
        JLabel jLabel4 = new JLabel();
        this.descText = new JTextField();
        this.descText.getDocument().addDocumentListener(this);
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(350, 300));
        this.mainPanel.setLayout(new GridBagLayout());
        this.mainPanel.setOpaque(false);
        jLabel.setText(this.options.getMsg("menuElement_dlg_project"));
        jLabel.setToolTipText(this.options.getMsg("menuElement_dlg_project_tooltip"));
        jLabel.setLabelFor(this.projectText);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)jLabel, gridBagConstraints);
        this.projectText.setToolTipText(this.options.getMsg("menuElement_dlg_project_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.mainPanel.add((Component)this.projectText, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        this.mainPanel.add((Component)this.btFindProject, gridBagConstraints);
        jLabel2.setText(this.options.getMsg("menuElement_dlg_icon"));
        jLabel2.setToolTipText(this.options.getMsg("menuElement_dlg_icon_tooltip"));
        jLabel2.setLabelFor(this.iconCombo);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)jLabel2, gridBagConstraints);
        this.iconCombo.setToolTipText(this.options.getMsg("menuElement_dlg_icon_tooltip"));
        this.iconCombo.setRenderer(new CustomListCellRenderer());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.iconCombo, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.mainPanel.add((Component)this.btFindIcon, gridBagConstraints);
        jLabel3.setText(this.options.getMsg("edit_text"));
        jLabel3.setToolTipText(this.options.getMsg("menuElement_dlg_text_tooltip"));
        jLabel3.setLabelFor(this.captionText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)jLabel3, gridBagConstraints);
        this.captionText.setToolTipText(this.options.getMsg("menuElement_dlg_text_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.captionText, gridBagConstraints);
        jLabel4.setText(this.options.getMsg("menuElement_dlg_description"));
        jLabel4.setToolTipText(this.options.getMsg("menuElement_dlg_description_tooltip"));
        jLabel4.setLabelFor(this.descText);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(2, 4, 2, 2);
        this.mainPanel.add((Component)jLabel4, gridBagConstraints);
        this.descText.setToolTipText(this.options.getMsg("menuElement_dlg_description_tooltip"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 4);
        this.mainPanel.add((Component)this.descText, gridBagConstraints);
        this.add((Component)this.mainPanel, "Center");
    }

    public boolean checkIfEditorValid(Editor editor) {
        return editor instanceof MenuElementEditor;
    }

    public void fillData() {
        MenuElement menuElement = this.getMenuElement();
        this.captionText.setText(menuElement == null ? "" : menuElement.caption);
        this.projectText.setText(menuElement == null ? "" : menuElement.projectPath);
        this.descText.setText(menuElement == null ? "" : menuElement.description);
        if (this.getMeIcon() != null && !this.icons.contains(this.getMeIcon())) {
            DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.iconCombo.getModel();
            defaultComboBoxModel.addElement(this.getMeIcon());
        }
        this.iconCombo.setSelectedItem(this.getMeIcon());
    }

    protected MenuElement getMenuElement() {
        if (this.editor == null) {
            return null;
        }
        return this.getMeEditor().getMenuElement();
    }

    public void saveData() {
        MenuElement menuElement = this.getMenuElement();
        if (menuElement != null) {
            menuElement.caption = this.captionText.getText();
            menuElement.projectPath = this.projectText.getText();
            menuElement.description = this.descText.getText();
            this.getMeEditor().meIcon = (ImageIcon)this.iconCombo.getSelectedItem();
            if (this.getMeIcon() != null) {
                menuElement.icon = this.getMeIcon().getDescription();
            }
        }
    }

    protected void setEditor(Editor editor) {
        super.setEditor(editor);
        if (editor != null) {
            this.icons = new Vector(standardIcons);
            this.iconCombo.setModel(new DefaultComboBoxModel(this.icons));
        }
    }

    protected Icon getIcon() {
        return MenuElementEditor.getIcon();
    }

    protected MenuElementEditor getMeEditor() {
        return (MenuElementEditor)this.editor;
    }

    protected ImageIcon getMeIcon() {
        MenuElementEditor menuElementEditor = this.getMeEditor();
        return menuElementEditor == null ? null : menuElementEditor.meIcon;
    }

    protected String getTitle() {
        return this.options.getMsg("menuElement_dlg_title");
    }

    protected void addActionsTo(Container container) {
        container.add(new SmallButton(MenuEditor.newMenuElementAction));
        container.add(new SmallButton(MenuEditor.newMenuAction));
        container.add(new SmallButton(Editor.moveUpAction));
        container.add(new SmallButton(Editor.moveDownAction));
        container.add(new SmallButton(Editor.copyAction));
        container.add(new SmallButton(Editor.cutAction));
        container.add(new SmallButton(Editor.pasteAction));
        container.add(new SmallButton(Editor.deleteAction));
    }

    protected void buildIconList() {
        if (standardIcons == null) {
            standardIcons = new Vector();
            for (int i = 0; i < 4; ++i) {
                String string = "ico0" + i + ".png";
                ImageIcon imageIcon = ResourceManager.getImageIcon("icons/" + string);
                if (imageIcon == null) continue;
                standardIcons.add(imageIcon);
            }
        }
        this.icons = new Vector(standardIcons);
    }
}

