/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.activities.puzzles;

import edu.xtec.jclic.Activity;
import edu.xtec.jclic.HelpActivityComponent;
import edu.xtec.jclic.PlayStation;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBox;
import edu.xtec.jclic.boxes.ActiveBoxBag;
import edu.xtec.jclic.boxes.ActiveBoxGrid;
import edu.xtec.jclic.boxes.BoxBag;
import edu.xtec.jclic.boxes.BoxConnector;
import edu.xtec.jclic.clic3.Clic3Activity;
import edu.xtec.jclic.project.JClicProject;
import edu.xtec.util.JDomUtility;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import org.jdom.Element;

public class ExchangePuzzle
extends Activity
implements ActiveBagContentKit.Compatible {
    public ExchangePuzzle(JClicProject jClicProject) {
        super(jClicProject);
        this.abc = new ActiveBagContent[1];
        this.dragCells = true;
    }

    public void initNew() {
        super.initNew();
        this.abc[0] = ActiveBagContent.initNew(3, 2, 65);
    }

    public Element getJDomElement() {
        Element element = null;
        if (this.abc[0] == null) {
            return null;
        }
        Element element2 = super.getJDomElement();
        element2.addContent(this.abc[0].getJDomElement());
        element = new Element("scramble");
        element.setAttribute("times", Integer.toString(this.shuffles));
        element2.addContent(element);
        return element2;
    }

    public void setProperties(Element element, Object object) throws Exception {
        super.setProperties(element, object);
        Element element2 = element.getChild("cells");
        if (element2 != null) {
            this.abc[0] = ActiveBagContent.getActiveBagContent(element2, this.project.mediaBag);
        }
        if (this.abc[0] == null) {
            throw new IllegalArgumentException("Puzzle without content!");
        }
        element2 = element.getChild("scramble");
        if (element2 != null) {
            this.shuffles = JDomUtility.getIntAttr(element2, "times", this.shuffles);
        }
    }

    public void setProperties(Clic3Activity clic3Activity) throws Exception {
        super.setProperties(clic3Activity);
        this.abc[0] = clic3Activity.createActiveBagContent(0);
        this.abc[0].setBoxBase(clic3Activity.getBoxBase(0));
        this.dragCells = true;
    }

    public int getMinNumActions() {
        return this.abc[0] == null ? 0 : this.abc[0].getNumCells();
    }

    public boolean helpSolutionAllowed() {
        return true;
    }

    public boolean hasRandom() {
        return true;
    }

    public boolean shuffleAlways() {
        return true;
    }

    public Activity.Panel getActivityPanel(PlayStation playStation) {
        return new Panel(playStation);
    }

    class Panel
    extends Activity.Panel {
        ActiveBoxBag bg;

        protected Panel(PlayStation playStation) {
            super(playStation);
            this.bc = new BoxConnector(this);
        }

        public void clear() {
            if (this.bg != null) {
                this.bg.end();
                this.bg = null;
            }
        }

        public void buildVisualComponents() throws Exception {
            if (this.firstRun) {
                super.buildVisualComponents();
            }
            this.clear();
            if (ExchangePuzzle.this.abc[0] != null) {
                if (ExchangePuzzle.this.acp != null) {
                    ExchangePuzzle.this.acp.generateContent(new ActiveBagContentKit(ExchangePuzzle.this.abc[0].nch, ExchangePuzzle.this.abc[0].ncw, ExchangePuzzle.this.abc, false), this.ps);
                }
                this.bg = ActiveBoxGrid.createEmptyGrid(null, this, ExchangePuzzle.this.margin, ExchangePuzzle.this.margin, ExchangePuzzle.this.abc[0]);
                this.bg.setContent(ExchangePuzzle.this.abc[0]);
                this.bg.setVisible(true);
                this.invalidate();
            }
        }

        public void initActivity() throws Exception {
            super.initActivity();
            if (!this.firstRun) {
                this.buildVisualComponents();
            }
            this.firstRun = false;
            this.setAndPlayMsg(1, 0);
            if (this.bg != null) {
                this.shuffle(new ActiveBoxBag[]{this.bg}, true, false);
                this.ps.setCounterValue(0, this.bg.countCellsAtEquivalentPlace(true));
                this.playing = true;
            }
        }

        public void render(Graphics2D graphics2D, Rectangle rectangle) {
            if (this.bg != null) {
                this.bg.update(graphics2D, rectangle, this);
            }
            if (this.bc.active) {
                this.bc.update(graphics2D, rectangle, this);
            }
        }

        public Dimension setDimension(Dimension dimension) {
            if (this.bg == null || this.getSize().equals(dimension)) {
                return dimension;
            }
            return BoxBag.layoutSingle(dimension, this.bg, ExchangePuzzle.this.margin);
        }

        public void processMouse(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            boolean bl = false;
            if (this.playing) {
                switch (mouseEvent.getID()) {
                    case 501: {
                        this.ps.stopMedia(1);
                        if (this.bc.active) {
                            ActiveBox activeBox = ExchangePuzzle.this.dragCells ? this.bc.getBox() : this.bg.findActiveBox(this.bc.origin);
                            this.bc.end();
                            ActiveBox activeBox2 = this.bg.findActiveBox(point);
                            if (activeBox != null && activeBox2 != null) {
                                String string = activeBox.getDescription() + "(" + activeBox.idOrder + ")";
                                String string2 = "(" + activeBox2.idLoc + ")";
                                boolean bl2 = activeBox.idOrder == activeBox2.idLoc;
                                activeBox.exchangeLocation(activeBox2);
                                int n = this.bg.countCellsAtEquivalentPlace(true);
                                this.ps.reportNewAction(this.getActivity(), "PLACE", string, string2, bl2, n);
                                if (bl2 && n == this.bg.getNumCells()) {
                                    this.finishActivity(true);
                                } else {
                                    this.playEvent(bl2 ? 3 : 2);
                                }
                            }
                            this.repaint();
                            break;
                        }
                        ActiveBox activeBox = this.bg.findActiveBox(point);
                        if (activeBox == null) break;
                        if (ExchangePuzzle.this.dragCells) {
                            this.bc.begin(point, activeBox);
                        } else {
                            this.bc.begin(point);
                        }
                        bl = activeBox.playMedia(this.ps);
                        if (bl) break;
                        this.playEvent(1);
                        break;
                    }
                    case 503: 
                    case 506: {
                        this.bc.moveTo(point);
                    }
                }
            }
        }

        public void showHelp() {
            if (!ExchangePuzzle.this.helpWindowAllowed() || this.bg == null) {
                return;
            }
            HelpActivityComponent helpActivityComponent = null;
            if (ExchangePuzzle.this.showSolution) {
                helpActivityComponent = new HelpActivityComponent(this){
                    ActiveBoxBag abb;
                    {
                        this.abb = null;
                    }

                    public void render(Graphics2D graphics2D, Rectangle rectangle) {
                        if (this.abb != null) {
                            this.abb.update(graphics2D, rectangle, this);
                        }
                    }

                    public void init() {
                        this.abb = ActiveBoxGrid.createEmptyGrid(null, this, 8.0, 8.0, ((Panel)Panel.this).ExchangePuzzle.this.abc[0]);
                        this.abb.setContent(((Panel)Panel.this).ExchangePuzzle.this.abc[0]);
                        this.abb.setVisible(true);
                        Dimension dimension = Panel.this.bg.getBounds().getSize();
                        this.abb.setBounds(8.0, 8.0, dimension.width, dimension.height);
                        dimension.width += 16;
                        dimension.height += 16;
                        this.setPreferredSize(dimension);
                        this.setMaximumSize(dimension);
                        this.setMinimumSize(dimension);
                        Point point = (Point)this.getClientProperty("prefLoc");
                        if (point != null) {
                            point.translate((int)Panel.this.bg.x - 8, (int)Panel.this.bg.y - 8);
                        }
                    }

                    public void processMouse(MouseEvent mouseEvent) {
                        ActiveBox activeBox;
                        if (this.abb != null && (activeBox = this.abb.findActiveBox(mouseEvent.getPoint())) != null) {
                            activeBox.playMedia(Panel.this.ps);
                        }
                    }
                };
                helpActivityComponent.init();
            }
            if (this.ps.showHelp(helpActivityComponent, ExchangePuzzle.this.helpMsg)) {
                this.ps.reportNewAction(this.getActivity(), "HELP", null, null, false, this.bg.countCellsAtEquivalentPlace(true));
            }
            if (helpActivityComponent != null) {
                helpActivityComponent.end();
            }
        }
    }
}

