/*
 * Decompiled with CFR 0.152.
 */
package edu.xtec.jclic.automation.tagreplace;

import edu.xtec.jclic.activities.text.TargetMarker;
import edu.xtec.jclic.activities.text.TextActivityDocument;
import edu.xtec.jclic.activities.text.TextTarget;
import edu.xtec.jclic.automation.ActiveBagContentKit;
import edu.xtec.jclic.automation.AutoContentProvider;
import edu.xtec.jclic.automation.TextActivityContentKit;
import edu.xtec.jclic.boxes.ActiveBagContent;
import edu.xtec.jclic.boxes.ActiveBoxContent;
import edu.xtec.jclic.fileSystem.FileSystem;
import edu.xtec.util.JDomUtility;
import edu.xtec.util.ResourceBridge;
import edu.xtec.util.StrUtils;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.jdom.Element;

public class TagReplace
extends AutoContentProvider {
    public static final String DEFAULT_TAG_START = "[";
    public static final String DEFAULT_TAG_END = "]";
    public static final String DEFAULT_CHARSET = "UTF8";
    public String tagStart = "[";
    public String tagEnd = "]";
    public String mapFileName;
    public String fileCharset = "UTF8";
    private HashMap map;
    public static final String TAG_START = "tagStart";
    public static final String TAG_END = "tagEnd";
    public static final String MAP_FN = "mapFn";
    public static final String MAP_CHARSET = "charset";

    public Element getJDomElement() {
        Element element = super.getJDomElement();
        element.setAttribute(TAG_START, this.tagStart);
        element.setAttribute(TAG_END, this.tagEnd);
        if (this.mapFileName != null) {
            element.setAttribute(MAP_FN, this.mapFileName);
            element.setAttribute(MAP_CHARSET, this.fileCharset);
        }
        return element;
    }

    public void setProperties(Element element, Object object) throws Exception {
        this.tagStart = JDomUtility.getStringAttr(element, TAG_START, DEFAULT_TAG_START, false);
        this.tagEnd = JDomUtility.getStringAttr(element, TAG_END, DEFAULT_TAG_END, false);
        this.mapFileName = JDomUtility.getStringAttr(element, MAP_FN, null, false);
        this.fileCharset = JDomUtility.getStringAttr(element, MAP_CHARSET, DEFAULT_CHARSET, false);
        this.map = null;
    }

    public static boolean checkClient(Class clazz) {
        return ActiveBagContentKit.Compatible.class.isAssignableFrom(clazz) || TextActivityContentKit.Compatible.class.isAssignableFrom(clazz);
    }

    public boolean generateContent(Object object, ResourceBridge resourceBridge) {
        boolean bl = false;
        if (object instanceof ActiveBagContentKit) {
            ActiveBagContentKit activeBagContentKit = (ActiveBagContentKit)object;
            bl = this.generateContent(activeBagContentKit.nRows, activeBagContentKit.nCols, activeBagContentKit.content, activeBagContentKit.useIds, resourceBridge);
        } else if (object instanceof TextActivityContentKit) {
            bl = this.generateContent((TextActivityContentKit)object);
        }
        return bl;
    }

    protected boolean generateContent(TextActivityContentKit textActivityContentKit) {
        boolean bl = false;
        if (textActivityContentKit.tad != null) {
            try {
                textActivityContentKit.checkButtonText = this.filter(textActivityContentKit.checkButtonText);
                textActivityContentKit.prevScreenText = this.filter(textActivityContentKit.prevScreenText);
                this.filterDoc(textActivityContentKit.tad);
                bl = true;
            }
            catch (BadLocationException badLocationException) {
                System.err.println("Error processing text document: " + badLocationException);
                return false;
            }
        }
        return bl;
    }

    protected boolean generateContent(int n, int n2, ActiveBagContent[] activeBagContentArray, boolean bl, ResourceBridge resourceBridge) {
        if (activeBagContentArray == null || activeBagContentArray.length < 1 || resourceBridge == null) {
            return false;
        }
        for (int i = 0; i < activeBagContentArray.length; ++i) {
            this.filterActiveBagContent(activeBagContentArray[i]);
        }
        return true;
    }

    protected void filterActiveBagContent(ActiveBagContent activeBagContent) {
        if (activeBagContent != null) {
            for (int i = 0; i < activeBagContent.getNumCells(); ++i) {
                this.filterActiveBoxContent(activeBagContent.getActiveBoxContent(i));
            }
        }
    }

    protected void filterActiveBoxContent(ActiveBoxContent activeBoxContent) {
        if (activeBoxContent != null) {
            activeBoxContent.text = this.filter(activeBoxContent.text);
            activeBoxContent.imgName = this.filter(activeBoxContent.imgName);
            if (activeBoxContent.mediaContent != null) {
                activeBoxContent.mediaContent.mediaFileName = this.filter(activeBoxContent.mediaContent.mediaFileName);
            }
        }
    }

    protected Vector locateTags(String string) {
        Vector<Object[]> vector = new Vector<Object[]>();
        if (string != null && this.map != null) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            while ((n2 = string.indexOf(this.tagStart, n)) >= 0 && (n3 = string.indexOf(this.tagEnd, n2 + this.tagStart.length())) > n2) {
                Object[] objectArray = new Object[4];
                objectArray[0] = new Integer(n2);
                objectArray[1] = new Integer(n3 + this.tagEnd.length() - n2);
                String string2 = string.substring(n2 + this.tagStart.length(), n3);
                String string3 = (String)this.map.get(string2);
                if (string3 != null) {
                    objectArray[2] = string3;
                    vector.add(objectArray);
                }
                n = n3 + this.tagEnd.length();
            }
        }
        return vector;
    }

    protected String filter(String string) {
        String string2 = string;
        if (string != null) {
            StringBuffer stringBuffer = new StringBuffer();
            Vector vector = this.locateTags(string);
            int n = 0;
            for (int i = 0; i < vector.size(); ++i) {
                Object[] objectArray = (Object[])vector.get(i);
                int n2 = (Integer)objectArray[0];
                int n3 = (Integer)objectArray[1];
                String string3 = (String)objectArray[2];
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                n = n2 + n3;
            }
            stringBuffer.append(string.substring(n));
            string2 = stringBuffer.substring(0);
        }
        return string2;
    }

    protected void filter(String[] stringArray) {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = this.filter(stringArray[i]);
            }
        }
    }

    protected void filterDoc(TextActivityDocument textActivityDocument) throws BadLocationException {
        if (textActivityDocument != null) {
            Object object;
            Object object2;
            int n;
            String string = textActivityDocument.getText(0, textActivityDocument.getLength());
            Vector vector = this.locateTags(string);
            int n2 = vector.size();
            for (n = 0; n < n2; ++n) {
                object2 = (Object[])vector.get(n);
                object2[3] = textActivityDocument.createPosition((Integer)object2[0]);
            }
            for (n = 0; n < n2; ++n) {
                object2 = (Object[])vector.get(n);
                object = (Position)object2[3];
                int n3 = object.getOffset();
                int n4 = (Integer)object2[1];
                String string2 = (String)object2[2];
                AttributeSet attributeSet = textActivityDocument.getCharacterElement(n3).getAttributes();
                textActivityDocument.getLogicalStyle(n3);
                textActivityDocument.insertString(n3, string2, attributeSet);
                textActivityDocument.remove(n3 + string2.length(), n4);
            }
            this.filterActiveBagContent(textActivityDocument.boxesContent);
            this.filterActiveBagContent(textActivityDocument.popupsContent);
            if (textActivityDocument.tmb != null) {
                Iterator iterator = textActivityDocument.tmb.iterator();
                while (iterator.hasNext()) {
                    object2 = (TargetMarker)iterator.next();
                    object = object2.target;
                    if (object == null) continue;
                    ((TextTarget)object).iniText = this.filter(((TextTarget)object).iniText);
                    this.filter(((TextTarget)object).answer);
                    this.filter(((TextTarget)object).options);
                    this.filterActiveBoxContent(((TextTarget)object).popupContent);
                }
            }
        }
    }

    public void init(ResourceBridge resourceBridge, FileSystem fileSystem) {
        if (fileSystem != null && this.mapFileName != null) {
            try {
                InputStream inputStream = fileSystem.getInputStream(this.mapFileName);
                if (inputStream != null) {
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, this.fileCharset));
                    this.map = new HashMap();
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        int n = string.indexOf(61);
                        if (n <= 0) continue;
                        String string2 = StrUtils.secureString(string.substring(0, n)).trim();
                        String string3 = StrUtils.secureString(string.substring(n + 1)).trim();
                        if (string2.length() <= 0) continue;
                        this.map.put(string2, string3);
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Error initializing TagReplace: " + exception);
            }
        }
    }

    public void innerListReferences(HashMap hashMap) throws Exception {
        if (this.mapFileName != null) {
            hashMap.put(this.mapFileName, "external");
        }
    }
}

